/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.api.audit.Auditor;
import com.fluxtion.api.event.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

public class TestAuditor
implements Auditor {
    private ArrayList<Class> eventStore;
    private ArrayList<CallbackAudit> callBackStore;
    private HashMap<String, Object> nodeMap;
    private boolean processingComplete;

    public void nodeRegistered(Object node, String nodeName) {
        this.nodeMap.put(nodeName, node);
    }

    public void eventReceived(Object event) {
        this.eventStore.add(event.getClass());
        this.processingComplete = false;
    }

    public void eventReceived(Event event) {
        this.eventStore.add(event.getClass());
        this.processingComplete = false;
    }

    public void processingComplete() {
        this.processingComplete = true;
    }

    public void init() {
        this.nodeMap = new HashMap();
        this.eventStore = new ArrayList();
        this.callBackStore = new ArrayList();
        this.processingComplete = false;
    }

    public void tearDown() {
    }

    public void nodeInvoked(Object node, String nodeName, String methodName, Object event) {
        this.callBackStore.add(new CallbackAudit(node, nodeName, methodName, event));
    }

    public boolean auditInvocations() {
        return true;
    }

    public void matchRegisteredNodes(String ... nodes) {
        Assert.assertThat(this.nodeMap.keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])nodes));
    }

    public void matchEvents(Class ... events) {
        Assert.assertThat(this.eventStore, (Matcher)IsIterableContainingInOrder.contains((Object[])events));
    }

    public void matchCallbackMethodOrderPartial(String ... methods) {
        List methodList = this.callBackStore.stream().map(CallbackAudit::getMethodName).collect(Collectors.toList());
        int idx = 0;
        for (String method : methods) {
            int findIdx = methodList.subList(idx, methodList.size()).indexOf(method) + idx;
            if (findIdx < 0) {
                throw new AssertionError((Object)("missing items expected:" + method + " in list " + methodList));
            }
            if (findIdx < idx) {
                throw new AssertionError((Object)("missing items expected:" + Arrays.toString(methods) + " in list " + methodList + " index:" + idx));
            }
            ++idx;
        }
    }

    public void matchCallbackMethod(String ... methods) {
        List methodList = this.callBackStore.stream().map(CallbackAudit::getMethodName).collect(Collectors.toList());
        Assert.assertThat(methodList, (Matcher)IsIterableContainingInOrder.contains((Object[])methods));
    }

    public boolean isProcessingComplete() {
        return this.processingComplete;
    }

    public void clearEventStores() {
        this.callBackStore.clear();
        this.eventStore.clear();
    }

    private static class CallbackAudit {
        Object node;
        Class nodeClass;
        String nodeName;
        String methodName;
        Object event;
        Class eventClass;

        public CallbackAudit(Object node, String nodeName, String methodName, Object event) {
            this.node = node;
            this.nodeName = nodeName;
            this.methodName = methodName;
            this.event = event;
            this.nodeClass = node.getClass();
            this.eventClass = event.getClass();
        }

        public Object getNode() {
            return this.node;
        }

        public void setNode(Object node) {
            this.node = node;
        }

        public Class getNodeClass() {
            return this.nodeClass;
        }

        public void setNodeClass(Class nodeClass) {
            this.nodeClass = nodeClass;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public Object getEvent() {
            return this.event;
        }

        public void setEvent(Object event) {
            this.event = event;
        }

        public Class getEventClass() {
            return this.eventClass;
        }

        public void setEventClass(Class eventClass) {
            this.eventClass = eventClass;
        }
    }
}

