/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.audit;

import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.TearDown;
import com.fluxtion.api.audit.Auditor;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import com.fluxtion.test.event.EventHandlerCb;
import com.fluxtion.test.event.NodeWithParentList;
import com.fluxtion.test.event.TestEvent;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RegistrationListenerTest
extends BaseSepTest {
    @Test
    public void testAudit() {
        this.buildAndInitSep(ParentListProcessorSep.class);
        MyNodeAudit auditNode = (MyNodeAudit)this.getField("myAuditor");
        Assert.assertThat((Object)auditNode.registeredNodes.size(), (Matcher)CoreMatchers.is((Object)5));
        this.onEvent((Event)new TestEvent(1));
        Assert.assertThat((Object)auditNode.invokeCount, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testAuditInline() {
        this.buildAndInitSep(ParentListProcessorSepInline.class);
        MyNodeAudit auditNode = (MyNodeAudit)this.getField("myAuditor");
        Assert.assertThat((Object)auditNode.registeredNodes.size(), (Matcher)CoreMatchers.is((Object)5));
        this.onEvent((Event)new TestEvent(1));
        Assert.assertThat((Object)auditNode.invokeCount, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testNoAuditInline() {
        this.buildAndInitSep(ParentListProcessorSepInlineNoNodeAudit.class);
        MyNodeAudit auditNode = (MyNodeAudit)this.getField("myAuditor");
        Assert.assertThat((Object)auditNode.registeredNodes.size(), (Matcher)CoreMatchers.is((Object)5));
        this.onEvent((Event)new TestEvent(1));
        Assert.assertThat((Object)auditNode.invokeCount, (Matcher)CoreMatchers.is((Object)0));
    }

    public static class ParentListProcessorSepInlineNoNodeAudit
    extends SEPConfig {
        public ParentListProcessorSepInlineNoNodeAudit() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            NodeWithParentList root = (NodeWithParentList)this.addPublicNode(new NodeWithParentList(e1, e2, e3), "root");
            root.parentsNoType.add(this.addNode(new SimpleNode()));
            ((MyNodeAudit)this.addAuditor((Auditor)new MyNodeAudit(), (String)"myAuditor")).audit = false;
            this.inlineEventHandling = true;
        }
    }

    public static class ParentListProcessorSepInline
    extends SEPConfig {
        public ParentListProcessorSepInline() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            NodeWithParentList root = (NodeWithParentList)this.addPublicNode(new NodeWithParentList(e1, e2, e3), "root");
            root.parentsNoType.add(this.addNode(new SimpleNode()));
            this.addAuditor(new MyNodeAudit(), "myAuditor");
            this.inlineEventHandling = true;
        }
    }

    public static class ParentListProcessorSep
    extends SEPConfig {
        public ParentListProcessorSep() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            NodeWithParentList root = (NodeWithParentList)this.addPublicNode(new NodeWithParentList(e1, e2, e3), "root");
            root.parentsNoType.add(this.addNode(new SimpleNode()));
            this.addAuditor(new MyNodeAudit(), "myAuditor");
        }
    }

    public static class SimpleNode {
        @OnEvent
        public void event() {
        }

        @Initialise
        public void init() {
        }

        @TearDown
        public void tearDown() {
        }
    }

    public static class MyNodeAudit
    implements Auditor {
        public HashMap<String, Object> registeredNodes = new HashMap();
        public transient int invokeCount;
        public transient boolean audit = true;

        public void nodeRegistered(Object node, String nodeName) {
            this.registeredNodes.put(nodeName, node);
        }

        public boolean auditInvocations() {
            return this.audit;
        }

        public void nodeInvoked(Object node, String nodeName, String methodName, Object typedEvent) {
            ++this.invokeCount;
        }
    }
}

