/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.audit;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Inject;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.audit.Auditor;
import com.fluxtion.api.audit.EventLogControlEvent;
import com.fluxtion.api.audit.EventLogManager;
import com.fluxtion.api.audit.EventLogNode;
import com.fluxtion.api.audit.LogRecordListener;
import com.fluxtion.api.audit.StructuredLogRecord;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import com.fluxtion.generator.util.YamlLogRecordListener;
import com.fluxtion.test.event.CharEvent;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TraceLogTest
extends BaseSepInprocessTest {
    @Test
    public void testNoTrace() {
        this.fixedPkg = true;
        YamlLogRecordListener yamlRecord = new YamlLogRecordListener();
        this.sep((SEPConfig c) -> {
            ParentNode parent = (ParentNode)((Object)((Object)c.addNode((Object)new ParentNode(), "parent")));
            ChildNode child = (ChildNode)((Object)((Object)c.addNode((Object)new ChildNode(parent), "child")));
            GrandChildNode grandChild = (GrandChildNode)((Object)((Object)c.addNode((Object)new GrandChildNode(child), "grandChild")));
            c.addNode((Object)new GreatGrandChildNode(grandChild), "greatGrandChild");
            c.addAuditor((Auditor)new EventLogManager(), "sampleLogger");
        });
        this.onEvent(new EventLogControlEvent((LogRecordListener)yamlRecord));
        this.onEvent((Object)new CharEvent('a'));
        List eventList = yamlRecord.getEventList();
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)eventList.size()));
        Assert.assertThat((Object)"CharEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(0)).getEventType()));
        List auditLogs = ((StructuredLogRecord)eventList.get(0)).getAuditLogs();
        Assert.assertThat((Object)2, (Matcher)CoreMatchers.is((Object)auditLogs.size()));
        Assert.assertThat((Object)"parent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getNodeId()));
        Assert.assertThat((Object)"child", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(1)).getNodeId()));
        Assert.assertThat((Object)"a", (Matcher)CoreMatchers.is(((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getPropertyMap().get("char")));
    }

    @Test
    public void testWithTrace() {
        this.fixedPkg = true;
        YamlLogRecordListener yamlRecord = new YamlLogRecordListener();
        this.sep((SEPConfig c) -> {
            ParentNode parent = (ParentNode)((Object)((Object)c.addNode((Object)new ParentNode(), "parent")));
            ChildNode child = (ChildNode)((Object)((Object)c.addNode((Object)new ChildNode(parent), "child")));
            GrandChildNode grandChild = (GrandChildNode)((Object)((Object)c.addNode((Object)new GrandChildNode(child), "grandChild")));
            c.addNode((Object)new GreatGrandChildNode(grandChild), "greatGrandChild");
            c.addAuditor((Auditor)new EventLogManager().tracingOn(EventLogControlEvent.LogLevel.INFO), "sampleLogger");
        });
        this.onEvent(new EventLogControlEvent((LogRecordListener)yamlRecord));
        this.onEvent((Object)new CharEvent('b'));
        List eventList = yamlRecord.getEventList();
        Assert.assertThat((Object)2, (Matcher)CoreMatchers.is((Object)eventList.size()));
        Assert.assertThat((Object)"EventLogControlEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(0)).getEventType()));
        Assert.assertThat((Object)"CharEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(1)).getEventType()));
        List auditLogs = ((StructuredLogRecord)eventList.get(1)).getAuditLogs();
        Assert.assertThat((Object)auditLogs.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)"parent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getNodeId()));
        Assert.assertThat((Object)"child", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(1)).getNodeId()));
        Assert.assertThat((Object)"grandChild", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(2)).getNodeId()));
        Assert.assertThat((Object)"greatGrandChild", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(3)).getNodeId()));
        Assert.assertThat((Object)"b", (Matcher)CoreMatchers.is(((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getPropertyMap().get("char")));
    }

    @Test
    public void testWithTraceFinestLevel() {
        this.fixedPkg = true;
        YamlLogRecordListener yamlRecord = new YamlLogRecordListener();
        this.sep((SEPConfig c) -> {
            ParentNode parent = (ParentNode)((Object)((Object)c.addNode((Object)new ParentNode(), "parent")));
            ChildNode child = (ChildNode)((Object)((Object)c.addNode((Object)new ChildNode(parent), "child")));
            GrandChildNode grandChild = (GrandChildNode)((Object)((Object)c.addNode((Object)new GrandChildNode(child), "grandChild")));
            c.addNode((Object)new GreatGrandChildNode(grandChild), "greatGrandChild");
            c.addAuditor((Auditor)new EventLogManager().tracingOn(EventLogControlEvent.LogLevel.TRACE), "sampleLogger");
        });
        this.onEvent(new EventLogControlEvent((LogRecordListener)yamlRecord));
        this.onEvent((Object)new CharEvent('c'));
        this.onEvent(new EventLogControlEvent(EventLogControlEvent.LogLevel.TRACE));
        this.onEvent((Object)new CharEvent('d'));
        List eventList = yamlRecord.getEventList();
        Assert.assertThat((Object)4, (Matcher)CoreMatchers.is((Object)eventList.size()));
        Assert.assertThat((Object)"CharEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(1)).getEventType()));
        List auditLogs = ((StructuredLogRecord)eventList.get(1)).getAuditLogs();
        Assert.assertThat((Object)2, (Matcher)CoreMatchers.is((Object)auditLogs.size()));
        Assert.assertThat((Object)"parent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getNodeId()));
        Assert.assertThat((Object)"child", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(1)).getNodeId()));
        Assert.assertThat((Object)"c", (Matcher)CoreMatchers.is(((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getPropertyMap().get("char")));
        Assert.assertThat((Object)"EventLogControlEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(0)).getEventType()));
        Assert.assertThat((Object)"EventLogControlEvent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord)eventList.get(2)).getEventType()));
        auditLogs = ((StructuredLogRecord)eventList.get(3)).getAuditLogs();
        Assert.assertThat((Object)auditLogs.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)"parent", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getNodeId()));
        Assert.assertThat((Object)"child", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(1)).getNodeId()));
        Assert.assertThat((Object)"grandChild", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(2)).getNodeId()));
        Assert.assertThat((Object)"greatGrandChild", (Matcher)CoreMatchers.is((Object)((StructuredLogRecord.AuditRecord)auditLogs.get(3)).getNodeId()));
        Assert.assertThat((Object)"d", (Matcher)CoreMatchers.is(((StructuredLogRecord.AuditRecord)auditLogs.get(0)).getPropertyMap().get("char")));
    }

    public static class MyNode {
        public boolean registerCalled = false;
    }

    public static class GreatGrandChildNode {
        private final GrandChildNode parent;

        public GreatGrandChildNode(GrandChildNode parent) {
            this.parent = parent;
        }

        @OnEvent
        public void onEvent() {
        }
    }

    public static class GrandChildNode
    extends EventLogNode {
        private final ChildNode parent;

        public GrandChildNode(ChildNode parent) {
            this.parent = parent;
        }

        @OnEvent
        public void onEvent() {
        }
    }

    public static class ChildNode
    extends EventLogNode {
        private final ParentNode parent;

        public ChildNode(ParentNode parent) {
            this.parent = parent;
        }

        @OnEvent
        public void onEvent() {
            this.log.info("child", true);
        }
    }

    public static class ParentNode
    extends EventLogNode {
        @Inject
        public MyNode myNode;

        @EventHandler
        public void charEvent(CharEvent event) {
            this.log.info("char", event.getChar());
        }
    }
}

