/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.constructor;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public class ConstructorTest
extends BaseSepTest {
    @Test
    public void testConstructorSimple() {
        this.buildAndInitSep(ConstructorBuilder.class);
    }

    @Test
    public void testConstructorWithCollection() {
        this.buildAndInitSep(ConstructorCollectionBuilder.class);
    }

    @Test
    public void testConstructorForClass() {
        this.buildAndInitSep(ClassHolderBuilder.class);
    }

    @Test
    public void testPrimitiveCollection() {
        this.buildAndInitSep(PrimitiveCollectionsBuilder.class);
    }

    public static final class ConstructorCollectionBuilder
    extends SEPConfig {
        public void buildConfig() {
            List<OrderHandler> orderhandlerList = Arrays.asList((OrderHandler)this.addNode(new OrderHandler("orderHandler_1", 200000000L, 1.2f)), (OrderHandler)this.addNode(new OrderHandler("orderHandler_2", 400000000L, 1.4f)), (OrderHandler)this.addNode(new OrderHandler("orderHandler_3", 600000000L, 1.6f)));
            ConfigPublisher publisher = (ConfigPublisher)this.addPublicNode(new ConfigPublisher("MyOrderManager", 55, orderhandlerList, (OrderHandler)this.addNode(new OrderHandler("orderHandler_11", 200000000L, 1.0567f)), (ConfigHandler)this.addNode(new ConfigHandler("config_1")), (ConfigHandler)this.addNode(new ConfigHandler("config_2"))), "publisher");
            NameHolder nameHolder = (NameHolder)this.addNode(new NameHolder("nameHolder", publisher));
            nameHolder.setOrderHandler(orderhandlerList.get(1));
            nameHolder.setId(NameHolder.NAMES.WAY);
            nameHolder.setHandlerList(Arrays.asList(orderhandlerList.get(1), orderhandlerList.get(2)));
            nameHolder.setMatchingRegex("reerer", "lkdjf", "ldkljflkj");
        }
    }

    public static final class ConstructorBuilder
    extends SEPConfig {
        public void buildConfig() {
            ConfigPublisher publisher = (ConfigPublisher)this.addPublicNode(new ConfigPublisher((OrderHandler)this.addNode(new OrderHandler("orderHandler_1", 200000000L, 1.0567f)), (ConfigHandler)this.addNode(new ConfigHandler("config_1")), (ConfigHandler)this.addNode(new ConfigHandler("config_2"))), "publisher");
            publisher.publicHandler = (ConfigHandler)this.addNode(new ConfigHandler("config_public_1"));
        }
    }

    public static final class PrimitiveCollectionsBuilder
    extends SEPConfig {
        public void buildConfig() {
            this.addNode(new PrimitiveCollections(new boolean[]{true, true, false}, Arrays.asList(1, 2, 3, 4, 5), new String[]{"one", "two"}));
        }
    }

    public static final class ClassHolderBuilder
    extends SEPConfig {
        public void buildConfig() {
            this.addNode(new MyClassHolder(String.class));
        }
    }

    public static class MyClassHolder {
        private final Class clazz;

        public MyClassHolder(Class clazz) {
            this.clazz = clazz;
        }

        @EventHandler
        public void newOrderEvent(NewOrderEvent configEvent) {
        }
    }

    public static final class ConfigPublisher {
        private final ConfigHandler configHandler;
        private final ConfigHandler configHandler_2;
        private final OrderHandler orderHandler;
        private final List<OrderHandler> handlers;
        private final int totalOrders;
        private final String name;
        public ConfigHandler publicHandler;

        public ConfigPublisher(OrderHandler orderHandler, ConfigHandler configHandler, ConfigHandler configHandler_2) {
            this(null, 0, null, orderHandler, configHandler, configHandler_2);
        }

        public ConfigPublisher(int totalOrders, OrderHandler orderHandler, ConfigHandler configHandler, ConfigHandler configHandler_2) {
            this(null, totalOrders, null, orderHandler, configHandler, configHandler_2);
        }

        public ConfigPublisher(String name, int totalOrders, OrderHandler orderHandler, ConfigHandler configHandler, ConfigHandler configHandler_2) {
            this(name, totalOrders, null, orderHandler, configHandler, configHandler_2);
        }

        public ConfigPublisher(List<OrderHandler> handlers, OrderHandler orderHandler, ConfigHandler configHandler, ConfigHandler configHandler_2) {
            this(null, 0, handlers, orderHandler, configHandler, configHandler_2);
        }

        public ConfigPublisher(int totalOrders) {
            this(null, totalOrders, null, null, null, null);
        }

        public ConfigPublisher(String name, int totalOrders, List<OrderHandler> handlers, OrderHandler orderHandler, ConfigHandler configHandler, ConfigHandler configHandler_2) {
            this.handlers = handlers;
            this.orderHandler = orderHandler;
            this.configHandler = configHandler;
            this.configHandler_2 = configHandler_2;
            this.totalOrders = totalOrders;
            this.name = name == null ? "no name" : name;
        }

        @OnEvent
        public void publishConfig() {
        }

        public int getTotalOrders() {
            return this.totalOrders;
        }

        public String getName() {
            return this.name;
        }

        public OrderHandler getHandlerByName(String name) {
            return this.handlers.stream().filter(o -> ((OrderHandler)o).name.equals(name)).findAny().get();
        }
    }

    public static final class OrderHandler {
        private final String name;
        private final long maxOrderSize;
        private final float minRate;
        private long time = 200L;
        private char c = (char)100;
        private char nn;
        private int intVal;
        private transient byte bVal = (byte)9;
        private double myDouble = Double.NaN;

        public OrderHandler(String name, long maxOrderSize, float minRate) {
            this.name = name;
            this.maxOrderSize = maxOrderSize;
            this.minRate = minRate;
        }

        @EventHandler
        public void newOrderEvent(NewOrderEvent configEvent) {
        }

        public String getName() {
            return this.name;
        }

        public long getMaxOrderSize() {
            return this.maxOrderSize;
        }

        public float getMinRate() {
            return this.minRate;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public char getC() {
            return this.c;
        }

        public void setC(char c) {
            this.c = c;
        }

        public char getNn() {
            return this.nn;
        }

        public void setNn(char nn) {
            this.nn = nn;
        }

        public int getIntVal() {
            return this.intVal;
        }

        public void setIntVal(int intVal) {
            this.intVal = intVal;
        }

        public byte getbVal() {
            return this.bVal;
        }

        public void setbVal(byte bVal) {
            this.bVal = bVal;
        }

        public double getMyDouble() {
            return this.myDouble;
        }

        public void setMyDouble(double myDouble) {
            this.myDouble = myDouble;
        }
    }

    public static final class NameHolder {
        public final String name;
        private final ConfigPublisher publisher;
        private OrderHandler orderHandler;
        private NAMES id;
        private List<OrderHandler> handlerList;
        private String[] matchingRegex;
        private String[] matchingRegex2;

        public List<OrderHandler> getHandlerList() {
            return this.handlerList;
        }

        public void setHandlerList(List<OrderHandler> handlerList) {
            this.handlerList = handlerList;
        }

        public NameHolder(String name, ConfigPublisher publisher) {
            this.name = name;
            this.publisher = publisher;
        }

        public OrderHandler getOrderHandler() {
            return this.orderHandler;
        }

        public void setOrderHandler(OrderHandler orderHandler) {
            this.orderHandler = orderHandler;
        }

        public NAMES getId() {
            return this.id;
        }

        public void setId(NAMES id) {
            this.id = id;
        }

        @OnEvent
        public void processEvent() {
        }

        public String[] getMatchingRegex() {
            return this.matchingRegex;
        }

        public void setMatchingRegex(String ... matchingRegex) {
            this.matchingRegex = matchingRegex;
        }

        public String[] getMatchingRegex2() {
            return this.matchingRegex2;
        }

        public void setMatchingRegex2(String[] matchingRegex2) {
            this.matchingRegex2 = matchingRegex2;
        }

        public static enum NAMES {
            TEST,
            WAY;

        }
    }

    public static class PrimitiveCollections {
        private final boolean[] booleanFinalProp;
        private final List<Integer> intFinalProp;
        private final String[] stringFinalProp;

        public PrimitiveCollections(boolean[] booleanFinalProp, List<Integer> intFinalProp, String[] stringFinalProp) {
            this.booleanFinalProp = booleanFinalProp;
            this.intFinalProp = intFinalProp;
            this.stringFinalProp = stringFinalProp;
        }

        @EventHandler
        public void configEvent(ConfigEvent configEvent) {
        }
    }

    public static final class ConfigHandler {
        private final String name;

        public ConfigHandler(String name) {
            this.name = name;
        }

        @EventHandler
        public void configEvent(ConfigEvent configEvent) {
        }
    }

    public static final class NewOrderEvent
    implements Event {
    }

    public static final class ConfigEvent
    implements Event {
    }
}

