/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.constructor;

import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class EscapeStringTest
extends BaseSepInprocessTest {
    private static String c1 = "\"t\t";
    private static String pubString = "''t\t\n\"\\";
    private static String propString = "''t\t\n\"\"\u00a3";
    private static final List<String> STRING_LIST = Arrays.asList("fhfh", "\"", "\t{}@~\\");
    private static final List<String> stringListProp = Arrays.asList("\"\\", "\t%\n");
    private static final String[] arrVals = new String[]{"\"", "e", "'#g\\\u00a3"};

    @Test
    public void escapeTest() {
        this.sep((SEPConfig cfg) -> {
            SampleData data = new SampleData(c1);
            SampleData data2 = new SampleData("hhh", STRING_LIST, arrVals);
            data.pubString = pubString;
            data.setPropString(propString);
            data.setStringListProp(stringListProp);
            cfg.addPublicNode((Object)data, "data");
            cfg.addPublicNode((Object)data2, "data2");
            cfg.addPublicNode((Object)new CharData('\n'), "charData");
        });
        SampleData data1 = (SampleData)this.getField("data");
        SampleData data2 = (SampleData)this.getField("data2");
        CharData charData = (CharData)this.getField("charData");
        Assert.assertEquals((Object)c1, (Object)data1.c1);
        Assert.assertEquals((Object)pubString, (Object)data1.pubString);
        Assert.assertEquals((Object)propString, (Object)data1.getPropString());
        Assert.assertEquals(stringListProp, data1.getStringListProp());
        Assert.assertEquals(STRING_LIST, data2.stringList);
        Assert.assertArrayEquals((Object[])arrVals, (Object[])data2.arrVals);
        Assert.assertEquals((long)10L, (long)charData.getC());
    }

    @Test
    public void stringAsNode() {
        this.sep((SEPConfig cfg) -> {
            cfg.addNode((Object)"TEST", "str");
            cfg.addNode((Object)"\\u001%t", "str2");
        });
        Assert.assertEquals((Object)"TEST", this.getField("str"));
        Assert.assertEquals((Object)"\\u001%t", this.getField("str2"));
    }

    public static class SampleData {
        private final String c1;
        private final String[] arrVals;
        public List<String> stringList;
        private List<String> stringListProp;
        public String pubString;
        private String propString;

        public SampleData(String c1, List<String> stringList, String[] arrVals) {
            this.c1 = c1;
            this.stringList = stringList;
            this.arrVals = arrVals;
        }

        public SampleData(String c1, String[] arrVals) {
            this.c1 = c1;
            this.arrVals = arrVals;
            this.stringList = new ArrayList<String>();
        }

        public SampleData(String c1) {
            this(c1, null, null);
        }

        public String getPropString() {
            return this.propString;
        }

        public void setPropString(String propString) {
            this.propString = propString;
        }

        public List<String> getStringListProp() {
            return this.stringListProp;
        }

        public void setStringListProp(List<String> stringListProp) {
            this.stringListProp = stringListProp;
        }
    }

    public static class CharData {
        private final char c;

        public CharData(char c) {
            this.c = c;
        }

        public char getC() {
            return this.c;
        }
    }
}

