/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.declarative;

import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.DeclarativeNodeConiguration;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.Generator;
import com.fluxtion.generator.graphbuilder.NodeFactoryLocator;
import com.fluxtion.generator.model.Field;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.targets.SepJavaSourceModelHugeFilter;
import com.fluxtion.test.nodes.Calculator;
import com.fluxtion.test.nodes.CalculatorRegisteringAccumulatorFactory;
import com.fluxtion.test.nodes.DynamicallyGeneratedWindowNode;
import com.fluxtion.test.nodes.FailingWindowNodeFactory;
import com.fluxtion.test.nodes.KeyProcessorHistogram;
import com.fluxtion.test.nodes.WindowNode;
import com.fluxtion.test.nodes.WindowNodeFactory;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleDeclarativeTest {
    @Test
    @Ignore
    public void testSimpleBuild() throws Exception {
        Set class2Factory = NodeFactoryLocator.nodeFactorySet();
        HashMap<Class<KeyProcessorHistogram>, String> rootNodeMappings = new HashMap<Class<KeyProcessorHistogram>, String>();
        rootNodeMappings.put(KeyProcessorHistogram.class, "histogram");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, new HashMap());
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
    }

    @Test
    public void testGeneration() throws Exception {
        Set class2Factory = NodeFactoryLocator.nodeFactorySet();
        HashMap<Class<Calculator>, String> rootNodeMappings = new HashMap<Class<Calculator>, String>();
        rootNodeMappings.put(Calculator.class, "calculator");
        GenerationContext.setupStaticContext((String)"com.fluxtion.test.template.java", (String)"SimpleCalculator", (File)new File("target/generated-test-sources/java/"), (File)new File("target/generated-test-sources/resources/"));
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, new HashMap());
        SEPConfig cfg = new SEPConfig();
        cfg.templateFile = "javaTemplate.vsl";
        cfg.declarativeConfig = config;
        cfg.inlineEventHandling = true;
        cfg.generateDescription = false;
        Generator generator = new Generator();
        generator.templateSep(cfg);
    }

    @Test
    public void testFactoryOverride() throws Exception {
        HashSet<Class<FailingWindowNodeFactory>> class2Factory = new HashSet<Class<FailingWindowNodeFactory>>();
        class2Factory.add(FailingWindowNodeFactory.class);
        HashSet<WindowNodeFactory> factorySet = new HashSet<WindowNodeFactory>();
        factorySet.add(new WindowNodeFactory());
        HashMap<Class<WindowNode>, String> rootNodeMappings = new HashMap<Class<WindowNode>, String>();
        rootNodeMappings.put(WindowNode.class, "windowNode");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, null, factorySet);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        junit.framework.Assert.assertEquals((int)1, (int)instance.getInstanceMap().size());
        junit.framework.Assert.assertEquals((int)1, (int)instance.getSortedDependents().size());
        junit.framework.Assert.assertEquals(WindowNode.class, instance.getInstanceMap().keySet().toArray()[0].getClass());
    }

    @Test
    public void testFactoryInstanceInjection() throws Exception {
        HashSet class2Factory = new HashSet();
        HashSet<CalculatorRegisteringAccumulatorFactory> factorySet = new HashSet<CalculatorRegisteringAccumulatorFactory>();
        factorySet.add(new CalculatorRegisteringAccumulatorFactory());
        HashMap<Class<Calculator>, String> rootNodeMappings = new HashMap<Class<Calculator>, String>();
        rootNodeMappings.put(Calculator.class, "calcInjecting");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, null, factorySet);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        junit.framework.Assert.assertEquals((int)2, (int)instance.getInstanceMap().size());
        junit.framework.Assert.assertEquals((int)2, (int)instance.getSortedDependents().size());
        Assert.assertTrue((boolean)instance.getInstanceMap().containsValue("accumulator"));
        Assert.assertTrue((boolean)instance.getInstanceMap().containsValue("calcInjecting"));
    }

    @Test
    public void testClassOverride() throws Exception {
        HashSet<Class<FailingWindowNodeFactory>> class2Factory = new HashSet<Class<FailingWindowNodeFactory>>();
        class2Factory.add(FailingWindowNodeFactory.class);
        HashSet<WindowNodeFactory> factorySet = new HashSet<WindowNodeFactory>();
        factorySet.add(new WindowNodeFactory());
        HashMap<Class<WindowNode>, String> rootNodeMappings = new HashMap<Class<WindowNode>, String>();
        rootNodeMappings.put(WindowNode.class, "windowNode");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, null, factorySet);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        Object x = instance.getSortedDependents().get(0);
        HashMap classMap = new HashMap();
        classMap.put(x, "MyMadeUpClass");
        SimpleEventProcessorModel model = new SimpleEventProcessorModel(instance, null, classMap);
        model.generateMetaModel();
        Field mappedField = model.getFieldForInstance(x);
        junit.framework.Assert.assertEquals((String)"MyMadeUpClass", (String)mappedField.fqn);
    }

    @Test(expected=Exception.class)
    public void testFactoryFailsOverride() throws Exception {
        HashSet<Class<FailingWindowNodeFactory>> class2Factory = new HashSet<Class<FailingWindowNodeFactory>>();
        class2Factory.add(FailingWindowNodeFactory.class);
        HashSet factorySet = new HashSet();
        HashMap<Class<WindowNode>, String> rootNodeMappings = new HashMap<Class<WindowNode>, String>();
        rootNodeMappings.put(WindowNode.class, "windowNode");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, class2Factory, null, factorySet);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
    }

    @Test
    public void testGenerateDerivedDataNode() throws Exception {
        HashSet<WindowNodeFactory> factorySet = new HashSet<WindowNodeFactory>();
        factorySet.add(new WindowNodeFactory());
        HashMap<Class<WindowNode>, String> rootNodeMappings = new HashMap<Class<WindowNode>, String>();
        rootNodeMappings.put(WindowNode.class, "windowNode");
        DeclarativeNodeConiguration config = new DeclarativeNodeConiguration(rootNodeMappings, null, null, factorySet);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        Object x = instance.getSortedDependents().get(0);
        HashMap classMap = new HashMap();
        classMap.put(x, DynamicallyGeneratedWindowNode.class.getCanonicalName());
        SimpleEventProcessorModel model = new SimpleEventProcessorModel(instance, null, classMap);
        model.generateMetaModel();
        String outputPackage = "com.fluxtion.test.derived.java";
        String className = "TestDerived";
        File outputDirectory = new File("target/generated-test-sources/java/");
        outputDirectory = new File(outputDirectory, outputPackage.replace(".", "/"));
        outputDirectory.mkdirs();
        String templateFile = "javaTemplate.vsl";
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
        SepJavaSourceModelHugeFilter srcModel = new SepJavaSourceModelHugeFilter(model, false);
        srcModel.buildSourceModel();
        Template template = Velocity.getTemplate((String)templateFile);
        VelocityContext ctx = new VelocityContext();
        ctx.put("MODEL", (Object)srcModel);
        ctx.put("package", (Object)outputPackage);
        ctx.put("className", (Object)className);
        File outFile = new File(outputDirectory, className + ".java");
        FileWriter templateWriter = new FileWriter(outFile);
        template.merge((Context)ctx, (Writer)templateWriter);
        templateWriter.flush();
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSourceTree(outputDirectory);
        JavaClass genClass = builder.getClassByName(outputPackage + "." + className);
        JavaField rootField = genClass.getFieldByName("windowNode");
        junit.framework.Assert.assertNotNull((Object)rootField);
        Type actualType = rootField.getType();
        Type expecteType = new Type(DynamicallyGeneratedWindowNode.class.getName());
        junit.framework.Assert.assertEquals((Object)expecteType, (Object)actualType);
    }
}

