/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.evenpublisher;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.event.Event;
import com.fluxtion.api.event.EventPublsher;
import com.fluxtion.api.event.RegisterEventHandler;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import java.util.concurrent.atomic.LongAdder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class EventPublisherTest
extends BaseSepInprocessTest {
    @Test
    public void testAudit() {
        this.sep((SEPConfig c) -> {
            GreaterThan gt_10 = (GreaterThan)c.addNode((Object)new GreaterThan(10));
            EventPublsher publisher = (EventPublsher)c.addPublicNode((Object)new EventPublsher(), "publisher");
            publisher.addEventSource((Object)gt_10);
            c.formatSource = true;
        });
        LongAdder adder = new LongAdder();
        this.sep.onEvent((Object)new RegisterEventHandler(e -> adder.increment()));
        this.sep.onEvent((Object)new NumberEvent(12));
        this.sep.onEvent((Object)new NumberEvent(3));
        Assert.assertThat((Object)adder.intValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    public static class GreaterThan
    implements Event {
        public int barrier;

        public GreaterThan() {
        }

        public GreaterThan(int barrier) {
            this.barrier = barrier;
        }

        @EventHandler
        public boolean isGreaterThan(NumberEvent number) {
            return number.value > this.barrier;
        }

        public String toString() {
            return "GreaterThan{barrier=" + this.barrier + '}';
        }
    }

    public static class NumberEvent
    implements Event {
        public final int value;

        public NumberEvent(int value) {
            this.value = value;
        }
    }
}

