/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.filter;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.event.DefaultEvent;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FIlteringTest
extends BaseSepInprocessTest {
    @Test
    public void testClassFilter() {
        this.sep((SEPConfig cfg) -> cfg.addPublicNode((Object)new TestHandler(), "handler"));
        TestHandler testHandler = (TestHandler)this.getField("handler");
        this.onEvent((Object)new ClassFilterEvent(String.class));
        this.onEvent((Object)new ClassFilterEvent(Double.class));
        Assert.assertThat((Object)testHandler.count, (Matcher)CoreMatchers.is((Object)1));
        this.onEvent((Object)new WordEvent("A"));
        this.onEvent((Object)new WordEvent("A"));
        this.onEvent((Object)new WordEvent("B"));
        this.onEvent((Object)new WordEvent("A"));
        this.onEvent((Object)new WordEvent("B"));
        this.onEvent((Object)new WordEvent("ignored"));
        this.onEvent((Object)new WordEvent("disregard"));
        Assert.assertThat((Object)testHandler.wordACount, (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)testHandler.wordBCount, (Matcher)CoreMatchers.is((Object)2));
    }

    public static class TestHandler {
        public int count = 0;
        public int wordACount = 0;
        public int wordBCount = 0;
        public transient String filterA = "A";
        public transient String filterB = "B";

        @EventHandler(filterStringFromClass=String.class)
        public void handleEvent(ClassFilterEvent event) {
            ++this.count;
        }

        @EventHandler(filterVariable="filterA")
        public void processWordA(WordEvent wordA) {
            ++this.wordACount;
        }

        @EventHandler(filterVariable="filterB")
        public void processWordB(WordEvent wordB) {
            ++this.wordBCount;
        }
    }

    public static class WordEvent
    extends DefaultEvent {
        public WordEvent(String word) {
            this.filterString = word;
        }
    }

    public static class ClassFilterEvent
    extends DefaultEvent {
        public ClassFilterEvent(Class clazz) {
            this.filterString = clazz.getCanonicalName();
        }
    }
}

