/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.inject;

import com.fluxtion.api.annotations.Config;
import com.fluxtion.api.annotations.ConfigList;
import com.fluxtion.api.annotations.ConfigVariable;
import com.fluxtion.api.annotations.ConfigVariableList;
import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.FilterId;
import com.fluxtion.api.annotations.Inject;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.event.DefaultEvent;
import com.fluxtion.api.time.Clock;
import com.fluxtion.builder.node.NodeFactory;
import com.fluxtion.builder.node.NodeRegistry;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class InjectionTest
extends BaseSepInprocessTest {
    @Test
    public void testInjectionTree() {
        this.sep((SEPConfig cfg) -> cfg.addPublicNode((Object)new WordProcessor(), "wordProcessor"));
        WordProcessor processor = (WordProcessor)this.getField("wordProcessor");
        this.sep.onEvent((Object)new CharEvent('c'));
        Assert.assertTrue((boolean)processor.testAndClear(0, Character.valueOf('c')));
        this.sep.onEvent((Object)new CharEvent('1'));
        Assert.assertTrue((boolean)processor.testAndClear(1, Character.valueOf('0')));
        this.sep.onEvent((Object)new CharEvent('h'));
        Assert.assertTrue((boolean)processor.testAndClear(0, Character.valueOf('0')));
        this.sep.onEvent((Object)new CharEvent('b'));
        Assert.assertTrue((boolean)processor.testAndClear(0, Character.valueOf('b')));
        this.sep.onEvent((Object)new CharEvent('4'));
        Assert.assertTrue((boolean)processor.testAndClear(4, Character.valueOf('0')));
    }

    @Test
    public void testInjectionNoFactoryTree() {
        this.sep((SEPConfig cfg) -> cfg.addPublicNode((Object)new WordProcessorNoFactory(), "wordProcessor"));
        WordProcessorNoFactory processor = (WordProcessorNoFactory)this.getField("wordProcessor");
        Assert.assertEquals((long)34L, (long)processor.handler.intVal);
        Assert.assertEquals((Object)"someName", (Object)processor.handler.stringVal);
    }

    @Test
    public void testInjectionNoFactoryVariablConfigTree() {
        this.sep((SEPConfig cfg) -> cfg.addPublicNode((Object)new WordProcessorNoFactoryVariableConfig(), "wordProcessor"));
        WordProcessorNoFactoryVariableConfig processor = (WordProcessorNoFactoryVariableConfig)this.getField("wordProcessor");
        Assert.assertEquals((long)10L, (long)processor.handler.intVal);
        Assert.assertEquals((Object)"variable val", (Object)processor.handler.stringVal);
    }

    @Test
    public void injectFinalField() {
        this.sep((SEPConfig cfg) -> cfg.addPublicNode((Object)new InjectClockWithSetter(), "injectedClock"));
        InjectClockWithSetter inj = (InjectClockWithSetter)this.getField("injectedClock");
        Assert.assertNotNull((Object)inj.getClock());
    }

    public static class CharHandlerFactory
    implements NodeFactory<CharHandler> {
        public CharHandler createNode(Map arg0, NodeRegistry arg1) {
            if (arg0.containsKey("char")) {
                return new CharHandler(((String)arg0.get("char")).charAt(0));
            }
            return new CharHandler();
        }
    }

    public static class Char2IntFactory
    implements NodeFactory<Char2Int> {
        public Char2Int createNode(Map arg0, NodeRegistry arg1) {
            return new Char2Int();
        }
    }

    public static class CharHandler {
        @FilterId
        public int filterChar = Integer.MAX_VALUE;
        public char receivedChar;

        public CharHandler(char receivedChar) {
            this.filterChar = receivedChar;
            this.receivedChar = receivedChar;
        }

        public CharHandler() {
        }

        @EventHandler
        public void onChar(CharEvent charEvent) {
            this.receivedChar = (char)charEvent.filterId();
        }
    }

    public static class CharEvent
    extends DefaultEvent {
        public CharEvent(char filterChar) {
            this.filterId = filterChar;
        }
    }

    public static class Char2Int {
        @Inject
        public CharHandler handler;
        public int asInt;

        @OnEvent
        public boolean convert() {
            if (Character.isDigit(this.handler.receivedChar)) {
                this.asInt = this.handler.receivedChar - 48;
                return true;
            }
            this.asInt = Integer.MAX_VALUE;
            return false;
        }
    }

    public static class WordProcessor {
        @Inject
        @Config(key="char", value="c")
        public CharHandler handler_c;
        @Inject
        @Config(key="char", value="b")
        public CharHandler handler_b;
        @Inject
        public Char2Int char2Int;
        private Integer receivedInt = 0;
        private Character receivedChar = Character.valueOf('0');

        @OnParentUpdate
        public void onDigit(Char2Int char2Int) {
            this.receivedInt = char2Int.asInt;
        }

        @OnParentUpdate
        public void charUpdated(CharHandler charHandler) {
            this.receivedChar = Character.valueOf(charHandler.receivedChar);
        }

        @OnEvent
        public void onEvent() {
        }

        public boolean testAndClear(Integer i, Character c) {
            boolean match = i.equals(this.receivedInt) & c.equals(this.receivedChar);
            this.receivedInt = 0;
            this.receivedChar = Character.valueOf('0');
            return match;
        }
    }

    public static class WordProcessorNoFactory {
        @Inject
        @ConfigList(value={@Config(key="intVal", value="34"), @Config(key="stringVal", value="someName")})
        public NoFactoryCharHandler handler;

        @OnEvent
        public void update() {
        }
    }

    public static class WordProcessorNoFactoryVariableConfig {
        public int parentIntVal = 10;
        public String parentStringVal = "variable val";
        @Inject
        @ConfigVariableList(value={@ConfigVariable(key="intVal", field="parentIntVal"), @ConfigVariable(key="stringVal", field="parentStringVal")})
        public NoFactoryCharHandler handler;

        @OnEvent
        public void update() {
        }
    }

    public static class NoFactoryCharHandler {
        private char receivedChar;
        public String stringVal;
        public int intVal;

        @EventHandler
        public void onChar(CharEvent charEvent) {
            this.receivedChar = (char)charEvent.filterId();
        }
    }

    public static class InjectClockWithSetter {
        @Inject
        private Clock clock;

        public Clock getClock() {
            return this.clock;
        }

        public void setClock(Clock clock) {
            this.clock = clock;
        }
    }
}

