/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.generator.model.DirtyFlag;
import com.fluxtion.generator.model.Field;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.test.event.AnnotatedEventHandlerDirtyNotifier;
import com.fluxtion.test.event.DirtyNotifierNode;
import com.fluxtion.test.event.EventHandlerCb;
import com.fluxtion.test.event.InitCB;
import com.fluxtion.test.event.RootCB;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;

public class DirtyFilteringTest {
    @Test
    public void testGetNodeGuardConditions() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        DirtyNotifierNode dirty_1 = new DirtyNotifierNode("dirty_1");
        DirtyNotifierNode dirty_2 = new DirtyNotifierNode("dirty_2");
        DirtyNotifierNode dirty_3 = new DirtyNotifierNode("dirty_3");
        RootCB eRoot = new RootCB("eRoot");
        dirty_1.parents = new Object[]{e1};
        dirty_2.parents = new Object[]{e2};
        dirty_3.parents = new Object[]{i1, i3};
        i1.parents = new Object[]{e1};
        i2.parents = new Object[]{dirty_1, dirty_2};
        i3.parents = new Object[]{e2};
        eRoot.parents = new Object[]{dirty_3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, e2, dirty_1, dirty_2, dirty_3, i1, i2, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel(true);
        sep.getFieldForInstance((Object)dirty_1);
        System.out.println("flags:" + sep.getDirtyFieldMap().keySet());
        sep.getDirtyFieldMap().keySet().stream().map(c -> c.name).forEach(System.out::println);
        Assert.assertThat(sep.getDirtyFieldMap().keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Field[]{sep.getFieldForInstance((Object)e1), sep.getFieldForInstance((Object)e2), sep.getFieldForInstance((Object)i1), sep.getFieldForInstance((Object)i2), sep.getFieldForInstance((Object)i3), sep.getFieldForInstance((Object)dirty_1), sep.getFieldForInstance((Object)dirty_2), sep.getFieldForInstance((Object)dirty_3)}));
        Assert.assertTrue((boolean)sep.getNodeGuardConditions((Object)e1).isEmpty());
        Assert.assertTrue((boolean)sep.getNodeGuardConditions((Object)e2).isEmpty());
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)i1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)e1)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)i2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)dirty_1), sep.getDirtyFlagForNode((Object)dirty_2)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)i3), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)e2)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)dirty_1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)e1)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)dirty_2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)e2)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)dirty_3), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)i1), sep.getDirtyFlagForNode((Object)i3)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)eRoot), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)dirty_3)}));
    }

    @Test
    public void testGuardConditionDiscontinuous() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        InitCB i4 = new InitCB("i4");
        InitCB i5 = new InitCB("i5");
        InitCB i6 = new InitCB("i6");
        DirtyNotifierNode dirty_1 = new DirtyNotifierNode("dirty_1");
        DirtyNotifierNode dirty_2 = new DirtyNotifierNode("dirty_2");
        dirty_1.parents = new Object[]{e1};
        dirty_2.parents = new Object[]{e2};
        i1.parents = new Object[]{e2};
        i2.parents = new Object[]{dirty_1};
        i3.parents = new Object[]{dirty_1, dirty_2};
        i4.parents = new Object[]{i1, i3};
        i5.parents = new Object[]{i2};
        i6.parents = new Object[]{i3};
        List<Object> nodeList = Arrays.asList(new Object[]{e1, e2, dirty_1, dirty_2, i1, i2, i3, i4, i5, i6});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel(true);
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)i5), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)i2)}));
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)i6), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)i3)}));
    }

    @Test
    public void testEventHandlerWithDirtySupport() throws Exception {
        AnnotatedEventHandlerDirtyNotifier eh = new AnnotatedEventHandlerDirtyNotifier();
        DirtyNotifierNode dirty_1 = new DirtyNotifierNode("dirty_1", eh);
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(Arrays.asList(eh, dirty_1));
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel(true);
        Assert.assertThat((Object)sep.getNodeGuardConditions((Object)dirty_1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new DirtyFlag[]{sep.getDirtyFlagForNode((Object)eh)}));
    }
}

