/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.builder.generation.FilterDescription;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.DefaultFilterDescriptionProducer;
import com.fluxtion.generator.model.DirtyFlag;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.targets.SepJavaSourceModelHugeFilter;
import com.fluxtion.test.event.AnnotatedEventHandlerWithOverrideFilter;
import com.fluxtion.test.event.AnnotatedHandlerNoFilter;
import com.fluxtion.test.event.AnnotatedHandlerNoPropogate;
import com.fluxtion.test.event.AnnotatedOnCompleteTestEventHandler;
import com.fluxtion.test.event.AnnotatedTestEventHandler;
import com.fluxtion.test.event.AnnotatedTestEventHandlerNoFilter;
import com.fluxtion.test.event.AnnotatedTimeHandler;
import com.fluxtion.test.event.AnnotatedTimeHandlerInverseFilter;
import com.fluxtion.test.event.AnnotatedTimeHandlerNoFilter;
import com.fluxtion.test.event.DirtyNotifierNode;
import com.fluxtion.test.event.EventHandlerCb;
import com.fluxtion.test.event.InitCB;
import com.fluxtion.test.event.NodeWithParentList;
import com.fluxtion.test.event.OnEventCompleteHandler;
import com.fluxtion.test.event.ParentUpdateListener;
import com.fluxtion.test.event.RootCB;
import com.fluxtion.test.event.TestEvent;
import com.fluxtion.test.event.TimeEvent;
import com.fluxtion.test.event.TimeHandlerExtends;
import com.fluxtion.test.event.TimeHandlerImpl;
import com.fluxtion.test.event.TimerHandler2Removed;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.ReflectionUtils;

public class SepModelTest {
    @Test
    public void initCBTest() throws Exception {
        CbMethodHandle cbHandle;
        int i;
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Assert.assertEquals((long)4L, (long)sep.getBatchEndMethods().size());
        Assert.assertEquals((long)1L, (long)sep.getBatchPauseMethods().size());
        Assert.assertEquals((long)3L, (long)sep.getInitialiseMethods().size());
        Assert.assertEquals((long)7L, (long)sep.getTearDownMethods().size());
        Set initMethodSet = ReflectionUtils.getAllMethods(InitCB.class, (Predicate[])new Predicate[]{Predicates.and((Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withName((String)"init"), ReflectionUtils.withParametersCount((int)0)})});
        Assert.assertEquals((long)initMethodSet.size(), (long)1L);
        Method expectedCb = (Method)initMethodSet.iterator().next();
        List<Object> expectedCallList = Arrays.asList(i3, i2, i1);
        List cbList = sep.getInitialiseMethods();
        for (i = 0; i < cbList.size(); ++i) {
            cbHandle = (CbMethodHandle)cbList.get(i);
            Assert.assertSame((Object)cbHandle.instance, (Object)expectedCallList.get(i));
        }
        for (i = 0; i < cbList.size(); ++i) {
            cbHandle = (CbMethodHandle)cbList.get(i);
            Assert.assertEquals((Object)cbHandle.method, (Object)expectedCb);
        }
    }

    @Test
    public void sharedFilterTest() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 2);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        SepJavaSourceModelHugeFilter srcModel = new SepJavaSourceModelHugeFilter(sep, true);
        srcModel.buildSourceModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)1L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        Assert.assertEquals((long)4L, (long)extList.size());
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 2));
        Assert.assertEquals((long)6L, (long)implList.size());
    }

    @Test
    public void overrideFilterIdTest() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 2);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        HashMap<EventHandlerCb, Integer> filterMap = new HashMap<EventHandlerCb, Integer>();
        filterMap.put(e1, 100);
        filterMap.put(e2, 200);
        filterMap.put(e3, 200);
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph, filterMap);
        sep.generateMetaModel();
        SepJavaSourceModelHugeFilter srcModel = new SepJavaSourceModelHugeFilter(sep, true);
        srcModel.buildSourceModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)1L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        Assert.assertNull((Object)extList);
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 100));
        Assert.assertEquals((long)4L, (long)extList.size());
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 2));
        Assert.assertNull((Object)implList);
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 200));
        Assert.assertEquals((long)6L, (long)implList.size());
    }

    @Test
    public void sortCbHandlerTest() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        List cbListExpected = sep.getInitialiseMethods();
        ArrayList cbListRandom = new ArrayList(sep.getInitialiseMethods());
        Assert.assertTrue((boolean)cbListRandom.equals(cbListExpected));
        Collections.reverse(cbListRandom);
        Assert.assertFalse((boolean)cbListRandom.equals(cbListExpected));
        graph.sortNodeList(cbListRandom);
        Assert.assertTrue((boolean)cbListRandom.equals(cbListExpected));
    }

    @Test
    public void testNoFilterHandlers() throws Exception {
        AnnotatedTimeHandlerNoFilter timeHandler1 = new AnnotatedTimeHandlerNoFilter();
        AnnotatedTestEventHandlerNoFilter testHandler2 = new AnnotatedTestEventHandlerNoFilter();
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        RootCB root = new RootCB("root");
        i1.parents = new Object[]{timeHandler1};
        i2.parents = new Object[]{testHandler2};
        root.parents = new Object[]{i1, i2};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{timeHandler1, testHandler2, i1, i2, root});
        graph.generateDependencyTree();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map timeCbMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)timeCbMap.size());
        List extList = (List)timeCbMap.get(FilterDescription.NO_FILTER);
        Assert.assertEquals((long)extList.size(), (long)3L);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)timeHandler1);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)i1);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)2)).instance, (Object)root);
        Map testCbMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)testCbMap.size());
        List testList = (List)testCbMap.get(FilterDescription.NO_FILTER);
        Assert.assertEquals((long)testList.size(), (long)3L);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)0)).instance, (Object)testHandler2);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)1)).instance, (Object)i2);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)2)).instance, (Object)root);
    }

    @Test
    public void testNoFilterAndInverseHandlers() throws Exception {
        AnnotatedTimeHandlerNoFilter noFilterHandler = new AnnotatedTimeHandlerNoFilter();
        AnnotatedTimeHandler filter_10_Handler = new AnnotatedTimeHandler(10);
        AnnotatedTimeHandlerInverseFilter inverseHandler = new AnnotatedTimeHandlerInverseFilter();
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        RootCB root = new RootCB("root");
        i1.parents = new Object[]{noFilterHandler};
        i2.parents = new Object[]{filter_10_Handler, inverseHandler};
        root.parents = new Object[]{i1, i2};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{noFilterHandler, filter_10_Handler, i1, i2, root, inverseHandler});
        graph.generateDependencyTree();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map timeCbMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)4L, (long)timeCbMap.size());
        List extList = ((List)timeCbMap.get(FilterDescription.NO_FILTER)).stream().map(cb -> cb.instance).collect(Collectors.toList());
        Assert.assertThat(extList, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{noFilterHandler, i1, root}));
        FilterDescription fd = new FilterDescription(TimeEvent.class, 10);
        extList = ((List)timeCbMap.get(fd)).stream().map(cb -> cb.instance).collect(Collectors.toList());
        Assert.assertThat(extList, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{noFilterHandler, filter_10_Handler, i1, i2, root}));
        extList = ((List)timeCbMap.get(FilterDescription.INVERSE_FILTER)).stream().map(cb -> cb.instance).collect(Collectors.toList());
        Assert.assertThat(extList, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{inverseHandler, i2, root}));
    }

    @Test
    public void testMixedFilterdAndNoFilterHandlers() throws Exception {
        AnnotatedTestEventHandler filteredTestHandler = new AnnotatedTestEventHandler(10);
        AnnotatedTestEventHandlerNoFilter unFilteredTestHandler = new AnnotatedTestEventHandlerNoFilter();
        InitCB filteredInter = new InitCB("i1");
        InitCB unFilteredInter = new InitCB("i2");
        RootCB root = new RootCB("root");
        filteredInter.parents = new Object[]{filteredTestHandler};
        unFilteredInter.parents = new Object[]{unFilteredTestHandler};
        root.parents = new Object[]{filteredInter, unFilteredInter};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{filteredTestHandler, unFilteredTestHandler, filteredInter, unFilteredInter, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)1L, (long)dispatchMap.size());
        Map testCbMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)3L, (long)testCbMap.size());
        List testList = (List)testCbMap.get(FilterDescription.NO_FILTER);
        Assert.assertEquals((long)testList.size(), (long)3L);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)0)).instance, (Object)unFilteredTestHandler);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)1)).instance, (Object)unFilteredInter);
        Assert.assertEquals((Object)((CbMethodHandle)testList.get((int)2)).instance, (Object)root);
        List testListFiltered = (List)testCbMap.get(filterProducer.getFilterDescription(TestEvent.class, 10));
        Assert.assertEquals((long)testListFiltered.size(), (long)5L);
        ArrayList<Object> nodeList = new ArrayList<Object>(testListFiltered.size());
        for (int i = 0; i < testListFiltered.size(); ++i) {
            CbMethodHandle cb = (CbMethodHandle)testListFiltered.get(i);
            nodeList.add(i, cb.instance);
        }
        Assert.assertTrue((nodeList.indexOf(root) > nodeList.indexOf(filteredInter) ? 1 : 0) != 0);
        Assert.assertTrue((nodeList.indexOf(filteredInter) > nodeList.indexOf(filteredTestHandler) ? 1 : 0) != 0);
        Assert.assertTrue((nodeList.indexOf(root) > nodeList.indexOf(unFilteredInter) ? 1 : 0) != 0);
        Assert.assertTrue((nodeList.indexOf(unFilteredInter) > nodeList.indexOf(unFilteredTestHandler) ? 1 : 0) != 0);
    }

    @Test
    public void testMixedHandlers() throws Exception {
        TimeHandlerExtends thExt = new TimeHandlerExtends(1);
        TimeHandlerImpl thImpl = new TimeHandlerImpl(2);
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thExt, thImpl};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)1L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)((Object)thExt));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
    }

    @Test
    public void testMixedHandlers2() throws Exception {
        TimerHandler2Removed thExt = new TimerHandler2Removed(1);
        TimeHandlerImpl thImpl = new TimeHandlerImpl(2);
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thExt, thImpl};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)1L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)((Object)thExt));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
    }

    @Test
    public void testAnnotatedHandlers() throws Exception {
        AnnotatedTimeHandler thExt = new AnnotatedTimeHandler(1);
        AnnotatedTimeHandler thImpl = new AnnotatedTimeHandler(2);
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thExt, thImpl};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
        typedMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 2));
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
    }

    @Test
    public void testFilterOverridesOnAnnotation() throws Exception {
        AnnotatedTimeHandler thExt = new AnnotatedTimeHandler(1);
        AnnotatedEventHandlerWithOverrideFilter thImpl = new AnnotatedEventHandlerWithOverrideFilter();
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thExt, thImpl};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)4L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)2)).instance, (Object)root);
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 100));
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)2)).instance, (Object)root);
        typedMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, "testMatch"));
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        Assert.assertEquals((long)2L, (long)extList.size());
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
    }

    @Test
    public void testNoPropogationAnnotation() throws Exception {
        AnnotatedHandlerNoPropogate thImpl = new AnnotatedHandlerNoPropogate();
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thImpl};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List implList = (List)typedMap.get(FilterDescription.NO_FILTER);
        Assert.assertEquals((long)1L, (long)implList.size());
    }

    @Test
    public void testOnCompleteOnRootHandler() throws Exception {
        AnnotatedOnCompleteTestEventHandler handler = new AnnotatedOnCompleteTestEventHandler(1);
        OnEventCompleteHandler complete1 = new OnEventCompleteHandler();
        RootCB root = new RootCB("root");
        complete1.parents = new Object[]{handler};
        root.parents = new Object[]{complete1};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{handler, root, complete1});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map postDispatchMap = sep.getPostDispatchMap();
        Map typedMap = (Map)postDispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)1L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        ArrayList<Object> luu = new ArrayList<Object>();
        for (CbMethodHandle implList1 : extList) {
            luu.add(implList1.instance);
        }
        Assert.assertEquals((long)2L, (long)extList.size());
        Assert.assertThat(luu, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{complete1, handler}));
    }

    @Test
    public void testOnCompleteHandlers() throws Exception {
        AnnotatedTimeHandler thExt = new AnnotatedTimeHandler(1);
        AnnotatedTimeHandler thImpl = new AnnotatedTimeHandler(2);
        AnnotatedHandlerNoFilter noFilterEh = new AnnotatedHandlerNoFilter();
        OnEventCompleteHandler complete1 = new OnEventCompleteHandler();
        OnEventCompleteHandler complete2 = new OnEventCompleteHandler();
        OnEventCompleteHandler complete3 = new OnEventCompleteHandler();
        RootCB root = new RootCB("root");
        complete1.parents = new Object[]{thExt};
        complete2.parents = new Object[]{thImpl};
        complete3.parents = new Object[]{noFilterEh};
        root.parents = new Object[]{complete1, complete2, complete3};
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, noFilterEh, root, complete1, complete2, complete3});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)4L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        ArrayList<Object> luu = new ArrayList<Object>();
        for (CbMethodHandle implList1 : implList) {
            luu.add(implList1.instance);
        }
        Assert.assertThat(luu, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{thImpl, noFilterEh, root}));
        Map postDispatchMap = sep.getPostDispatchMap();
        typedMap = (Map)postDispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)4L, (long)typedMap.size());
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        luu = new ArrayList();
        for (CbMethodHandle implList1 : extList) {
            luu.add(implList1.instance);
        }
        Assert.assertEquals((long)2L, (long)extList.size());
        Assert.assertThat(luu, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{complete1, complete3}));
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        luu = new ArrayList();
        for (CbMethodHandle implList1 : implList) {
            luu.add(implList1.instance);
        }
        Assert.assertEquals((long)2L, (long)implList.size());
        Assert.assertThat(luu, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{complete2, complete3}));
    }

    @Test
    public void testOverrideFilterIdAnnotatedHandlers() throws Exception {
        AnnotatedTimeHandler thExt = new AnnotatedTimeHandler(1);
        AnnotatedTimeHandler thImpl = new AnnotatedTimeHandler(2);
        RootCB root = new RootCB("root");
        root.parents = new Object[]{thExt, thImpl};
        HashMap<AnnotatedTimeHandler, Integer> filterMap = new HashMap<AnnotatedTimeHandler, Integer>();
        filterMap.put(thExt, 100);
        filterMap.put(thImpl, 200);
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(new Object[]{thExt, thImpl, root});
        graph.generateDependencyTree();
        DefaultFilterDescriptionProducer filterProducer = new DefaultFilterDescriptionProducer();
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph, filterMap, null);
        sep.generateMetaModel();
        Map dispatchMap = sep.getDispatchMap();
        Assert.assertEquals((long)2L, (long)dispatchMap.size());
        Map typedMap = (Map)dispatchMap.get(TimeEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        List extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 1));
        Assert.assertNull((Object)extList);
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 100));
        Assert.assertEquals((long)2L, (long)extList.size());
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        List implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 2));
        Assert.assertNull((Object)implList);
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TimeEvent.class, 200));
        Assert.assertEquals((long)2L, (long)implList.size());
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
        typedMap = (Map)dispatchMap.get(TestEvent.class);
        Assert.assertEquals((long)2L, (long)typedMap.size());
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 1));
        Assert.assertNull((Object)extList);
        extList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 100));
        Assert.assertEquals((long)2L, (long)extList.size());
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)0)).instance, (Object)thExt);
        Assert.assertEquals((Object)((CbMethodHandle)extList.get((int)1)).instance, (Object)root);
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 2));
        Assert.assertNull((Object)implList);
        implList = (List)typedMap.get(filterProducer.getFilterDescription(TestEvent.class, 200));
        Assert.assertEquals((long)2L, (long)implList.size());
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)0)).instance, (Object)thImpl);
        Assert.assertEquals((Object)((CbMethodHandle)implList.get((int)1)).instance, (Object)root);
    }

    @Test
    public void testParentUpdateCbHandler() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        ParentUpdateListener pl_1 = new ParentUpdateListener("pl_1");
        ParentUpdateListener pl_2 = new ParentUpdateListener("pl_2");
        InitCB i3 = new InitCB("i3");
        pl_1.parents = new Object[]{pl_2, e2};
        pl_2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{pl_1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, pl_1, pl_2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map listenerMethodMap = sep.getParentUpdateListenerMethodMap();
        CbMethodHandle cb_pl_1 = new CbMethodHandle(ParentUpdateListener.class.getMethod("parentChanged", Object.class), (Object)pl_1, graph.variableName((Object)pl_1));
        CbMethodHandle cb_pl_2 = new CbMethodHandle(ParentUpdateListener.class.getMethod("parentChanged", Object.class), (Object)pl_2, graph.variableName((Object)pl_2));
        Assert.assertThat(listenerMethodMap.get(pl_2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
        Assert.assertThat(listenerMethodMap.get((Object)e1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_2}));
        Assert.assertThat(listenerMethodMap.get((Object)e2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1, cb_pl_2}));
        Assert.assertThat(listenerMethodMap.get(i3), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_2}));
    }

    @Test
    public void testParentListUpdateCbHandler() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        NodeWithParentList root = new NodeWithParentList(e1, e2, e3);
        List<Object> nodeList = Arrays.asList(new Object[]{root, e1, e2, e3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel();
        Map listenerMethodMap = sep.getParentUpdateListenerMethodMap();
        CbMethodHandle cb_pl_1 = new CbMethodHandle(NodeWithParentList.class.getMethod("parentChanged", EventHandlerCb.class), (Object)root, graph.variableName((Object)root));
        Assert.assertThat(listenerMethodMap.get((Object)e1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
        Assert.assertThat(listenerMethodMap.get((Object)e2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
        Assert.assertThat(listenerMethodMap.get((Object)e3), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
    }

    @Test
    public void testCbDirtyMethodFlag() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        ParentUpdateListener pl_1 = new ParentUpdateListener("pl_1");
        DirtyNotifierNode dirty_2 = new DirtyNotifierNode("dirty_2");
        InitCB i3 = new InitCB("i3");
        pl_1.parents = new Object[]{dirty_2, e2};
        dirty_2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{pl_1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, pl_1, dirty_2, e2, e3, i3});
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeList);
        SimpleEventProcessorModel sep = new SimpleEventProcessorModel(graph);
        sep.generateMetaModel(true);
        Method method = DirtyNotifierNode.class.getMethod("onEvent", new Class[0]);
        CbMethodHandle handle = new CbMethodHandle(method, (Object)dirty_2, "who_knows");
        DirtyFlag dirtyFlag = sep.getDirtyFlagForUpdateCb(handle);
        Assert.assertEquals((Object)dirty_2, (Object)dirtyFlag.node.instance);
        method = ParentUpdateListener.class.getMethod("onEvent", new Class[0]);
        handle = new CbMethodHandle(method, (Object)pl_1, "who_knows");
        dirtyFlag = sep.getDirtyFlagForUpdateCb(handle);
        Assert.assertEquals((Object)pl_1, (Object)dirtyFlag.node.instance);
    }
}

