/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.test.event.AnnotatedTimeHandler;
import com.fluxtion.test.event.AnnotatedTimeHandlerNoFilter;
import com.fluxtion.test.event.DependencyChild;
import com.fluxtion.test.event.EventHandlerCb;
import com.fluxtion.test.event.InitCB;
import com.fluxtion.test.event.NodeWithParentList;
import com.fluxtion.test.event.RootCB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Test;

public class TopologicallySortedDependecyGraphTest {
    @Test
    public void testOrderedCallGraph() throws Exception {
        DependencyChild[] allNumbers = new DependencyChild[11];
        ArrayList<DependencyChild> nodeList = new ArrayList<DependencyChild>();
        DependencyChild prevChild = new DependencyChild(0, "0");
        nodeList.add(prevChild);
        for (int i = 1; i < allNumbers.length; ++i) {
            DependencyChild child;
            allNumbers[i] = child = new DependencyChild(i, "" + i, prevChild);
            nodeList.add(child);
            prevChild = child;
        }
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        for (int i = 1; i < allNumbers.length; ++i) {
            Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[i]), (Matcher)IsIterableContainingInOrder.contains((Object[])Arrays.copyOfRange(allNumbers, i, allNumbers.length)));
        }
    }

    @Test
    public void testOrderedDefinedVarNames() throws Exception {
        DependencyChild[] allNumbers = new DependencyChild[11];
        HashMap<DependencyChild, String> nodeMap = new HashMap<DependencyChild, String>();
        DependencyChild prevChild = new DependencyChild(0, "0");
        nodeMap.put(prevChild, "child_" + prevChild.id);
        for (int i = 1; i < allNumbers.length; ++i) {
            DependencyChild child;
            allNumbers[i] = child = new DependencyChild(i, "" + i, prevChild);
            nodeMap.put(child, "child_" + child.id);
            prevChild = child;
        }
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(nodeMap);
        graph.generateDependencyTree();
        for (int i = 1; i < allNumbers.length; ++i) {
            Assert.assertThat((Object)graph.getSortedDependents((Object)allNumbers[i]), (Matcher)IsIterableContainingInOrder.contains((Object[])Arrays.copyOfRange(allNumbers, i, allNumbers.length)));
        }
        Set nodes = nodeMap.keySet();
        for (Map.Entry entry : nodeMap.entrySet()) {
            Object inst = entry.getKey();
            String expectedName = (String)entry.getValue();
            Assert.assertEquals((Object)expectedName, (Object)graph.variableName(inst));
        }
    }

    @Test
    public void testSubTreeFiltering() throws Exception {
        DependencyChild[] allNumbers = new DependencyChild[11];
        ArrayList<DependencyChild> nodeList = new ArrayList<DependencyChild>();
        for (int i = 0; i < allNumbers.length; ++i) {
            DependencyChild child;
            allNumbers[i] = child = new DependencyChild(i, "" + i);
            nodeList.add(child);
        }
        DependencyChild[] primeNums = new DependencyChild[]{allNumbers[1], allNumbers[2], allNumbers[3], allNumbers[5], allNumbers[7]};
        DependencyChild[] evenNums = new DependencyChild[]{allNumbers[2], allNumbers[4], allNumbers[6], allNumbers[8], allNumbers[10]};
        DependencyChild[] oddNums = new DependencyChild[]{allNumbers[1], allNumbers[3], allNumbers[5], allNumbers[7], allNumbers[9]};
        DependencyChild primes = new DependencyChild(0, "primes", primeNums);
        DependencyChild evens = new DependencyChild(0, "evens", evenNums);
        DependencyChild odds = new DependencyChild(0, "odds", oddNums);
        DependencyChild root = new DependencyChild(0, "root", primes, evens, odds, allNumbers[0]);
        nodeList.add(primes);
        nodeList.add(evens);
        nodeList.add(odds);
        nodeList.add(root);
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[0]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[0], root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[1]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[1], primes, odds, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[2]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[2], primes, evens, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[3]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[3], primes, odds, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[4]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[4], evens, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[5]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[5], primes, odds, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[6]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[6], evens, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[7]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[7], primes, odds, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[8]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[8], evens, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[9]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[9], odds, root}));
        Assert.assertThat((Object)instance.getSortedDependents((Object)allNumbers[10]), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{allNumbers[10], evens, root}));
    }

    @Test
    public void testDirectChildren() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getDirectChildren((Object)i3), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{eRoot, i2}));
        Assert.assertThat((Object)instance.getDirectChildren((Object)i1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{eRoot}));
    }

    @Test
    public void testDisconnectedNodes() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        AnnotatedTimeHandlerNoFilter noFilterEh = new AnnotatedTimeHandlerNoFilter();
        AnnotatedTimeHandler th = new AnnotatedTimeHandler(200);
        RootCB eRoot = new RootCB("eRoot", noFilterEh);
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, noFilterEh, th, eRoot});
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        Assert.assertEquals((long)4L, (long)instance.getSortedDependents().size());
    }

    @Test
    public void testDirectParents() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb e2 = new EventHandlerCb("e2", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        InitCB i3 = new InitCB("i3");
        i1.parents = new Object[]{i2};
        i2.parents = new Object[]{e1, e2, i3};
        i3.parents = new Object[]{e3};
        eRoot.parents = new Object[]{i1, i3};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e2, e3, i3});
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getDirectParents((Object)i2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e1, e2, i3}));
        Assert.assertThat((Object)instance.getDirectParents((Object)eRoot), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{i1, i3}));
    }

    @Test
    public void testDirectParentsShared() throws Exception {
        EventHandlerCb e1 = new EventHandlerCb("e1", 1);
        EventHandlerCb eshared = new EventHandlerCb("eshared", 2);
        EventHandlerCb e3 = new EventHandlerCb("e3", 3);
        RootCB eRoot = new RootCB("eRoot");
        InitCB i1 = new InitCB("i1");
        InitCB i2 = new InitCB("i2");
        i1.parents = new Object[]{e1, eshared};
        i2.parents = new Object[]{eshared, e3};
        eRoot.parents = new Object[]{i1, i2};
        List<Object> nodeList = Arrays.asList(new Object[]{eRoot, e1, i1, i2, e3, eshared});
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(nodeList);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getDirectParents((Object)i1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e1, eshared}));
        Assert.assertThat((Object)instance.getDirectParents((Object)i2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e3, eshared}));
    }

    @Test
    public void testDirectParentsSharedFluentApi() throws Exception {
        SEPConfig config = new SEPConfig();
        EventHandlerCb e1 = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("e1", 1)));
        EventHandlerCb eshared = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("eshared", 2)));
        EventHandlerCb e3 = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("e3", 3)));
        RootCB eRoot = (RootCB)config.addNode((Object)new RootCB("eRoot"));
        InitCB i1 = (InitCB)config.addNode((Object)new InitCB("i1"));
        InitCB i2 = (InitCB)config.addNode((Object)new InitCB("i2"));
        i1.parents = new Object[]{e1, eshared};
        i2.parents = new Object[]{eshared, e3};
        eRoot.parents = new Object[]{i1, i2};
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getDirectParents((Object)i1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e1, eshared}));
        Assert.assertThat((Object)instance.getDirectParents((Object)i2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e3, eshared}));
    }

    @Test
    public void testArrayListParents() throws Exception {
        SEPConfig config = new SEPConfig();
        EventHandlerCb e1 = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("e1", 1)));
        EventHandlerCb eshared = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("eshared", 2)));
        EventHandlerCb e3 = (EventHandlerCb)((Object)config.addNode((Object)new EventHandlerCb("e3", 3)));
        NodeWithParentList eRoot = (NodeWithParentList)config.addNode((Object)new NodeWithParentList(e1, eshared, e3));
        TopologicallySortedDependecyGraph instance = new TopologicallySortedDependecyGraph(config);
        instance.generateDependencyTree();
        Assert.assertThat((Object)instance.getDirectParents((Object)eRoot), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{e1, eshared, e3}));
        Assert.assertThat((Object)instance.getEventSortedDependents((Object)e3), (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[]{e3, eRoot}));
    }
}

