/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model.parentlistener;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import com.fluxtion.test.event.EventHandlerCb;
import com.fluxtion.test.event.NodeWithParentList;
import com.fluxtion.test.event.NodeWithPrivateParentList;
import com.fluxtion.test.event.TestEvent;
import org.junit.Assert;
import org.junit.Test;

public class ParentCollectionTest
extends BaseSepTest {
    @Test
    public void testParentList() {
        StaticEventProcessor sep = this.buildAndInitSep(ParentListProcessorSep.class);
        NodeWithParentList root = (NodeWithParentList)this.getField("root");
        Assert.assertEquals((long)3L, (long)root.parents.size());
        sep.onEvent((Object)new TestEvent());
        Assert.assertEquals((long)0L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)0L, (long)root.onEventCount);
        sep.onEvent((Object)new TestEvent(2));
        Assert.assertEquals((long)1L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)1L, (long)root.onEventCount);
    }

    @Test
    public void testParentListNoTYpe() {
        StaticEventProcessor sep = this.buildAndInitSep(ParentListNoTypeProcessorSep.class);
        NodeWithParentList root = (NodeWithParentList)this.getField("root");
        Assert.assertEquals((long)3L, (long)root.parentsNoType.size());
        sep.onEvent((Object)new TestEvent());
        Assert.assertEquals((long)0L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)0L, (long)root.onEventCount);
        sep.onEvent((Object)new TestEvent(2));
        Assert.assertEquals((long)1L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)1L, (long)root.onEventCount);
    }

    @Test
    public void testPrivateListParents() {
        this.compileCfg.setAssignNonPublicMembers(true);
        StaticEventProcessor sep = this.buildAndInitSep(ParentPrivateListProcessorSep.class);
        NodeWithPrivateParentList root = (NodeWithPrivateParentList)this.getField("root");
        Assert.assertEquals((long)3L, (long)root.getParents().size());
        Assert.assertEquals((long)1L, (long)root.intList.size());
        Assert.assertEquals((long)2L, (long)root.stringList.size());
        sep.onEvent((Object)new TestEvent());
        Assert.assertEquals((long)0L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)0L, (long)root.onEventCount);
        sep.onEvent((Object)new TestEvent(2));
        Assert.assertEquals((long)1L, (long)root.parentUpdateCount);
        Assert.assertEquals((long)1L, (long)root.onEventCount);
    }

    public static class ParentPrivateListProcessorSep
    extends SEPConfig {
        public ParentPrivateListProcessorSep() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            NodeWithPrivateParentList root = (NodeWithPrivateParentList)this.addPublicNode(new NodeWithPrivateParentList(e1, e2, e3), "root");
            root.intList.add(1);
            root.stringList.add("test val");
            root.stringList.add("another val");
        }
    }

    public static class ParentListNoTypeProcessorSep
    extends SEPConfig {
        public ParentListNoTypeProcessorSep() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            NodeWithParentList root = (NodeWithParentList)this.addPublicNode(new NodeWithParentList(new EventHandlerCb[0]), "root");
            root.parentsNoType.add(e1);
            root.parentsNoType.add(e2);
            root.parentsNoType.add(e3);
        }
    }

    public static class ParentListProcessorSep
    extends SEPConfig {
        public ParentListProcessorSep() {
            EventHandlerCb e1 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("1", 1)));
            EventHandlerCb e2 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("2", 2)));
            EventHandlerCb e3 = (EventHandlerCb)((Object)this.addNode((Object)new EventHandlerCb("3", 3)));
            this.addPublicNode(new NodeWithParentList(e1, e2, e3), "root");
        }
    }
}

