/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model.parentlistener;

import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.model.parentlistener.EventListeners;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParentListenerModelTest {
    private SimpleEventProcessorModel sep;
    private TopologicallySortedDependecyGraph graph;

    @Before
    public void before() {
        this.sep = null;
        this.graph = null;
    }

    @Test
    public void testParent_1() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        node1.testEventSource = test1Listener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_pl_1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
    }

    @Test
    public void testParent_1a() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.ConfigEventListener configListener = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        node1.testEventSource = test1Listener;
        node1.configEventSource = configListener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        Assert.assertEquals((long)0L, (long)listenerMethodMap.get(configListener).size());
        CbMethodHandle cb_pl_1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_pl_1}));
    }

    @Test
    public void testParent_2() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node1Parent1ObjectListener node2 = (EventListeners.Node1Parent1ObjectListener)config.addNode((Object)new EventListeners.Node1Parent1ObjectListener());
        node1.testEventSource = test1Listener;
        node2.testEventSource = test1Listener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onTestEvent_2", EventListeners.TestEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1, cb_node2}));
    }

    @Test
    public void testParent_3() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node1Parent1ObjectListener node2 = (EventListeners.Node1Parent1ObjectListener)config.addNode((Object)new EventListeners.Node1Parent1ObjectListener());
        node1.testEventSource = test1Listener;
        node2.objectEventSource = test1Listener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onTestEvent_2", EventListeners.TestEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1, cb_node2}));
    }

    @Test
    public void testParent_4() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.UnknownTestEventListener unknownListener = (EventListeners.UnknownTestEventListener)config.addNode((Object)new EventListeners.UnknownTestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node1Parent1ObjectListener node2 = (EventListeners.Node1Parent1ObjectListener)config.addNode((Object)new EventListeners.Node1Parent1ObjectListener());
        node1.testEventSource = test1Listener;
        node2.testEventSource = test1Listener;
        node2.objectEventSource = unknownListener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onTestEvent_2", EventListeners.TestEventListener.class, node2);
        CbMethodHandle cb_node2_any = this.getCbHandle("onAnyUpdate", Object.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1, cb_node2}));
        Assert.assertThat(listenerMethodMap.get(unknownListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2_any}));
    }

    @Test
    public void testParent_5() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node1Parent1ObjectListener node2 = (EventListeners.Node1Parent1ObjectListener)config.addNode((Object)new EventListeners.Node1Parent1ObjectListener());
        node1.testEventSource = test1Listener;
        node2.testEventSource = test1Listener;
        node2.objectEventSource = test1Listener;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onTestEvent_2", EventListeners.TestEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1, cb_node2}));
    }

    @Test
    public void testParent_6() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.ConfigEventListener configListener = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node2ArrayParentListener node2 = (EventListeners.Node2ArrayParentListener)config.addNode((Object)new EventListeners.Node2ArrayParentListener());
        node1.testEventSource = test1Listener;
        node2.configEventSources = new EventListeners.ConfigEventListener[]{configListener};
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onConfigEvent", EventListeners.ConfigEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1}));
        Assert.assertThat(listenerMethodMap.get(configListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
    }

    @Test
    public void testParent_7() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.ConfigEventListener configListener = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.ConfigEventListener configListener2 = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node2ArrayParentListener node2 = (EventListeners.Node2ArrayParentListener)config.addNode((Object)new EventListeners.Node2ArrayParentListener());
        node1.testEventSource = test1Listener;
        node2.configEventSource = configListener2;
        node2.configEventSources = new EventListeners.ConfigEventListener[]{configListener};
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onConfigEvent", EventListeners.ConfigEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1}));
        Assert.assertThat(listenerMethodMap.get(configListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
        Assert.assertThat(listenerMethodMap.get(configListener2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
    }

    @Test
    public void testParent_8() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.ConfigEventListener configListener = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.ChildConfigEventListener childConfigListener = (EventListeners.ChildConfigEventListener)config.addNode((Object)new EventListeners.ChildConfigEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener());
        EventListeners.Node2ArrayParentListener node2 = (EventListeners.Node2ArrayParentListener)config.addNode((Object)new EventListeners.Node2ArrayParentListener());
        node1.testEventSource = test1Listener;
        node2.configEventSource = childConfigListener;
        node2.configEventSources = new EventListeners.ConfigEventListener[]{configListener};
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onConfigEvent", EventListeners.ConfigEventListener.class, node2);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1}));
        Assert.assertThat(listenerMethodMap.get(configListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
        Assert.assertThat(listenerMethodMap.get(childConfigListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
    }

    @Test
    public void testParent_9() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.ConfigEventListener configListener = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.ConfigEventListener configListener2 = (EventListeners.ConfigEventListener)config.addNode((Object)new EventListeners.ConfigEventListener());
        EventListeners.NodeNameFilterListener node1 = (EventListeners.NodeNameFilterListener)config.addNode((Object)new EventListeners.NodeNameFilterListener());
        node1.configEventSource = configListener;
        node1.configEventSource2 = configListener2;
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        CbMethodHandle cb_node1 = this.getCbHandle("onConfigEvent", EventListeners.ConfigEventListener.class, node1);
        CbMethodHandle cb_node2 = this.getCbHandle("onConfigEvent2", EventListeners.ConfigEventListener.class, node1);
        Assert.assertThat(listenerMethodMap.get(configListener), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node1}));
        Assert.assertThat(listenerMethodMap.get(configListener2), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new CbMethodHandle[]{cb_node2}));
    }

    @Test
    public void testParent_10() throws Exception {
        SEPConfig config = new SEPConfig();
        EventListeners.TestEventListener test1Listener = (EventListeners.TestEventListener)config.addNode((Object)new EventListeners.TestEventListener());
        EventListeners.Node1ParentListener node1 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener(test1Listener));
        EventListeners.Node1ParentListener node2 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener(test1Listener, node1));
        EventListeners.Node1ParentListener node3 = (EventListeners.Node1ParentListener)config.addNode((Object)new EventListeners.Node1ParentListener(test1Listener, node2));
        Map<Object, List<CbMethodHandle>> listenerMethodMap = this.generateListnerMap(config);
        Assert.assertThat(listenerMethodMap.get(test1Listener), (Matcher)Matchers.contains((Object[])new CbMethodHandle[]{this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node1), this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node2), this.getCbHandle("onTestEventParent", EventListeners.TestEventListener.class, node3)}));
    }

    private Map<Object, List<CbMethodHandle>> generateListnerMap(SEPConfig config) throws Exception {
        this.graph = new TopologicallySortedDependecyGraph(config);
        this.sep = new SimpleEventProcessorModel(this.graph);
        this.sep.generateMetaModel();
        return this.sep.getParentUpdateListenerMethodMap();
    }

    private CbMethodHandle getCbHandle(String methodName, Class parentClass, Object listener) throws NoSuchMethodException {
        return new CbMethodHandle(listener.getClass().getMethod(methodName, parentClass), listener, this.graph.variableName(listener));
    }
}

