/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model.parentlistener.wc;

import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.model.parentlistener.wc.CharHandler;

public class WordCounter {
    public CharHandler anyCharHandler;
    public CharHandler.DelimiterCharEventHandler[] delimiterHandlers;
    public CharHandler.EolCharEventHandler eolHandler;
    public CharHandler.UnMatchedCharEventHandler wordChardHandler;
    public int wordCount;
    public int charCount;
    public int lineCount;
    public int increment = 1;

    @OnParentUpdate
    public void onAnyChar(CharHandler anyCharHandler) {
        ++this.charCount;
    }

    @OnParentUpdate
    public void onDelimiter(CharHandler.DelimiterCharEventHandler delimiterHandler) {
        this.increment = 1;
    }

    @OnParentUpdate
    public void onEol(CharHandler.EolCharEventHandler eolHandler) {
        ++this.lineCount;
        this.increment = 1;
    }

    @OnParentUpdate
    public void onUnmatchedChar(CharHandler.UnMatchedCharEventHandler wordChardHandler) {
        this.wordCount += this.increment;
        this.increment = 0;
    }

    public String toString() {
        return "wc\ncharCount:" + this.charCount + "\nwordCount:" + this.wordCount + "\nlineCount:" + this.lineCount;
    }

    public static class Builder
    extends SEPConfig {
        public Builder() {
            WordCounter root = (WordCounter)this.addPublicNode(new WordCounter(), "result");
            root.anyCharHandler = (CharHandler)this.addNode(new CharHandler());
            root.eolHandler = (CharHandler.EolCharEventHandler)this.addNode(new CharHandler.EolCharEventHandler('\n'));
            root.wordChardHandler = (CharHandler.UnMatchedCharEventHandler)this.addNode(new CharHandler.UnMatchedCharEventHandler());
            root.delimiterHandlers = new CharHandler.DelimiterCharEventHandler[]{(CharHandler.DelimiterCharEventHandler)this.addNode(new CharHandler.DelimiterCharEventHandler(' ')), (CharHandler.DelimiterCharEventHandler)this.addNode(new CharHandler.DelimiterCharEventHandler('\t'))};
        }
    }
}

