/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model.parentlistener.wc;

import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.model.parentlistener.wc.CharHandler;

public class WordCounterGeneric {
    public CharHandler anyCharHandler;
    public CharHandler.FilteredCharEventHandler spaceHandler;
    public CharHandler.FilteredCharEventHandler tabHandler;
    public CharHandler.FilteredCharEventHandler eolHandler;
    public CharHandler.UnMatchedCharEventHandler wordChardHandler;
    public int wordCount;
    public int charCount;
    public int lineCount;
    public int increment = 1;

    @OnParentUpdate
    public void onAnyChar(CharHandler anyCharHandler) {
        ++this.charCount;
    }

    @OnParentUpdate(value="tabHandler")
    public void onTabDelimiter(CharHandler.FilteredCharEventHandler delimiterHandler) {
        this.increment = 1;
    }

    @OnParentUpdate(value="spaceHandler")
    public void onSpaceDelimiter(CharHandler.FilteredCharEventHandler delimiterHandler) {
        this.increment = 1;
    }

    @OnParentUpdate(value="eolHandler")
    public void onEol(CharHandler.FilteredCharEventHandler eolHandler) {
        ++this.lineCount;
        this.increment = 1;
    }

    @OnParentUpdate
    public void onUnmatchedChar(CharHandler.UnMatchedCharEventHandler wordChardHandler) {
        this.wordCount += this.increment;
        this.increment = 0;
    }

    public String toString() {
        return "wc\ncharCount:" + this.charCount + "\nwordCount:" + this.wordCount + "\nlineCount:" + this.lineCount;
    }

    public static class Builder
    extends SEPConfig {
        public Builder() {
            WordCounterGeneric root = (WordCounterGeneric)this.addPublicNode(new WordCounterGeneric(), "result");
            root.anyCharHandler = (CharHandler)this.addNode(new CharHandler());
            root.eolHandler = (CharHandler.FilteredCharEventHandler)this.addNode(new CharHandler.FilteredCharEventHandler('\n'));
            root.wordChardHandler = (CharHandler.UnMatchedCharEventHandler)this.addNode(new CharHandler.UnMatchedCharEventHandler());
            root.spaceHandler = (CharHandler.FilteredCharEventHandler)this.addNode(new CharHandler.FilteredCharEventHandler(' '));
            root.tabHandler = (CharHandler.FilteredCharEventHandler)this.addNode(new CharHandler.FilteredCharEventHandler('\t'));
        }
    }
}

