/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model.parentlistener.wc;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.FilterType;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.model.parentlistener.wc.CharEvent;

public class WordCounterInlineEventHandler {
    public transient int wordCount;
    public transient int charCount;
    public transient int lineCount;
    private int increment = 1;

    @EventHandler
    public void onAnyChar(CharEvent event) {
        ++this.charCount;
    }

    @EventHandler(filterId=9)
    public void onTabDelimiter(CharEvent event) {
        this.increment = 1;
    }

    @EventHandler(filterId=32)
    public void onSpaceDelimiter(CharEvent event) {
        this.increment = 1;
    }

    @EventHandler(filterId=10)
    public void onEol(CharEvent event) {
        ++this.lineCount;
        this.increment = 1;
    }

    @EventHandler(value=FilterType.unmatched)
    public void onUnmatchedChar(CharEvent event) {
        this.wordCount += this.increment;
        this.increment = 0;
    }

    public String toString() {
        return "wc\ncharCount:" + this.charCount + "\nwordCount:" + this.wordCount + "\nlineCount:" + this.lineCount;
    }

    public static class Builder
    extends SEPConfig {
        public Builder() {
            this.addPublicNode(new WordCounterInlineEventHandler(), "result");
        }
    }
}

