/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.noeventref;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.NoEventReference;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import org.junit.Assert;
import org.junit.Test;

public class NoEventRefTest
extends BaseSepTest {
    @Test
    public void dirtyNoReferenceTest() {
        this.buildAndInitSep(NoEventrefBuilder.class);
        PricePublisher testHandler = (PricePublisher)this.getField("pricePublisher");
        RulesProcessor rulesProcessor = (RulesProcessor)this.getField("rulesProcessor");
        PriceFormer priceFormer = (PriceFormer)this.getField("priceFormer");
        this.onEvent(new Config());
        this.onEvent(new Config());
        Assert.assertEquals((long)0L, (long)testHandler.invokeCount);
        Assert.assertEquals((long)2L, (long)rulesProcessor.invokeCount);
        Assert.assertEquals((long)2L, (long)priceFormer.invokeCount);
    }

    public static class PricePublisher {
        @NoEventReference
        public final PriceFormer priceFormer;
        public final RulesProcessor rulesProcessor;
        public int invokeCount;

        public PricePublisher(PriceFormer priceFormer, RulesProcessor rulesProcessor) {
            this.priceFormer = priceFormer;
            this.rulesProcessor = rulesProcessor;
        }

        @OnEvent
        public void onEvent() {
            ++this.invokeCount;
        }
    }

    public static class RulesProcessor {
        public final ConfigCache configCache;
        private int invokeCount;

        public RulesProcessor(ConfigCache configCache) {
            this.configCache = configCache;
        }

        @OnEvent
        public boolean onEvent() {
            ++this.invokeCount;
            return false;
        }
    }

    public static class PriceFormer {
        public final ConfigCache configCache;
        private int invokeCount;

        public PriceFormer(ConfigCache configCache) {
            this.configCache = configCache;
        }

        @OnEvent
        public boolean onEvent() {
            ++this.invokeCount;
            return true;
        }

        @EventHandler
        public boolean priceUpdate(Price cfg) {
            return true;
        }
    }

    public static class ConfigCache {
        @EventHandler
        public boolean configUpdate(Config cfg) {
            return true;
        }
    }

    public static class Price
    implements Event {
    }

    public static class Config
    implements Event {
    }

    public static class NoEventrefBuilder
    extends SEPConfig {
        public void buildConfig() {
            ConfigCache cfgCache = (ConfigCache)this.addNode(new ConfigCache());
            PriceFormer priceFormer = (PriceFormer)this.addPublicNode(new PriceFormer(cfgCache), "priceFormer");
            RulesProcessor rulesProcessor = (RulesProcessor)this.addPublicNode(new RulesProcessor(cfgCache), "rulesProcessor");
            this.addPublicNode(new PricePublisher(priceFormer, rulesProcessor), "pricePublisher");
        }
    }
}

