/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.nopropagate;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.NoEventReference;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import org.junit.Assert;
import org.junit.Test;

public class NoPropagateTest
extends BaseSepTest {
    @Test
    public void testPush() {
        this.buildAndInitSep(PriceBuilder.class);
        PricePublisher pricerPublisher = (PricePublisher)this.getField("pricerPublisher");
        PricerFormer priceFormer = (PricerFormer)this.getField("priceFormer");
        MarketHandler tickHandler = (MarketHandler)this.getField("marketHandler");
        this.onEvent(new MarketTickEvent("EURUSD"));
        Assert.assertEquals((long)0L, (long)pricerPublisher.eventCount);
        Assert.assertEquals((long)1L, (long)priceFormer.eventCount);
        Assert.assertEquals((long)1L, (long)tickHandler.eventCount);
        this.onEvent(new MarketTickEvent("EURUSD"));
        Assert.assertEquals((long)0L, (long)pricerPublisher.eventCount);
        Assert.assertEquals((long)2L, (long)priceFormer.eventCount);
        Assert.assertEquals((long)2L, (long)tickHandler.eventCount);
    }

    public static class PricePublisher {
        public final PricerFormer former;
        int eventCount;

        public PricePublisher(PricerFormer former) {
            this.former = former;
        }

        @OnEvent
        public void formPrice() {
            ++this.eventCount;
        }
    }

    public static class PricerFormer {
        int eventCount;
        @NoEventReference
        public final MarketHandler marketHanlder;

        public PricerFormer(MarketHandler marketHanlder) {
            this.marketHanlder = marketHanlder;
        }

        @OnParentUpdate
        public void MarketUpdate(MarketHandler update) {
            ++this.eventCount;
        }
    }

    public static class MarketHandler {
        int eventCount;
        String ccyPair;

        @EventHandler
        public void newTick(MarketTickEvent tick) {
            ++this.eventCount;
            this.ccyPair = tick.ccyPair;
        }
    }

    public static class MarketTickEvent
    implements Event {
        public String ccyPair;

        public MarketTickEvent(String ccyPair) {
            this.ccyPair = ccyPair;
        }
    }

    public static class PriceBuilder
    extends SEPConfig {
        public void buildConfig() {
            MarketHandler tickHandler = (MarketHandler)this.addPublicNode(new MarketHandler(), "marketHandler");
            PricerFormer pricerFormer = (PricerFormer)this.addPublicNode(new PricerFormer(tickHandler), "priceFormer");
            PricePublisher pricerPublisher = (PricePublisher)this.addPublicNode(new PricePublisher(pricerFormer), "pricerPublisher");
        }
    }
}

