/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.order;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.generation.NodeNameProducer;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GenerationOrderTest
extends BaseSepTest {
    @Test
    public void testOrder() {
        StaticEventProcessor handler1 = this.buildAndInitSep(NodeBuilder.class);
        OrderEvent oe = new OrderEvent();
        handler1.onEvent((Object)oe);
        List<String> expected = Arrays.asList("root", "A1", "A2", "X", "Y");
        Assert.assertEquals(expected, oe.list);
    }

    public static class NodeNamer
    implements NodeNameProducer {
        public String mappedNodeName(Object nodeToMap) {
            if (nodeToMap instanceof Node) {
                return ((Node)nodeToMap).name;
            }
            return null;
        }
    }

    public static class Node {
        private final Node parent;
        private final String name;

        public Node(Node parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Node(String name) {
            this(null, name);
        }

        @EventHandler
        public void update(OrderEvent e) {
            e.list.add(this.name);
        }
    }

    public static class OrderEvent
    implements Event {
        public List<String> list = new ArrayList<String>();
    }

    public static class NodeBuilder
    extends SEPConfig {
        public void buildConfig() {
            Node root = (Node)this.addNode(new Node("root"));
            Node x1 = (Node)this.addNode(new Node(root, "X"));
            Node a2 = (Node)this.addNode(new Node(root, "A2"));
            Node y1 = (Node)this.addNode(new Node(root, "Y"));
            Node a1 = (Node)this.addNode(new Node(root, "A1"));
        }
    }
}

