/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.parent;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.event.DefaultEvent;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ParentUpdateListenerTest
extends BaseSepTest {
    @Test
    public void testClassFilter() {
        this.buildAndInitSep(FilterBuilder.class);
        TestHandler testHandler = (TestHandler)this.getField("handler");
        TestChild child = (TestChild)this.getField("child");
        this.onEvent((Event)new ClassFilterEvent(String.class));
        this.onEvent((Event)new ClassFilterEvent(Double.class));
        Assert.assertThat((Object)testHandler.count, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.eventCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.parentCount, (Matcher)CoreMatchers.is((Object)1));
        this.onEvent(new NoUpdateEvent());
        Assert.assertThat((Object)testHandler.count, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)child.eventCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.parentCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testClassFilterPrivateParent() {
        this.buildAndInitSep(FilterBuilderPrivate.class);
        TestHandler testHandler = (TestHandler)this.getField("handler");
        TestChildPrivateParent child = (TestChildPrivateParent)this.getField("child");
        this.onEvent((Event)new ClassFilterEvent(String.class));
        this.onEvent((Event)new ClassFilterEvent(Double.class));
        Assert.assertThat((Object)testHandler.count, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.eventCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.parentCount, (Matcher)CoreMatchers.is((Object)1));
        this.onEvent(new NoUpdateEvent());
        Assert.assertThat((Object)testHandler.count, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)child.eventCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)child.parentCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testMultipleRules() {
        this.buildAndInitSep(ValidationBuilder.class);
        RuleValidator validator = (RuleValidator)this.getField("validator");
        Rule2 rule2 = (Rule2)this.getField("rule2");
        this.onEvent(new NewOrderEvent());
        Assert.assertThat((Object)validator.validationFailedCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)validator.ruleCount, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)rule2.configCount, (Matcher)CoreMatchers.is((Object)0));
        this.onEvent(new ConfigEvent());
        Assert.assertThat((Object)validator.validationFailedCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)validator.ruleCount, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)rule2.configCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void dirtyFiltering() {
        this.buildAndInitSep(PriceBuilder.class);
        TickCounter tickCounter = (TickCounter)this.getField("tickCounter");
        PricerFormer priceFormer = (PricerFormer)this.getField("priceFormer");
        Assert.assertThat((Object)tickCounter.eventCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)tickCounter.parentCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)priceFormer.eventCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)priceFormer.parentCount, (Matcher)CoreMatchers.is((Object)0));
        this.onEvent(new MarketTickEvent());
        this.onEvent(new MarketTickEvent());
        Assert.assertThat((Object)tickCounter.eventCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)tickCounter.parentCount, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)priceFormer.eventCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)priceFormer.parentCount, (Matcher)CoreMatchers.is((Object)0));
    }

    public static class ThrottledPublisher {
        public PricerFormer pricerFormer;
        public PositionCalculator positionCalc;
        int eventCount;

        @OnEvent
        public void publish() {
            ++this.eventCount;
        }

        @EventHandler
        public void newOrder(NewOrderEvent orderEvent) {
        }

        @OnParentUpdate
        public boolean positionChanged(PositionCalculator positionCalc) {
            return true;
        }

        @OnParentUpdate
        public void priceChanged(PricerFormer pricerFormer) {
        }
    }

    public static class PositionCalculator {
        @EventHandler
        public boolean postionUpdate(PositionEvent orderEvent) {
            return true;
        }

        @OnEvent
        public boolean recalcPosition() {
            return false;
        }
    }

    public static class TickCounter {
        public MarketHandler marketHandler;
        int eventCount;
        int parentCount;

        @OnParentUpdate(guarded=false)
        public void tickUpdated(MarketHandler marketHandler) {
            ++this.parentCount;
        }

        @OnEvent
        public void formPrice() {
            ++this.eventCount;
        }
    }

    public static class PricerFormer {
        public MarketHandler marketHandler;
        int eventCount;
        int parentCount;

        @OnParentUpdate
        public void tickUpdated(MarketHandler marketHandler) {
            ++this.parentCount;
        }

        @OnEvent
        public void formPrice() {
            ++this.eventCount;
        }
    }

    public static class MarketHandler {
        int eventCount;

        @EventHandler
        public boolean newTick(MarketTickEvent tick) {
            ++this.eventCount;
            return false;
        }
    }

    public static class PositionEvent
    implements Event {
    }

    public static class MarketTickEvent
    implements Event {
    }

    public static class PriceBuilder
    extends SEPConfig {
        public void buildConfig() {
            MarketHandler tickHandler = (MarketHandler)this.addPublicNode(new MarketHandler(), "marketHandler");
            PricerFormer pricerFormer = (PricerFormer)this.addPublicNode(new PricerFormer(), "priceFormer");
            TickCounter tickCounter = (TickCounter)this.addPublicNode(new TickCounter(), "tickCounter");
            ThrottledPublisher throttledPublisher = (ThrottledPublisher)this.addPublicNode(new ThrottledPublisher(), "throttledPublisher");
            PositionCalculator positionCalc = (PositionCalculator)this.addPublicNode(new PositionCalculator(), "positionCalc");
            pricerFormer.marketHandler = tickHandler;
            tickCounter.marketHandler = tickHandler;
            throttledPublisher.pricerFormer = pricerFormer;
            throttledPublisher.positionCalc = positionCalc;
        }
    }

    public static class RuleValidator {
        public ArrayList<DefaultRule> rules = new ArrayList();
        public int ruleCount = 0;
        public int validationFailedCount = 0;

        @OnParentUpdate
        public void ruleFailed(DefaultRule failedRule) {
            ++this.ruleCount;
        }

        @OnEvent
        public void validationFailed() {
            ++this.validationFailedCount;
        }
    }

    public static class Rule2
    extends DefaultRule {
        public int configCount = 0;

        public Rule2(OrderCache cache) {
            super(cache);
        }

        public Rule2() {
        }

        @EventHandler(propagate=false)
        public boolean configUpdate(ConfigEvent event) {
            ++this.configCount;
            return false;
        }

        @OnEvent
        public boolean isOrderRejected() {
            return true;
        }
    }

    public static class Rule1
    extends DefaultRule {
        public Rule1(OrderCache cache) {
            super(cache);
        }

        public Rule1() {
        }

        @OnEvent
        public boolean isOrderRejected() {
            return true;
        }
    }

    public static class DefaultRule {
        public OrderCache cache;

        public DefaultRule(OrderCache cache) {
            this.cache = cache;
        }

        public DefaultRule() {
        }
    }

    public static class OrderCache {
        @EventHandler
        public boolean onNewOrder(NewOrderEvent event) {
            return true;
        }
    }

    public static final class NewOrderEvent
    implements Event {
    }

    public static final class ConfigEvent
    implements Event {
    }

    public static class ValidationBuilder
    extends SEPConfig {
        public ValidationBuilder() {
            RuleValidator validator = (RuleValidator)this.addPublicNode(new RuleValidator(), "validator");
            OrderCache cache = (OrderCache)this.addNode(new OrderCache());
            validator.rules.add((DefaultRule)this.addPublicNode(new Rule1(cache), "rule1"));
            validator.rules.add((DefaultRule)this.addPublicNode(new Rule2(cache), "rule2"));
        }
    }

    public static class FilterBuilderPrivate
    extends SEPConfig {
        public FilterBuilderPrivate() {
            TestHandler handler = (TestHandler)this.addPublicNode(new TestHandler(), "handler");
            this.addPublicNode(new TestChildPrivateParent(handler), "child");
        }
    }

    public static class FilterBuilder
    extends SEPConfig {
        public FilterBuilder() {
            TestHandler handler;
            ((TestChild)this.addPublicNode((Object)new TestChild(), (String)"child")).parent = handler = (TestHandler)this.addPublicNode(new TestHandler(), "handler");
        }
    }

    public static class NoParentUpdate {
    }

    public static class TestChildPrivateParent {
        public int parentCount;
        public int eventCount;
        private final TestHandler parent;

        public TestChildPrivateParent(TestHandler parent) {
            this.parent = parent;
        }

        @OnEvent
        public void onEvent() {
            ++this.eventCount;
        }

        @OnParentUpdate
        public void parentUpdated(TestHandler handler) {
            ++this.parentCount;
        }
    }

    public static class TestChild {
        public int parentCount;
        public int eventCount;
        public TestHandler parent;

        @OnEvent
        public void onEvent() {
            ++this.eventCount;
        }

        @OnParentUpdate
        public void parentUpdated(TestHandler handler) {
            ++this.parentCount;
        }
    }

    public static class TestHandler {
        public int count = 0;

        @EventHandler(filterStringFromClass=String.class)
        public void handleEvent(ClassFilterEvent event) {
            ++this.count;
        }

        @EventHandler(propagate=false)
        public void noParentPropagation(NoUpdateEvent event) {
            ++this.count;
        }
    }

    public static class NoUpdateEvent
    implements Event {
    }

    public static class ClassFilterEvent
    extends DefaultEvent {
        public ClassFilterEvent(Class clazz) {
            this.filterString = clazz.getCanonicalName();
        }
    }
}

