/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.push;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.PushReference;
import com.fluxtion.api.event.Event;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.util.BaseSepTest;
import org.junit.Assert;
import org.junit.Test;

public class PushTest
extends BaseSepTest {
    @Test
    public void testPush() {
        this.buildAndInitSep(PriceBuilder.class);
        PricerFormer priceFormer = (PricerFormer)this.getField("priceFormer");
        MarketHandler tickHandler = (MarketHandler)this.getField("marketHandler");
        Assert.assertEquals((long)0L, (long)priceFormer.eventCount);
        this.onEvent(new MarketTickEvent("EURUSD"));
        Assert.assertEquals((long)1L, (long)priceFormer.eventCount);
        this.onEvent(new MarketTickEvent("EURUSD"));
        Assert.assertEquals((long)2L, (long)priceFormer.eventCount);
        this.onEvent(new MarketTickEvent("USDJPY"));
        Assert.assertEquals((long)2L, (long)priceFormer.eventCount);
    }

    public static class PricerFormer {
        public MarketHandler marketHanlder;
        int eventCount;

        @OnEvent
        public void formPrice() {
            ++this.eventCount;
        }
    }

    public static class MarketHandler {
        int eventCount;
        String ccyPair;

        @EventHandler
        public void newTick(MarketTickEvent tick) {
            ++this.eventCount;
            this.ccyPair = tick.ccyPair;
        }
    }

    public static class Push {
        @PushReference
        public PricerFormer priceFormer;
        public MarketHandler marketHanlder;

        @OnEvent
        public boolean pushData() {
            return this.marketHanlder.ccyPair.equals("EURUSD");
        }
    }

    public static class MarketTickEvent
    implements Event {
        public String ccyPair;

        public MarketTickEvent(String ccyPair) {
            this.ccyPair = ccyPair;
        }
    }

    public static class PriceBuilder
    extends SEPConfig {
        public void buildConfig() {
            MarketHandler tickHandler = (MarketHandler)this.addPublicNode(new MarketHandler(), "marketHandler");
            PricerFormer pricerFormer = (PricerFormer)this.addPublicNode(new PricerFormer(), "priceFormer");
            Push push = (Push)this.addPublicNode(new Push(), "pusher");
            push.marketHanlder = tickHandler;
            push.priceFormer = pricerFormer;
        }
    }
}

