/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.targets.JavaGeneratorNames;
import com.fluxtion.generator.targets.JavaTestGeneratorHelper;
import com.fluxtion.test.event.AnnotatedEventHandlerDirtyNotifier;
import com.fluxtion.test.event.DirtyNotifierNode;
import com.fluxtion.test.event.TestEventNoIdFilteredHandler;
import com.fluxtion.test.event.TestEventNoIdHandler;
import com.fluxtion.test.tracking.Extends_Handler_TraceEvent_InFilter_0;
import com.fluxtion.test.tracking.HandlerNoFilter_TraceEvent_InFilter_0;
import com.fluxtion.test.tracking.Handler_TraceEvent_0;
import com.fluxtion.test.tracking.Handler_TraceEvent_InFilter_0;
import com.fluxtion.test.tracking.Handler_UnMatchedFilter_TraceEvent_InFilter_0;
import com.fluxtion.test.tracking.Node_DirtyFilter_TraceEvent;
import com.fluxtion.test.tracking.Node_TraceEventHolder_Aggregator;
import com.fluxtion.test.tracking.Node_TraceEventHolder_Aggregator_NoFiltering;
import com.fluxtion.test.tracking.Node_TraceEvent_0;
import com.fluxtion.test.tracking.Node_TraceEvent_Aggregator;
import com.fluxtion.test.tracking.Node_TraceEvent_IntFilter_0;
import com.fluxtion.test.tracking.TraceEventHolder;
import com.fluxtion.test.tracking.TraceEventHolderChild;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class JavaTargetTest {
    @Test
    public void test1NoFilter() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                this.addNode(new TestEventNoIdHandler());
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.Test1NoFilter);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.Test1NoFilter);
        Assert.assertEquals((long)1L, (long)genClass.getFields().length);
        Assert.assertEquals((long)1L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)TestEventNoIdHandler.class.getCanonicalName(), (Object)genClass.getFields()[0].getType().getFullyQualifiedName());
        Assert.assertEquals((Object)TestEventNoIdHandler.class.getCanonicalName(), (Object)genClassInline.getFields()[0].getType().getFullyQualifiedName());
    }

    @Test
    public void test1NoIdEventFilter() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                this.addNode(new TestEventNoIdFilteredHandler(25));
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.Test1Filtered);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.Test1Filtered);
        Assert.assertEquals((long)1L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)TestEventNoIdFilteredHandler.class.getCanonicalName(), (Object)genClass.getFields()[0].getType().getFullyQualifiedName());
        Assert.assertEquals((long)1L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)TestEventNoIdFilteredHandler.class.getCanonicalName(), (Object)genClassInline.getFields()[0].getType().getFullyQualifiedName());
    }

    @Test
    public void trace_int_0_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Handler_TraceEvent_InFilter_0 handler = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("A0", 10));
                Node_TraceEvent_IntFilter_0 node_1 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("A1", handler));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1), "aggregator");
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_int_0_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_int_0_test1);
        Assert.assertEquals((long)3L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)3L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_int_0_test2() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Handler_TraceEvent_InFilter_0 handler_1 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("A0", 10));
                Node_TraceEvent_IntFilter_0 node_1 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("A1", handler_1));
                Handler_TraceEvent_InFilter_0 handler_2 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("B0", 20));
                Node_TraceEvent_IntFilter_0 node_2 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("B1", handler_2));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1, node_2), "aggregator");
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_int_0_test2);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_int_0_test2);
        Assert.assertEquals((long)5L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)5L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_int_0_test3() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Handler_TraceEvent_InFilter_0 handler_1 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("A0", 10));
                Node_TraceEvent_IntFilter_0 node_1 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("A1", handler_1));
                Handler_TraceEvent_InFilter_0 handler_2 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("B0", 20));
                Node_TraceEvent_IntFilter_0 node_2 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("B1", handler_2));
                HandlerNoFilter_TraceEvent_InFilter_0 allEventHandler = (HandlerNoFilter_TraceEvent_InFilter_0)this.addNode(new HandlerNoFilter_TraceEvent_InFilter_0("D0"));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1, node_2), "aggregator");
                this.maxFiltersInline = 10;
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_int_0_test3);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_int_0_test3);
        Assert.assertEquals((long)6L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)6L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_int_0_test4() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Extends_Handler_TraceEvent_InFilter_0 handler_1 = (Extends_Handler_TraceEvent_InFilter_0)this.addNode(new Extends_Handler_TraceEvent_InFilter_0("A0", 10));
                Node_TraceEvent_IntFilter_0 node_1 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("A1", handler_1));
                Handler_TraceEvent_InFilter_0 handler_2 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("B0", 20));
                Node_TraceEvent_IntFilter_0 node_2 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("B1", handler_2));
                HandlerNoFilter_TraceEvent_InFilter_0 allEventHandler = (HandlerNoFilter_TraceEvent_InFilter_0)this.addNode(new HandlerNoFilter_TraceEvent_InFilter_0("D0"));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1, node_2), "aggregator");
                this.maxFiltersInline = 10;
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_int_0_test4);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_int_0_test4);
        Assert.assertEquals((long)6L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)6L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_int_0_test5() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Handler_TraceEvent_InFilter_0 handler_1 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("A0", 10));
                TraceEventHolderChild node_1 = (TraceEventHolderChild)this.addNode(new TraceEventHolderChild("A1", handler_1));
                Handler_UnMatchedFilter_TraceEvent_InFilter_0 def_1 = (Handler_UnMatchedFilter_TraceEvent_InFilter_0)this.addNode(new Handler_UnMatchedFilter_TraceEvent_InFilter_0("DEF-0"));
                TraceEventHolderChild def_2 = (TraceEventHolderChild)this.addNode(new TraceEventHolderChild("DEF-1", def_1));
                HandlerNoFilter_TraceEvent_InFilter_0 allEventHandler = (HandlerNoFilter_TraceEvent_InFilter_0)this.addNode(new HandlerNoFilter_TraceEvent_InFilter_0("ANY-1"));
                this.addPublicNode(new Node_TraceEventHolder_Aggregator("aggregator", node_1, def_2, allEventHandler), "aggregator");
                this.maxFiltersInline = 10;
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_int_0_test5);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_int_0_test5);
        Assert.assertEquals((long)6L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEventHolder_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)6L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEventHolder_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_subclass_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                TraceEventHolder subHandler1 = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("sub1", 12));
                TraceEventHolder subNode_1 = (TraceEventHolder)this.addNode(new TraceEventHolderChild("sub1.1", subHandler1));
                TraceEventHolder subHandler_2 = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub2("sub2", 12));
                TraceEventHolder subNode_2 = (TraceEventHolder)this.addNode(new TraceEventHolderChild("sub2.1", subHandler_2));
                Extends_Handler_TraceEvent_InFilter_0 handler_1 = (Extends_Handler_TraceEvent_InFilter_0)this.addNode(new Extends_Handler_TraceEvent_InFilter_0("A0", 10));
                Node_TraceEvent_IntFilter_0 node_1 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("A1", handler_1));
                Handler_TraceEvent_InFilter_0 handler_2 = (Handler_TraceEvent_InFilter_0)this.addNode(new Handler_TraceEvent_InFilter_0("B0", 20));
                Node_TraceEvent_IntFilter_0 node_2 = (Node_TraceEvent_IntFilter_0)this.addNode(new Node_TraceEvent_IntFilter_0("B1", handler_2));
                HandlerNoFilter_TraceEvent_InFilter_0 allEventHandler = (HandlerNoFilter_TraceEvent_InFilter_0)this.addNode(new HandlerNoFilter_TraceEvent_InFilter_0("D0"));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1, node_2), "aggregator");
                this.maxFiltersInline = 12;
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_subclass_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_subclass_test1);
        Assert.assertEquals((long)10L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)10L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }

    @Test
    public void trace_diamond_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                TraceEventHolder handler_A = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("A0", 222));
                TraceEventHolder node_A1 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("A1", handler_A));
                TraceEventHolder handler_B = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub2("B0", 50));
                TraceEventHolder node_AB2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB1", node_A1, handler_B));
                TraceEventHolder node_A2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("A2", node_A1));
                TraceEventHolder traceEventHolder = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB3", node_A2, node_AB2));
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_diamond_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_diamond_test1);
        Assert.assertEquals((long)6L, (long)genClass.getFields().length);
        Assert.assertEquals((long)6L, (long)genClassInline.getFields().length);
    }

    @Test
    public void trace_dirty_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                TraceEventHolder handler_A = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("A0", 1));
                TraceEventHolder node_A1 = (TraceEventHolder)this.addNode(new Node_DirtyFilter_TraceEvent("A1", handler_A));
                TraceEventHolder node_A2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("A2", node_A1));
                TraceEventHolder node_A3 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("A3", node_A2));
                TraceEventHolder handler_B = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub2("B0", 2));
                TraceEventHolder node_B1 = (TraceEventHolder)this.addNode(new Node_DirtyFilter_TraceEvent("B1", handler_B));
                TraceEventHolder node_AB2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB1", node_A1, node_B1));
                TraceEventHolder node_AB3 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB3", node_AB2));
                TraceEventHolder node_AB4 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB4", node_AB3));
                TraceEventHolder traceEventHolder = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("AB5", node_AB4));
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_dirty_test1, true);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_dirty_test1, true);
    }

    @Test
    public void trace_dirty_test3() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                TraceEventHolder handler_A = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("handler_A0", 1));
                TraceEventHolder handler_B = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub2("handler_B0", 2));
                TraceEventHolder filter_A1 = (TraceEventHolder)this.addNode(new Node_DirtyFilter_TraceEvent("filter_A1", handler_A));
                TraceEventHolder filter_B1 = (TraceEventHolder)this.addNode(new Node_DirtyFilter_TraceEvent("filter_B1", handler_B));
                TraceEventHolder node_1 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_1", handler_B));
                TraceEventHolder node_2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_2", filter_A1));
                TraceEventHolder node_3 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_3", filter_A1, filter_B1));
                TraceEventHolder node_4 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_4", node_1, node_3));
                TraceEventHolder node_5 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_5", node_2));
                TraceEventHolder traceEventHolder = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator_NoFiltering("node_6", node_3));
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_dirty_test2, true);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_dirty_test2, true);
    }

    @Test
    public void testDirtyFilterOnEventHandler() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            AnnotatedEventHandlerDirtyNotifier eh = (AnnotatedEventHandlerDirtyNotifier)this.addNode(new AnnotatedEventHandlerDirtyNotifier());
            DirtyNotifierNode dirty_1 = (DirtyNotifierNode)this.addNode(new DirtyNotifierNode("dirty_1", this.eh));
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.testDirtyFilterOnEventHandler, true);
    }

    @Test
    public void trace_eventlifecycle_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                TraceEventHolder handler_A = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("A0", 1));
                TraceEventHolder node_A1 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.EventCompleteTrace("A1", handler_A));
                TraceEventHolder node_A2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.AfterEventTrace("A2", node_A1));
                TraceEventHolder node_A3 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.EventCompleteTrace("A3", node_A2));
                TraceEventHolder handler_B = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("B0", 2));
                TraceEventHolder node_B1 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.AfterEventTrace("B1", handler_B));
                TraceEventHolder node_B2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.EventCompleteTrace("B2", node_B1));
                TraceEventHolder traceEventHolder = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator.AfterEventTrace("B3", node_B2));
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_eventlifecycle_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_eventlifecycle_test1);
        Assert.assertEquals((long)8L, (long)genClass.getFields().length);
        Assert.assertEquals((long)8L, (long)genClassInline.getFields().length);
    }

    @Test
    public void trace_mapdispatch_test1() throws Exception {
        final int filterSize = 40;
        SEPConfig cfg = new SEPConfig(){
            {
                for (int i = 0; i < filterSize; ++i) {
                    TraceEventHolder handler_A = (TraceEventHolder)this.addNode(new TraceEventHolder.TraceEventHandler_sub1("A" + i, i));
                    TraceEventHolder node_A1 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("B" + i, handler_A));
                    TraceEventHolder node_A2 = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("C" + i, node_A1));
                    TraceEventHolder traceEventHolder = (TraceEventHolder)this.addNode(new Node_TraceEventHolder_Aggregator("D" + i, node_A2));
                }
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_mapdispatch_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_mapdispatch_test1);
        long count = Arrays.stream(genClass.getFields()).filter(f -> f.getType().getFullyQualifiedName().equalsIgnoreCase(TraceEventHolder.TraceEventHandler_sub1.class.getName())).count();
        Assert.assertEquals((long)filterSize, (long)count);
        count = Arrays.stream(genClassInline.getFields()).filter(f -> f.getType().getFullyQualifiedName().equalsIgnoreCase(TraceEventHolder.TraceEventHandler_sub1.class.getName())).count();
        Assert.assertEquals((long)filterSize, (long)count);
    }

    @Test
    public void trace_0_test1() throws Exception {
        SEPConfig cfg = new SEPConfig(){
            {
                Handler_TraceEvent_0 handler = (Handler_TraceEvent_0)this.addNode(new Handler_TraceEvent_0("A0"));
                Node_TraceEvent_0 node_1 = (Node_TraceEvent_0)this.addNode(new Node_TraceEvent_0("A1", handler));
                this.addPublicNode(new Node_TraceEvent_Aggregator("aggregator", node_1), "aggregator");
            }
        };
        cfg.generateDescription = false;
        JavaClass genClass = JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.trace_0_test1);
        JavaClass genClassInline = JavaTestGeneratorHelper.generateClassInline(cfg, JavaGeneratorNames.trace_0_test1);
        Assert.assertEquals((long)3L, (long)genClass.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClass.getFieldByName("aggregator").getType().getFullyQualifiedName());
        Assert.assertEquals((long)3L, (long)genClassInline.getFields().length);
        Assert.assertEquals((Object)Node_TraceEvent_Aggregator.class.getCanonicalName(), (Object)genClassInline.getFieldByName("aggregator").getType().getFullyQualifiedName());
    }
}

