/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.Generator;
import com.fluxtion.generator.compiler.SepCompiler;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import com.fluxtion.generator.targets.JavaGeneratorNames;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

public interface JavaTestGeneratorHelper {
    public static void setupDefaultTestContext(String packageName, String className) {
        GenerationContext.setupStaticContext((String)packageName, (String)className, (File)new File("target/generated-test-sources/java/"), (File)new File("target/generated-test-sources/resources/"));
    }

    public static SepCompilerConfig getTestSepCompileConfig(String packageName, String className) {
        SepCompilerConfig cfg = new SepCompilerConfig();
        cfg.setOutputDirectory("target/generated-test-sources/java/");
        cfg.setResourcesOutputDirectory("target/generated-test-sources/resources/");
        cfg.setPackageName(packageName);
        cfg.setClassName(className);
        cfg.setGenerateDescription(false);
        return cfg;
    }

    public static Class generateAndCompile(SepCompilerConfig config) throws Exception {
        SepCompiler compiler = new SepCompiler();
        return compiler.compile(config);
    }

    public static StaticEventProcessor generateAndInstantiate(SepCompilerConfig config) throws Exception {
        Class resultProcessorClass = JavaTestGeneratorHelper.generateAndCompile(config);
        return (StaticEventProcessor)resultProcessorClass.newInstance();
    }

    public static JavaClass generateClass(SEPConfig cfg, GenerationContext context) throws Exception {
        cfg.templateFile = "javaTemplate.vsl";
        Generator generator = new Generator();
        generator.templateSep(cfg);
        JavaDocBuilder builder = new JavaDocBuilder();
        File f = new File("target/generated-test-sources/java/");
        builder.addSourceTree(f);
        JavaClass genClass = builder.getClassByName(context.getPackageName() + "." + context.getSepClassName());
        return genClass;
    }

    public static JavaClass generateClass(SEPConfig cfg, String packageName, String className) throws Exception {
        cfg.templateFile = "javaTemplate.vsl";
        GenerationContext.setupStaticContext((String)packageName, (String)className, (File)new File("target/generated-test-sources/java/"), (File)new File("target/generated-test-sources/resources/"));
        Generator generator = new Generator();
        generator.templateSep(cfg);
        JavaDocBuilder builder = new JavaDocBuilder();
        File f = new File("target/generated-test-sources/java/");
        builder.addSourceTree(f);
        JavaClass genClass = builder.getClassByName(packageName + "." + className);
        return genClass;
    }

    public static JavaClass generateClass(SEPConfig cfg, String className, boolean inLine, boolean dirtySupport) throws Exception {
        cfg.inlineEventHandling = inLine;
        cfg.supportDirtyFiltering = dirtySupport;
        return JavaTestGeneratorHelper.generateClass(cfg, JavaGeneratorNames.packageDefault.name, className);
    }

    public static JavaClass generateClass(SEPConfig cfg, JavaGeneratorNames name, boolean dirtySupport) throws Exception {
        return JavaTestGeneratorHelper.generateClass(cfg, name.name, false, dirtySupport);
    }

    public static JavaClass generateClass(SEPConfig cfg, JavaGeneratorNames name) throws Exception {
        return JavaTestGeneratorHelper.generateClass(cfg, name.name, false, false);
    }

    public static JavaClass generateClassInline(SEPConfig cfg, JavaGeneratorNames name) throws Exception {
        return JavaTestGeneratorHelper.generateClass(cfg, name.name + "_inline", true, false);
    }

    public static JavaClass generateClassInline(SEPConfig cfg, JavaGeneratorNames name, boolean dirtySupport) throws Exception {
        return JavaTestGeneratorHelper.generateClass(cfg, name.name + "_inline", true, dirtySupport);
    }

    public static <T> T sepInstance(JavaGeneratorNames name) throws Exception {
        String fqn = JavaGeneratorNames.packageDefault.name + "." + name.name;
        Class<?> clazzTest = Class.forName(fqn);
        Object newInstance = clazzTest.newInstance();
        return (T)newInstance;
    }

    public static <T> T sepInstanceInline(JavaGeneratorNames name) throws Exception {
        String fqn = JavaGeneratorNames.packageDefault.name + "." + name.name + "_inline";
        Class<?> clazzTest = Class.forName(fqn);
        Object newInstance = clazzTest.newInstance();
        return (T)newInstance;
    }

    public static void testClassOrder(List<?> traceList, Class ... expected) {
        List collect = traceList.stream().map(obj -> obj.getClass()).collect(Collectors.toList());
        Assert.assertThat(collect, (Matcher)IsIterableContainingInOrder.contains((Object[])expected));
    }

    public static void testClassOrder(List<?> traceList, List<?> traceListInline, Class ... expected) {
        JavaTestGeneratorHelper.testClassOrder(traceList, expected);
        JavaTestGeneratorHelper.testClassOrder(traceListInline, expected);
    }

    public static void testTraceIdOrder(List<String> traceList, String ... expectedTrace) {
        Assert.assertThat(traceList, (Matcher)IsIterableContainingInOrder.contains((Object[])expectedTrace));
    }

    public static void testTraceIdContains(List<String> traceList, String ... expectedTrace) {
        Assert.assertThat(traceList, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedTrace));
    }

    public static void testTraceIdOrder(List<String> traceList, List<String> traceListInline, String ... expectedTrace) {
        JavaTestGeneratorHelper.testTraceIdOrder(traceList, expectedTrace);
        JavaTestGeneratorHelper.testTraceIdOrder(traceListInline, expectedTrace);
    }

    public static void testPublicField(Object sep, String fieldName) {
        Assert.assertNotNull((Object)FieldUtils.getDeclaredField(sep.getClass(), (String)fieldName));
    }

    public static void testPublicField(Object sep, Object sepInline, String fieldName) {
        JavaTestGeneratorHelper.testPublicField(sep, fieldName);
        JavaTestGeneratorHelper.testPublicField(sepInline, fieldName);
    }
}

