/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.NoEventReference;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.event.DefaultEvent;
import com.fluxtion.api.event.Event;
import com.fluxtion.api.lifecycle.Lifecycle;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import com.fluxtion.generator.targets.JavaTestGeneratorHelper;
import com.fluxtion.test.event.AnnotatedHandlerNoPropogate;
import com.fluxtion.test.event.RootCB;
import com.fluxtion.test.event.TestEvent;
import com.fluxtion.test.event.TimeEvent;
import org.junit.Assert;
import org.junit.Test;

public class NoPropogationTest {
    @Test
    public void testComplexNoPropogate() throws Exception {
        SepCompilerConfig compileCfg = JavaTestGeneratorHelper.getTestSepCompileConfig("com.fluxtion.generator.test.generated.complexnopropogation", "NoPropogationComplexProcessor");
        compileCfg.setConfigClass(EventFilteringLogBuilder.class.getName());
        compileCfg.setSupportDirtyFiltering(true);
        StaticEventProcessor sep = JavaTestGeneratorHelper.generateAndInstantiate(compileCfg);
        ConsolePrinter root = (ConsolePrinter)sep.getClass().getField("root").get(sep);
        MsgBuilder msgBuilder = (MsgBuilder)sep.getClass().getField("msgBuilder").get(sep);
        ((Lifecycle)sep).init();
        Assert.assertFalse((boolean)root.invoked);
        Assert.assertFalse((boolean)msgBuilder.timeprocessorUpdated);
        sep.onEvent((Object)new TimeEvent());
        Assert.assertFalse((boolean)root.invoked);
        Assert.assertTrue((boolean)msgBuilder.timeprocessorUpdated);
        sep.onEvent((Object)new LogControlEvent("filter"));
        Assert.assertFalse((boolean)root.invoked);
        sep.onEvent((Object)new LogControlEvent("level"));
        Assert.assertFalse((boolean)root.invoked);
        sep.onEvent((Object)new LogToConsole());
        Assert.assertTrue((boolean)root.invoked);
    }

    @Test
    public void testComplexNoPropogateWIthParentUpdate() throws Exception {
        SepCompilerConfig compileCfg = JavaTestGeneratorHelper.getTestSepCompileConfig("com.fluxtion.generator.test.generated.complexnopropogation2", "NoPropogationComplexProcessor");
        compileCfg.setConfigClass(EventFilteringLogBuilder.class.getName());
        compileCfg.setSupportDirtyFiltering(true);
        StaticEventProcessor sep = JavaTestGeneratorHelper.generateAndInstantiate(compileCfg);
        ConsolePrinter root = (ConsolePrinter)sep.getClass().getField("root").get(sep);
        MsgBuilder msgBuilder = (MsgBuilder)sep.getClass().getField("msgBuilder").get(sep);
        NoEventFilterMsg msgBuilder2 = (NoEventFilterMsg)sep.getClass().getField("msgBuilder2").get(sep);
        ((Lifecycle)sep).init();
        Assert.assertFalse((boolean)root.invoked);
        Assert.assertFalse((boolean)msgBuilder.timeprocessorUpdated);
        Assert.assertFalse((boolean)msgBuilder2.timeprocessorUpdated);
        sep.onEvent((Object)new TimeEvent());
        Assert.assertFalse((boolean)root.invoked);
        Assert.assertTrue((boolean)msgBuilder.timeprocessorUpdated);
        Assert.assertTrue((boolean)msgBuilder2.timeprocessorUpdated);
        sep.onEvent((Object)new LogControlEvent("filter"));
        Assert.assertFalse((boolean)root.invoked);
        sep.onEvent((Object)new LogControlEvent("level"));
        Assert.assertFalse((boolean)root.invoked);
        sep.onEvent((Object)new LogToConsole());
        Assert.assertTrue((boolean)root.invoked);
    }

    @Test
    public void testNoPropogate() throws Exception {
        SepCompilerConfig compileCfg = JavaTestGeneratorHelper.getTestSepCompileConfig("com.fluxtion.generator.test.generated.nopropogation", "NoPropogationProcessor");
        compileCfg.setConfigClass(LogBuilder1.class.getName());
        compileCfg.setSupportDirtyFiltering(true);
        StaticEventProcessor sep = JavaTestGeneratorHelper.generateAndInstantiate(compileCfg);
        RootCB root = (RootCB)sep.getClass().getField("root").get(sep);
        ((Lifecycle)sep).init();
        Assert.assertFalse((boolean)root.onEventCalled);
        sep.onEvent((Object)new TimeEvent());
        Assert.assertFalse((boolean)root.onEventCalled);
        sep.onEvent((Object)new TestEvent());
        Assert.assertTrue((boolean)root.onEventCalled);
    }

    public static class ConsolePrinter {
        public boolean invoked = false;
        public MsgBuilder msgBuilder;

        public ConsolePrinter() {
        }

        private ConsolePrinter(MsgBuilder msgBuilder) {
            this.msgBuilder = msgBuilder;
        }

        @OnEvent
        public void publishLog() {
            this.invoked = true;
        }
    }

    public static class NoEventFilterMsg {
        private boolean timeprocessorUpdated;
        @NoEventReference
        public TimeProcessr timeProcessor;
        public LogNotifier notifier;

        public NoEventFilterMsg(TimeProcessr timeProcessr, LogNotifier notifier) {
            this.timeProcessor = timeProcessr;
            this.notifier = notifier;
        }

        public NoEventFilterMsg() {
        }

        @OnParentUpdate(value="timeProcessor")
        public void timeUpdated(TimeProcessr processor) {
            this.timeprocessorUpdated = true;
        }

        @OnEvent
        public boolean buildMessage() {
            return true;
        }
    }

    public static class MsgBuilder
    extends MsgBuulderBase {
        private boolean timeprocessorUpdated;
        @NoEventReference
        public TimeProcessr timeProcessr;
        public LogNotifier notifier;

        public MsgBuilder(TimeProcessr timeProcessr, LogNotifier notifier) {
            this.timeProcessr = timeProcessr;
            this.notifier = notifier;
        }

        public MsgBuilder() {
        }

        @OnParentUpdate
        public void timeUpdated(TimeProcessr processor) {
            this.timeprocessorUpdated = true;
        }

        @OnEvent
        public boolean buildMessage() {
            return true;
        }
    }

    public static class MsgBuulderBase {
        @EventHandler(filterString="level", propagate=false)
        public boolean controlLevel(LogControlEvent lc) {
            return false;
        }

        @EventHandler(filterString="filter", propagate=false)
        public boolean controlFilter(LogControlEvent lc) {
            return false;
        }
    }

    public static class LogNotifier {
        @EventHandler
        public void updateLog(LogToConsole notify) {
        }
    }

    public static class TimeProcessr {
        @EventHandler
        public boolean handleTimeUpdate(TimeEvent event) {
            return true;
        }
    }

    public static class LogToConsole
    implements Event {
    }

    public static class LogControlEvent
    extends DefaultEvent {
        public LogControlEvent(String filter) {
            this.filterString = filter;
        }
    }

    public static class EventFilteringLogBuilder
    extends SEPConfig {
        public EventFilteringLogBuilder() {
            TimeProcessr timeNode = (TimeProcessr)this.addNode(new TimeProcessr());
            LogNotifier logNotifer = (LogNotifier)this.addNode(new LogNotifier());
            MsgBuilder msgBuilder = (MsgBuilder)this.addPublicNode(new MsgBuilder(timeNode, logNotifer), "msgBuilder");
            NoEventFilterMsg msgBuilder2 = (NoEventFilterMsg)this.addPublicNode(new NoEventFilterMsg(timeNode, logNotifer), "msgBuilder2");
            this.addPublicNode(new ConsolePrinter(msgBuilder), "root");
        }
    }

    public static class LogBuilder1
    extends SEPConfig {
        public LogBuilder1() {
            AnnotatedHandlerNoPropogate noPropHandler = (AnnotatedHandlerNoPropogate)this.addNode(new AnnotatedHandlerNoPropogate());
            this.addPublicNode(new RootCB("root", noPropHandler), "root");
        }
    }
}

