/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.time;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Inject;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.event.Event;
import com.fluxtion.api.time.Clock;
import com.fluxtion.api.time.ClockStrategy;
import com.fluxtion.api.time.Tick;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.time.MutableNumber;
import com.fluxtion.generator.util.BaseSepInprocessTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ClockTest
extends BaseSepInprocessTest {
    @Test
    public void testClock() {
        this.sep((SEPConfig c) -> {
            MyClockProxy cfr_ignored_0 = (MyClockProxy)c.addPublicNode((Object)new MyClockProxy(), "proxy");
        });
        MyClockProxy proxy = (MyClockProxy)this.getField("proxy");
        Assert.assertEquals((Object)proxy.clock, (Object)proxy.clock2);
        MutableNumber n = new MutableNumber();
        this.onEvent(new ClockStrategy.ClockStrategyEvent(n::longValue));
        n.set(1);
        Tick tick = new Tick();
        tick.setEventTime(50L);
        this.onEvent(tick);
        this.onEvent(tick);
        this.onEvent(tick);
        Assert.assertThat((Object)proxy.tickCount, (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)proxy.clock.getWallClockTime(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)proxy.clock.getEventTime(), (Matcher)CoreMatchers.is((Object)50L));
        n.set(100);
        Assert.assertThat((Object)proxy.clock.getWallClockTime(), (Matcher)CoreMatchers.is((Object)100L));
        Assert.assertThat((Object)proxy.clock.getEventTime(), (Matcher)CoreMatchers.is((Object)50L));
        this.onEvent(tick);
        Assert.assertThat((Object)proxy.clock.getWallClockTime(), (Matcher)CoreMatchers.is((Object)100L));
        Assert.assertThat((Object)proxy.clock.getEventTime(), (Matcher)CoreMatchers.is((Object)50L));
        n.set(1900);
        this.onEvent(new TestTimeEvent());
        Assert.assertThat((Object)proxy.clock.getWallClockTime(), (Matcher)CoreMatchers.is((Object)1900L));
        Assert.assertThat((Object)proxy.clock.getEventTime(), (Matcher)CoreMatchers.is((Object)200L));
    }

    public static class MyClockProxy {
        @Inject
        public Clock clock;
        @Inject
        public Clock clock2;
        public int tickCount;

        @OnEvent
        public void update() {
        }

        @EventHandler
        public void tickHandler(Tick e) {
            ++this.tickCount;
        }

        @EventHandler
        public void noTimeEvent(NoTimeEvent e) {
        }

        @EventHandler
        public void testTimedEvent(TestTimeEvent e) {
        }
    }

    public static class NoTimeEvent
    implements Event {
    }

    public static class TestTimeEvent
    implements Event {
        public long getEventTime() {
            return 200L;
        }
    }
}

