/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.util;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.api.lifecycle.Lifecycle;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.InprocessSepCompiler;
import java.util.function.Consumer;
import net.vidageek.mirror.dsl.Mirror;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class BaseSepInprocessTest {
    protected StaticEventProcessor sep;
    protected boolean fixedPkg = false;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void beforeTest() {
        this.fixedPkg = false;
    }

    protected StaticEventProcessor sep(Class<? extends StaticEventProcessor> handlerClass) {
        try {
            this.sep = handlerClass.newInstance();
            if (this.sep instanceof Lifecycle) {
                ((Lifecycle)this.sep).init();
            }
            return this.sep;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected StaticEventProcessor sep(Consumer<SEPConfig> cfgBuilder) {
        try {
            this.sep = InprocessSepCompiler.sepTestInstance(cfgBuilder, (String)this.pckName(), (String)this.sepClassName());
            return this.sep;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String pckName() {
        String pckg = this.getClass().getCanonicalName() + "_" + this.testName.getMethodName();
        pckg = pckg.toLowerCase();
        if (!this.fixedPkg) {
            pckg = pckg + "_" + System.currentTimeMillis();
        }
        return pckg;
    }

    protected String sepClassName() {
        return "TestSep_" + this.testName.getMethodName();
    }

    protected <T> T getField(String name) {
        return (T)new Mirror().on((Object)this.sep).get().field(name);
    }

    protected void onEvent(Object e) {
        this.sep.onEvent(e);
    }

    protected void onGenericEvent(Object e) {
        this.onEvent(e);
    }
}

