/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.util;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.api.event.Event;
import com.fluxtion.api.lifecycle.Lifecycle;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.DeclarativeNodeConiguration;
import com.fluxtion.builder.node.NodeFactory;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import com.fluxtion.generator.targets.JavaTestGeneratorHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import net.vidageek.mirror.dsl.Mirror;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class BaseSepTest {
    protected SepCompilerConfig compileCfg;
    protected StaticEventProcessor sep;
    @Rule
    public TestName testName = new TestName();
    protected String pckg;
    protected String className;

    @Before
    public void beforeTest() {
        this.pckg = this.getClass().getCanonicalName() + "_" + this.testName.getMethodName() + "_" + this.testPackageID();
        this.pckg = this.pckg.toLowerCase();
        this.className = this.sepClassName();
        JavaTestGeneratorHelper.setupDefaultTestContext(this.pckg, this.className);
        this.compileCfg = JavaTestGeneratorHelper.getTestSepCompileConfig(this.pckg, this.className);
        BaseSepTest.cleanOuputDirectory(this.compileCfg);
        this.compileCfg.setSupportDirtyFiltering(true);
        this.compileCfg.setGenerateDescription(false);
    }

    protected String sepClassName() {
        return "TestSep_" + this.testName.getMethodName();
    }

    protected String testPackageID() {
        return "" + System.currentTimeMillis();
    }

    protected StaticEventProcessor buildAndInitSep(Class<? extends SEPConfig> builderClass) {
        try {
            this.compileCfg.setCachedCompiler(GenerationContext.SINGLETON.getJavaCompiler());
            this.compileCfg.setConfigClass(builderClass.getName());
            this.sep = JavaTestGeneratorHelper.generateAndInstantiate(this.compileCfg);
            ((Lifecycle)this.sep).init();
            return this.sep;
        }
        catch (Exception ex) {
            throw new RuntimeException("could not build SEP:" + ex.getMessage(), ex);
        }
    }

    public static DeclarativeNodeConiguration factorySet(Class<? extends NodeFactory> ... classes) {
        HashSet<Class<? extends NodeFactory>> factoryList = new HashSet<Class<? extends NodeFactory>>();
        factoryList.addAll(Arrays.asList(classes));
        DeclarativeNodeConiguration declarativeConfig = new DeclarativeNodeConiguration(null, factoryList, null);
        return declarativeConfig;
    }

    protected <T> T getField(String name) {
        return (T)new Mirror().on((Object)this.sep).get().field(name);
    }

    protected void onEvent(Event e) {
        this.sep.onEvent((Object)e);
    }

    public static void cleanOuputDirectory(SepCompilerConfig compilerConfig) {
        File file = new File(compilerConfig.getOutputDirectory(), compilerConfig.getPackageName().replace(".", "/"));
        try {
            if (file.exists()) {
                FileUtils.cleanDirectory((File)file);
            }
        }
        catch (IOException ex) {
            System.out.println("WARNING: could not delete source output directory:" + file);
        }
    }
}

