/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.test.nodegen;

import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.NodeFactory;
import com.fluxtion.builder.node.NodeRegistry;
import com.fluxtion.test.nodegen.AveragingNode;
import com.fluxtion.test.nodegen.ConfigHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class AveragingNodeFactory
implements NodeFactory<AveragingNode> {
    private static final String NAME_SPACE = "AveragingNode";
    public static final String DATA_SOURCE = "AveragingNode.dataSource";
    public static final String DATA_SOURCE_FIELD = "AveragingNode.dataSourceField";
    public static final String WINDOW_SIZE = "AveragingNode.windowSize";
    public static final String OUTPUT_AVERAGE = "AveragingNode.average";
    private final String TEMPLATE_JAVA = "nodegen/javaAveragingNodeTemplate.vsl";
    private GenerationContext generationConfig;
    private static int count;

    public AveragingNode createNode(Map config, NodeRegistry registry) {
        try {
            AveragingNode node = new AveragingNode();
            node.dataSource = config.get(DATA_SOURCE);
            String dataSourceClassName = node.dataSource.getClass().getCanonicalName();
            String dataSourceField = (String)config.get(DATA_SOURCE_FIELD);
            int windowSize = ConfigHelper.intFromMap(config, WINDOW_SIZE, 10);
            String generatedClassName = "AveragingNode_" + count++;
            String outputPackage = this.generationConfig.getPackageName();
            File outputDirectory = this.generationConfig.getPackageDirectory();
            Template template = Velocity.getTemplate((String)"nodegen/javaAveragingNodeTemplate.vsl");
            VelocityContext ctx = new VelocityContext();
            ctx.put("windowSize", (Object)windowSize);
            ctx.put("dataSourceClass", (Object)dataSourceClassName);
            ctx.put("dataSourceField", (Object)dataSourceField);
            ctx.put("package", (Object)outputPackage);
            ctx.put("className", (Object)generatedClassName);
            File outFile = new File(outputDirectory, generatedClassName + ".java");
            FileWriter templateWriter = new FileWriter(outFile);
            template.merge((Context)ctx, (Writer)templateWriter);
            templateWriter.flush();
            this.generationConfig.getProxyClassMap().put(node, generatedClassName);
            return node;
        }
        catch (IOException ex) {
            throw new RuntimeException("unable to create proxied class for AveragingNode", ex);
        }
    }

    public void preSepGeneration(GenerationContext context) {
        this.generationConfig = context;
    }
}

