/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.test.nodes;

import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.OnBatchEnd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Accumulator {
    private List<String> inputQueue;
    private String currentVal;

    public void add(char c) {
        if (Character.isDigit(c)) {
            this.currentVal = this.currentVal + c;
            int ptr = this.inputQueue.size() - 1;
            if (ptr < 0) {
                this.inputQueue.add(this.currentVal);
            } else {
                this.inputQueue.set(ptr, this.currentVal);
            }
        } else {
            this.inputQueue.add("" + c);
            this.currentVal = "";
            this.inputQueue.add(this.currentVal);
        }
    }

    @Initialise
    public void init() {
        this.inputQueue = new ArrayList<String>();
        this.currentVal = "";
    }

    @OnBatchEnd
    public void batchEnd() {
        this.inputQueue.clear();
        this.currentVal = "";
    }

    public List<String> getInputQueue() {
        return Collections.unmodifiableList(this.inputQueue);
    }
}

