/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.test.nodes;

import com.fluxtion.builder.node.NodeFactory;
import com.fluxtion.builder.node.NodeRegistry;
import com.fluxtion.test.nodes.Accumulator;
import com.fluxtion.test.nodes.KeyProcessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorFactory
implements NodeFactory<Accumulator> {
    public static final String KEY_BASE = AccumulatorFactory.class.getName() + ".KEY_BASE";
    public static final String VAL_BASE_10 = AccumulatorFactory.class.getName() + ".VAL_BASE_10";
    public static final String VAL_HEX = AccumulatorFactory.class.getName() + ".VAL_HEX";
    public static final String VAL_BINARY = AccumulatorFactory.class.getName() + ".VAL_BINARY";
    private Accumulator base10;
    private static final Logger LOG = LoggerFactory.getLogger(Accumulator.class);
    private boolean createdKeys = false;
    private char[] operations = new char[]{'+', '-', '*', '/'};

    public Accumulator createNode(Map config, NodeRegistry registry) {
        if (this.base10 == null) {
            this.base10 = new Accumulator();
        }
        return this.base10;
    }

    public void postInstanceRegistration(Map config, NodeRegistry registry, Accumulator instance) {
        LOG.info("postInstanceRegistration");
        if (!this.createdKeys) {
            this.createdKeys = true;
            int count = 10;
            for (int i = 0; i < count; ++i) {
                config.put("KeyProcessorFactory.charKey", Character.valueOf((char)(i + 48)));
                config.put("KeyProcessorFactory.notifyAccumulator", "true");
                registry.findOrCreateNode(KeyProcessor.class, config, null);
            }
            for (char operation : this.operations) {
                config.put("KeyProcessorFactory.charKey", Character.valueOf(operation));
                config.put("KeyProcessorFactory.notifyAccumulator", "true");
                registry.findOrCreateNode(KeyProcessor.class, config, null);
            }
        }
    }
}

