/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.annotations.TearDown;
import com.fluxtion.api.event.DefaultEvent;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.creator.CreatorConfig;
import com.fluxtion.creator.EventDefinition;
import com.fluxtion.creator.Node;
import com.fluxtion.creator.ReferenceDefinition;
import com.fluxtion.creator.SepConfigGenerator;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import net.openhft.compiler.CachedCompiler;
import org.apache.commons.lang3.ClassUtils;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Creator {
    private final SimpleDirectedGraph<Node, FieldEdge> graph = new SimpleDirectedGraph(FieldEdge.class);
    private CreatorConfig config;
    private Map<String, Node> id2NodeMap;
    private Map<String, EventDefinition> id2EventMap;
    private static final Logger LOG = LoggerFactory.getLogger(Creator.class);

    public Class createModel(CreatorConfig config) throws Exception {
        this.config = config;
        this.buildGraph();
        this.generateAndCompileEvents();
        this.generateAndCompileNodes();
        return this.generateAndCompileSepConfig();
    }

    private void buildGraph() {
        LOG.debug("building graph");
        this.id2NodeMap = this.config.getNodes().stream().collect(Collectors.toMap(Node::getId, t -> t));
        this.id2EventMap = this.config.getEvents().stream().collect(Collectors.toMap(EventDefinition::getId, t -> t));
        this.config.getNodes().stream().forEach(arg_0 -> this.graph.addVertex(arg_0));
        this.config.getNodes().stream().forEach(n -> n.getNodes().forEach(ref -> {
            FieldEdge field = new FieldEdge((ReferenceDefinition)ref);
            LOG.debug("adding edge {}", (Object)field);
            this.graph.addEdge(n, (Object)this.id2NodeMap.get(ref.getNode()), (Object)field);
        }));
    }

    private void generateAndCompileEvents() {
        this.config.getEvents().stream().forEach(this::createAndCompileEvent);
    }

    private void generateAndCompileNodes() {
        LOG.debug("generating nodes");
        this.graph.vertexSet().stream().filter(this::isNotCompiled).forEach(node -> {
            try {
                LOG.debug("building node {}", node);
                String className = node.getClassName();
                String fqn = node.getType();
                TypeSpec.Builder nodeBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
                this.graph.outgoingEdgesOf(node).stream().forEach(f -> {
                    String name = f.getFieldName();
                    ClassName type = ClassName.get((String)f.getPackageName(), (String)f.getClassName(), (String[])new String[0]);
                    FieldSpec android = FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
                    nodeBuilder.addField(android);
                    MethodSpec handler = MethodSpec.methodBuilder((String)("parentUpdate_" + name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter((TypeName)type, "parent", new Modifier[0]).addStatement("return true", new Object[0]).addAnnotation(AnnotationSpec.builder(OnParentUpdate.class).addMember("value", "$S", new Object[]{name}).build()).build();
                    nodeBuilder.addMethod(handler);
                });
                if (this.graph.outgoingEdgesOf(node).size() > 0) {
                    MethodSpec handler = MethodSpec.methodBuilder((String)"onEvent").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return true", new Object[0]).addAnnotation(AnnotationSpec.builder(OnEvent.class).build()).build();
                    nodeBuilder.addMethod(handler);
                }
                node.getEvents().stream().forEach(e -> {
                    EventDefinition t = this.id2EventMap.get(e.getEventId());
                    AnnotationSpec.Builder annoBuilder = AnnotationSpec.builder(EventHandler.class).addMember("propagate", e.isPropagate() + "", new Object[0]);
                    if (e.getFilter() != null) {
                        annoBuilder.addMember("filterId", e.getFilter(), new Object[0]);
                    }
                    ClassName type = ClassName.get((String)t.getPackageName(), (String)t.getClassName(), (String[])new String[0]);
                    MethodSpec handler = MethodSpec.methodBuilder((String)("handler" + t.getClassName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter((TypeName)type, "event", new Modifier[0]).addStatement("return true", new Object[0]).addAnnotation(annoBuilder.build()).build();
                    nodeBuilder.addMethod(handler);
                });
                MethodSpec initHandler = MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Initialise.class).build()).build();
                nodeBuilder.addMethod(initHandler);
                MethodSpec handler = MethodSpec.methodBuilder((String)"teardown").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(TearDown.class).build()).build();
                nodeBuilder.addMethod(handler);
                TypeSpec nodeClass = nodeBuilder.build();
                JavaFile javaFile = this.addLicense(JavaFile.builder((String)GenerationContext.SINGLETON.getPackageName(), (TypeSpec)nodeClass)).build();
                javaFile.writeTo(GenerationContext.SINGLETON.getSourceRootDirectory());
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Creator.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.compileNodes();
    }

    private JavaFile.Builder addLicense(JavaFile.Builder builder) {
        builder.addFileComment("Copyright (C) 2018 V12 Technology Ltd.\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the Server Side Public License, version 1,\nas published by MongoDB, Inc.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nServer Side License for more details.\n\nYou should have received a copy of the Server Side Public License\nalong with this program.  If not, see \n<http://www.mongodb.com/licensing/server-side-public-license>.", new Object[0]);
        return builder;
    }

    private void compileNodes() {
        LOG.debug("compiling nodes");
        ArrayList<Node> nodes = new ArrayList<Node>();
        TopologicalOrderIterator topIter = new TopologicalOrderIterator(this.graph);
        while (topIter.hasNext()) {
            nodes.add((Node)topIter.next());
        }
        Collections.reverse(nodes);
        nodes.stream().filter(this::isNotCompiled).forEach(node -> {
            LOG.debug("compiling node id:{}", (Object)node.getId());
            this.compile(node.getType());
        });
    }

    private void createAndCompileEvent(EventDefinition eventDefinition) {
        String fqn = eventDefinition.getType();
        if (!this.loadClass(fqn).isPresent()) {
            LOG.debug("compiling event:{}", (Object)fqn);
            try {
                String className = eventDefinition.getClassName();
                System.out.println("building event:" + className + " fqn:" + fqn);
                TypeSpec.Builder nodeBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).superclass((TypeName)ClassName.get(DefaultEvent.class));
                TypeSpec nodeClass = nodeBuilder.build();
                JavaFile javaFile = this.addLicense(JavaFile.builder((String)GenerationContext.SINGLETON.getPackageName(), (TypeSpec)nodeClass)).build();
                javaFile.writeTo(GenerationContext.SINGLETON.getSourceRootDirectory());
                this.compile(fqn);
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Creator.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            LOG.debug("re-using event:{}", (Object)fqn);
        }
    }

    private boolean isNotCompiled(Node node) {
        return !this.isCompiled(node);
    }

    private boolean isCompiled(Node node) {
        boolean compiled;
        boolean bl = compiled = node.isFactoryCreated() || this.loadClass(node.getType()).isPresent();
        if (!compiled) {
            LOG.debug("un-compiled node id:{}", (Object)node.getId());
        }
        return compiled;
    }

    private Optional<Class> loadClass(String fqn) {
        Optional<Class> clazz = Optional.empty();
        try {
            clazz = Optional.ofNullable(GenerationContext.SINGLETON.getClassLoader().loadClass(fqn));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private Class compile(String fqn) {
        try {
            File file = new File(GenerationContext.SINGLETON.getPackageDirectory(), ClassUtils.getShortClassName((String)fqn) + ".java");
            CachedCompiler javaCompiler = GenerationContext.SINGLETON.getJavaCompiler();
            String javaCode = GenerationContext.readText((String)file.getCanonicalPath());
            return javaCompiler.loadFromJava(GenerationContext.SINGLETON.getClassLoader(), fqn, javaCode);
        }
        catch (IOException | ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Creator.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("cannot generate creator class", ex);
        }
    }

    private Class generateAndCompileSepConfig() throws Exception {
        LOG.debug("generate and compile SEPConfig");
        String className = this.config.getSepCfgShortClassName();
        String packageName = this.config.getSepCfgPackageName();
        TypeSpec.Builder nodeBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).superclass((TypeName)ClassName.get(SEPConfig.class));
        Method method = SEPConfig.class.getMethod("buildConfig", new Class[0]);
        MethodSpec.Builder initHandler = MethodSpec.methodBuilder((String)"buildConfig").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Override.class).build());
        initHandler.addComment("creating node instance", new Object[0]);
        this.graph.vertexSet().stream().forEach(node -> {
            block9: {
                try {
                    if (node.isFactoryCreated()) {
                        try {
                            SepConfigGenerator gen = (SepConfigGenerator)Class.forName(node.getFactoryType()).newInstance();
                            initHandler.addStatement("$1T $2L", new Object[]{node.getNodeClass(), node.getId()});
                            String code = gen.sepConfigStatement(node.getConfigBean(), node.getId(), null);
                            initHandler.addCode(code, new Object[0]);
                            if (node.isPublicAccess()) {
                                initHandler.addStatement("addPublicNode($1L, $1S)", new Object[]{node.getId()});
                            } else {
                                initHandler.addStatement("addNode($1L)", new Object[]{node.getId()});
                            }
                        }
                        catch (IllegalAccessException | InstantiationException ex) {
                            throw new RuntimeException("problem generating SEP config", ex);
                        }
                        System.out.println("factory created");
                        break block9;
                    }
                    if (node.isPublicAccess()) {
                        initHandler.addStatement("$1T $2L = addPublicNode(new $1T(), $2S)", new Object[]{node.getNodeClass(), node.getId()});
                    } else {
                        initHandler.addStatement("$1T $2L = addNode(new $1T())", new Object[]{node.getNodeClass(), node.getId()});
                    }
                }
                catch (ClassNotFoundException ex) {
                    java.util.logging.Logger.getLogger(Creator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        initHandler.addComment("setting node reference", new Object[0]);
        this.graph.edgeSet().stream().forEach(field -> {
            String src = ((Node)this.graph.getEdgeSource((Object)field)).getId();
            String target = ((Node)this.graph.getEdgeTarget((Object)field)).getId();
            String id = field.getFieldName();
            initHandler.addStatement("$1L.$2L = $3L", new Object[]{src, id, target});
        });
        if (this.config.getAuditorClass() != null) {
            initHandler.addComment("adding auditor", new Object[0]);
            Class<?> clazz = Class.forName(this.config.getAuditorClass());
            initHandler.addStatement("addAuditor(new $T(), \"auditor\") ", new Object[]{clazz});
        }
        nodeBuilder.addMethod(initHandler.build());
        TypeSpec nodeClass = nodeBuilder.build();
        JavaFile javaFile = this.addLicense(JavaFile.builder((String)packageName, (TypeSpec)nodeClass)).build();
        javaFile.writeTo(GenerationContext.SINGLETON.getSourceRootDirectory());
        return this.compile(this.config.getOutputSepConfigClass());
    }

    public class FieldEdge
    extends DefaultEdge {
        public ReferenceDefinition ref;
        public Node refNode;

        public FieldEdge(ReferenceDefinition ref) {
            this.ref = ref;
            this.refNode = (Node)Creator.this.id2NodeMap.get(ref.getNode());
        }

        public String getFieldName() {
            return this.ref.getName();
        }

        public String getFqn() {
            return this.refNode.getType();
        }

        public String getClassName() {
            return this.refNode.getClassName();
        }

        public String getPackageName() {
            return this.refNode.getPackageName();
        }

        public ReferenceDefinition getRef() {
            return this.ref;
        }

        public Node getRefNode() {
            return this.refNode;
        }

        public void setRef(ReferenceDefinition ref) {
            this.ref = ref;
        }

        public void setRefNode(Node refNode) {
            this.refNode = refNode;
        }

        public String toString() {
            return "Creator.FieldEdge(ref=" + this.getRef() + ", refNode=" + this.getRefNode() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldEdge)) {
                return false;
            }
            FieldEdge other = (FieldEdge)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReferenceDefinition this$ref = this.getRef();
            ReferenceDefinition other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !((Object)this$ref).equals(other$ref)) {
                return false;
            }
            Node this$refNode = this.getRefNode();
            Node other$refNode = other.getRefNode();
            return !(this$refNode == null ? other$refNode != null : !((Object)this$refNode).equals(other$refNode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldEdge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ReferenceDefinition $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : ((Object)$ref).hashCode());
            Node $refNode = this.getRefNode();
            result = result * 59 + ($refNode == null ? 43 : ((Object)$refNode).hashCode());
            return result;
        }
    }
}

