/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.creator.EventDefinition;
import com.fluxtion.creator.Node;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class CreatorConfig {
    private String outputSepConfigClass;
    private String outputPackage;
    private String auditorClass;
    private List<Node> nodes;
    private List<EventDefinition> events;
    private String processorId;

    public String getSepCfgShortClassName() {
        return ClassUtils.getShortCanonicalName((String)this.outputSepConfigClass);
    }

    public String getSepCfgPackageName() {
        return ClassUtils.getPackageCanonicalName((String)this.outputSepConfigClass);
    }

    public void addNode(Node node) {
        this.getNodes().add(this.cleanNode(node));
    }

    private Node cleanNode(Node node) {
        try {
            GenerationContext.SINGLETON.getClassLoader().loadClass(node.getType());
        }
        catch (ClassNotFoundException ex) {
            node.setType(this.outputPackage + "." + node.getClassName());
        }
        return node;
    }

    private EventDefinition cleanEvent(EventDefinition node) {
        try {
            GenerationContext.SINGLETON.getClassLoader().loadClass(node.getType());
        }
        catch (ClassNotFoundException ex) {
            node.setType(this.outputPackage + "." + node.getClassName());
        }
        return node;
    }

    public void validateConfig() {
        this.nodes.stream().forEach(this::cleanNode);
        this.events.stream().forEach(this::cleanEvent);
    }

    public String getOutputSepConfigClass() {
        return this.outputSepConfigClass;
    }

    public String getOutputPackage() {
        return this.outputPackage;
    }

    public String getAuditorClass() {
        return this.auditorClass;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<EventDefinition> getEvents() {
        return this.events;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setOutputSepConfigClass(String outputSepConfigClass) {
        this.outputSepConfigClass = outputSepConfigClass;
    }

    public void setOutputPackage(String outputPackage) {
        this.outputPackage = outputPackage;
    }

    public void setAuditorClass(String auditorClass) {
        this.auditorClass = auditorClass;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEvents(List<EventDefinition> events) {
        this.events = events;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatorConfig)) {
            return false;
        }
        CreatorConfig other = (CreatorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$outputSepConfigClass = this.getOutputSepConfigClass();
        String other$outputSepConfigClass = other.getOutputSepConfigClass();
        if (this$outputSepConfigClass == null ? other$outputSepConfigClass != null : !this$outputSepConfigClass.equals(other$outputSepConfigClass)) {
            return false;
        }
        String this$outputPackage = this.getOutputPackage();
        String other$outputPackage = other.getOutputPackage();
        if (this$outputPackage == null ? other$outputPackage != null : !this$outputPackage.equals(other$outputPackage)) {
            return false;
        }
        String this$auditorClass = this.getAuditorClass();
        String other$auditorClass = other.getAuditorClass();
        if (this$auditorClass == null ? other$auditorClass != null : !this$auditorClass.equals(other$auditorClass)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<EventDefinition> this$events = this.getEvents();
        List<EventDefinition> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        String this$processorId = this.getProcessorId();
        String other$processorId = other.getProcessorId();
        return !(this$processorId == null ? other$processorId != null : !this$processorId.equals(other$processorId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreatorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $outputSepConfigClass = this.getOutputSepConfigClass();
        result = result * 59 + ($outputSepConfigClass == null ? 43 : $outputSepConfigClass.hashCode());
        String $outputPackage = this.getOutputPackage();
        result = result * 59 + ($outputPackage == null ? 43 : $outputPackage.hashCode());
        String $auditorClass = this.getAuditorClass();
        result = result * 59 + ($auditorClass == null ? 43 : $auditorClass.hashCode());
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<EventDefinition> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        String $processorId = this.getProcessorId();
        result = result * 59 + ($processorId == null ? 43 : $processorId.hashCode());
        return result;
    }

    public String toString() {
        return "CreatorConfig(outputSepConfigClass=" + this.getOutputSepConfigClass() + ", outputPackage=" + this.getOutputPackage() + ", auditorClass=" + this.getAuditorClass() + ", nodes=" + this.getNodes() + ", events=" + this.getEvents() + ", processorId=" + this.getProcessorId() + ")";
    }
}

