/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.creator.EventMethod;
import com.fluxtion.creator.ReferenceDefinition;
import com.fluxtion.creator.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class Node
extends TypeDefinition {
    private String id;
    private boolean publicAccess;
    private List<EventMethod> events;
    private List<ReferenceDefinition> nodes;
    private Object configBean;
    private String factoryType;

    public Node() {
        this(null, null, false);
    }

    public Node(String fqn, String id, boolean publicAccess) {
        super(fqn);
        this.id = id;
        this.publicAccess = publicAccess;
        this.packageName = ClassUtils.getPackageCanonicalName((String)fqn);
        this.className = ClassUtils.getShortCanonicalName((String)fqn);
        this.events = new ArrayList<EventMethod>();
        this.nodes = new ArrayList<ReferenceDefinition>();
    }

    public Node(String fqn, String id) {
        this(fqn, id, false);
    }

    public <T> Class<T> getNodeClass() throws ClassNotFoundException {
        Class forName = null;
        try {
            forName = Class.forName(this.getType());
        }
        catch (Exception e) {
            forName = GenerationContext.SINGLETON.forName(this.getType());
        }
        return forName;
    }

    public void setRef(String nodeId, String fieldName) {
        this.nodes.add(new ReferenceDefinition(nodeId, fieldName));
    }

    public <T> T getConfigBean() {
        return (T)this.configBean;
    }

    public boolean isFactoryCreated() {
        return this.factoryType != null;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public List<EventMethod> getEvents() {
        return this.events;
    }

    public List<ReferenceDefinition> getNodes() {
        return this.nodes;
    }

    public String getFactoryType() {
        return this.factoryType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
    }

    public void setEvents(List<EventMethod> events) {
        this.events = events;
    }

    public void setNodes(List<ReferenceDefinition> nodes) {
        this.nodes = nodes;
    }

    public void setConfigBean(Object configBean) {
        this.configBean = configBean;
    }

    public void setFactoryType(String factoryType) {
        this.factoryType = factoryType;
    }

    @Override
    public String toString() {
        return "Node(id=" + this.getId() + ", publicAccess=" + this.isPublicAccess() + ", events=" + this.getEvents() + ", nodes=" + this.getNodes() + ", configBean=" + this.getConfigBean() + ", factoryType=" + this.getFactoryType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.isPublicAccess() != other.isPublicAccess()) {
            return false;
        }
        List<EventMethod> this$events = this.getEvents();
        List<EventMethod> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        List<ReferenceDefinition> this$nodes = this.getNodes();
        List<ReferenceDefinition> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Object this$configBean = this.getConfigBean();
        Object other$configBean = other.getConfigBean();
        if (this$configBean == null ? other$configBean != null : !this$configBean.equals(other$configBean)) {
            return false;
        }
        String this$factoryType = this.getFactoryType();
        String other$factoryType = other.getFactoryType();
        return !(this$factoryType == null ? other$factoryType != null : !this$factoryType.equals(other$factoryType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + (this.isPublicAccess() ? 79 : 97);
        List<EventMethod> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        List<ReferenceDefinition> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Object $configBean = this.getConfigBean();
        result = result * 59 + ($configBean == null ? 43 : $configBean.hashCode());
        String $factoryType = this.getFactoryType();
        result = result * 59 + ($factoryType == null ? 43 : $factoryType.hashCode());
        return result;
    }
}

