/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.builder.annotation.ClassProcessor;
import com.fluxtion.builder.annotation.Disabled;
import com.fluxtion.builder.annotation.SepInstance;
import com.fluxtion.generator.compiler.ClassProcessorDispatcher;
import com.fluxtion.generator.compiler.InprocessSepCompiler;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedClassCompiler
implements ClassProcessor {
    private Logger LOGGER = LoggerFactory.getLogger((String)AnnotatedClassCompiler.class.getName());
    private File generatedDir;
    private File resourceDir;
    private File rootDir;

    public void outputDirectories(File rootDir, File output, File resourceDir) {
        this.rootDir = rootDir;
        this.generatedDir = output;
        this.resourceDir = resourceDir;
    }

    public void process(URL classPath) {
        if (classPath == null) {
            this.LOGGER.warn("scan classpath is null, exiting AnnotatedClassCompiler");
            return;
        }
        try {
            File fin = new File(classPath.toURI());
            this.LOGGER.debug("AnnotationCompiler scanning url:'{}' for SepInstance annotations", (Object)fin);
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().overrideClasspath(new Object[]{fin}).scan();){
                ClassInfoList csvList = scanResult.getClassesWithAnnotation(SepInstance.class.getCanonicalName()).exclude(scanResult.getClassesWithAnnotation(Disabled.class.getCanonicalName()));
                for (ClassInfo csvClassInfo : csvList) {
                    Class csvClass = csvClassInfo.loadClass();
                    Object newInstance = csvClass.newInstance();
                    AnnotationInfo annotationInfo = csvClassInfo.getAnnotationInfo(Disabled.class.getCanonicalName());
                    if (annotationInfo == null) {
                        this.LOGGER.info("Adding instance to Sep class:" + csvClass.getCanonicalName());
                        AnnotationParameterValueList params = csvClassInfo.getAnnotationInfo(SepInstance.class.getCanonicalName()).getParameterValues();
                        boolean init = params.get("initialise") == null || (Boolean)params.get("initialise") != false;
                        ClassProcessorDispatcher.DirectoryNames dirNames = ClassProcessorDispatcher.standardParamsHelper(params, this.rootDir, this.generatedDir, this.resourceDir);
                        InprocessSepCompiler.sepInstance(cfg -> {
                            cfg.addPublicNode(newInstance, "processor");
                            boolean supportDirtyFiltering = true;
                            if (params.get("supportDirtyFiltering") != null) {
                                supportDirtyFiltering = (Boolean)params.get("supportDirtyFiltering");
                            }
                            cfg.supportDirtyFiltering = supportDirtyFiltering;
                        }, dirNames.pkgName, params.get("name").toString(), dirNames.outDir, dirNames.resDir, init);
                        continue;
                    }
                    this.LOGGER.info("disabled Fluxtion SEP node generation for:" + csvClass.getCanonicalName());
                }
            }
            catch (Exception ex) {
                this.LOGGER.error("problem creating static event processor, node should have default constructor", (Throwable)ex);
            }
        }
        catch (URISyntaxException ex) {
            this.LOGGER.error("problem generating static event processor", (Throwable)ex);
        }
        this.LOGGER.debug("AnnotatedClassCompiler completed");
    }
}

