/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.builder.annotation.ClassProcessor;
import com.fluxtion.builder.generation.GenerationContext;
import io.github.classgraph.AnnotationParameterValueList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassProcessorDispatcher
implements BiConsumer<URL, File> {
    static final Logger LOGGER = LoggerFactory.getLogger(ClassProcessorDispatcher.class);

    @Override
    public void accept(final URL url, final File baseDir) {
        ServiceLoader<ClassProcessor> loadServices;
        LOGGER.debug("AnnotationProcessor locator");
        HashSet subTypes = new HashSet();
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for factories");
            loadServices = ServiceLoader.load(ClassProcessor.class, GenerationContext.SINGLETON.getClassLoader());
        } else {
            LOGGER.debug("loading services through class loader for this class");
            loadServices = ServiceLoader.load(ClassProcessor.class, this.getClass().getClassLoader());
        }
        loadServices.forEach(t -> subTypes.add(t.getClass()));
        LOGGER.debug("loaded AnnotationProcessors: {}", subTypes);
        final File outDir = GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getSourceRootDirectory() != null ? GenerationContext.SINGLETON.getSourceRootDirectory() : new File(baseDir, "target/generated-sources/fluxtion");
        final File resDir = GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getResourcesRootDirectory() != null ? GenerationContext.SINGLETON.getResourcesRootDirectory() : new File(baseDir, "src/main/resources");
        loadServices.forEach(new Consumer<ClassProcessor>(){

            @Override
            public void accept(ClassProcessor t) {
                try {
                    t.outputDirectories(baseDir, outDir, resDir);
                    t.process(url);
                }
                catch (Exception e) {
                    LOGGER.warn("problem executing processor : '" + t + "'", (Throwable)e);
                }
            }
        });
    }

    public static DirectoryNames standardParamsHelper(AnnotationParameterValueList params, File rootDir, File generatedDir, File resourceDir) throws IOException {
        String outDir = generatedDir.getCanonicalPath();
        String resDir = resourceDir.getCanonicalPath();
        String pkgName = params.get("packageName").toString();
        if (params.get("outputDir") != null) {
            outDir = rootDir.getCanonicalPath() + "/" + params.get("outputDir").toString();
        }
        if (params.get("resourceDir") != null) {
            resDir = rootDir.getCanonicalPath() + "/" + params.get("resourceDir").toString();
        }
        if (params.get("cleanOutputDir") == null || ((Boolean)params.get("cleanOutputDir")).booleanValue()) {
            FileUtils.deleteDirectory((File)new File(outDir, pkgName.replace(".", "/")));
            FileUtils.deleteDirectory((File)new File(resDir, pkgName.replace(".", "/")));
        }
        return new DirectoryNames(outDir, resDir, pkgName);
    }

    public static class DirectoryNames {
        final String outDir;
        final String resDir;
        final String pkgName;

        public DirectoryNames(String outDir, String resDir, String pkgName) {
            this.outDir = outDir;
            this.resDir = resDir;
            this.pkgName = pkgName;
        }
    }
}

