/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.api.StaticEventProcessor;
import com.fluxtion.api.lifecycle.Lifecycle;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.SepCompiler;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Consumer;

public class InprocessSepCompiler {
    public static final String JAVA_TESTGEN_DIR = "target/generated-test-sources/fluxtion/";
    public static final String JAVA_GEN_DIR = "target/generated-sources/fluxtion/";
    public static final String JAVA_SRC_DIR = "src/main/java/";
    public static final String RESOURCE_TEST_DIR = "target/generated-test-sources/resources/";
    public static final String RESOURCE_DIR = "src/main/resources/";

    public static StaticEventProcessor sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, DirOptions dirOptions, InitOptions initOptions) throws InstantiationException, IllegalAccessException, Exception {
        String genDir = JAVA_GEN_DIR;
        String resDir = RESOURCE_DIR;
        switch (dirOptions) {
            case JAVA_SRCDIR_OUTPUT: {
                genDir = JAVA_SRC_DIR;
                resDir = RESOURCE_DIR;
                break;
            }
            case TEST_DIR_OUTPUT: {
                genDir = JAVA_TESTGEN_DIR;
                resDir = RESOURCE_TEST_DIR;
            }
        }
        boolean init = initOptions == InitOptions.INIT;
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, genDir, resDir, init);
    }

    public static StaticEventProcessor sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR, true);
    }

    public static StaticEventProcessor sepTestInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR, true);
    }

    public static StaticEventProcessor sepInstanceNoInit(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR, false);
    }

    public static StaticEventProcessor sepTestInstanceNoInit(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR, false);
    }

    public static StaticEventProcessor build(String name, String pkg, Consumer<SEPConfig> builder) throws Exception {
        String dir = System.getProperty("fluxtion.cacheDirectory");
        if (dir != null) {
            System.setProperty("fluxtion.build.outputdirectory", dir + "/classes/");
            return InprocessSepCompiler.sepInstance(builder, pkg, name, dir + "/source/", dir + "/resources/", true);
        }
        return InprocessSepCompiler.sepInstance(builder, pkg, name);
    }

    public static StaticEventProcessor reuseOrBuild(String name, String pkg, Consumer<SEPConfig> builder) throws Exception {
        StaticEventProcessor processor;
        String dir = System.getProperty("fluxtion.cacheDirectory");
        try {
            Class<StaticEventProcessor> processorClass;
            if (dir != null) {
                URL classesDir = new File(dir + "/classes/").toURI().toURL();
                URL reosurcesDir = new File(dir + "/resources/").toURI().toURL();
                URLClassLoader ucl = new URLClassLoader(new URL[]{classesDir, reosurcesDir});
                processorClass = Class.forName(pkg + "." + name, true, ucl).asSubclass(StaticEventProcessor.class);
            } else {
                processorClass = Class.forName(pkg + "." + name).asSubclass(StaticEventProcessor.class);
            }
            processor = processorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (processor instanceof Lifecycle) {
                Lifecycle lifecycle = (Lifecycle)processor;
                lifecycle.init();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            if (dir != null) {
                System.setProperty("fluxtion.build.outputdirectory", dir + "/classes/");
                processor = InprocessSepCompiler.sepInstance(builder, pkg, name, dir + "/source/", dir + "/resources/", true);
            }
            processor = InprocessSepCompiler.sepInstance(builder, pkg, name);
        }
        return processor;
    }

    public static StaticEventProcessor sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, String srcGenDir, String resGenDir, boolean initialise) throws InstantiationException, IllegalAccessException, Exception {
        Class<StaticEventProcessor> sepClass = InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, srcGenDir, resGenDir);
        StaticEventProcessor sep = sepClass.newInstance();
        if (initialise && sep instanceof Lifecycle) {
            ((Lifecycle)sep).init();
        }
        return sep;
    }

    public static Class<StaticEventProcessor> compileSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws IOException, InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR);
    }

    public static Class<StaticEventProcessor> CompileTestSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws IOException, InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR);
    }

    private static Class<StaticEventProcessor> compileSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, String srcGenDir, String resGenDir) throws IOException, InstantiationException, IllegalAccessException, Exception {
        SepCompiler compiler = new SepCompiler();
        SepCompilerConfig compilerCfg = InprocessSepCompiler.getSepCompileConfig(pckg, sepName, srcGenDir, resGenDir);
        return compiler.compile(compilerCfg, new InProcessSepConfig(cfgBuilder));
    }

    public static SepCompilerConfig getSepCompileConfig(String packageName, String className, String srcGenDir, String resGenDir) throws IOException {
        File outputDir = new File(srcGenDir);
        File resourcesDir = new File(resGenDir);
        GenerationContext.setupStaticContext((String)packageName, (String)className, (File)outputDir, (File)resourcesDir);
        SepCompilerConfig cfg = new SepCompilerConfig();
        cfg.setOutputDirectory(GenerationContext.SINGLETON.getSourceRootDirectory().getCanonicalPath());
        cfg.setResourcesOutputDirectory(GenerationContext.SINGLETON.getResourcesRootDirectory().getCanonicalPath());
        cfg.setPackageName(packageName);
        cfg.setClassName(className);
        cfg.setCachedCompiler(GenerationContext.SINGLETON.getJavaCompiler());
        cfg.setConfigClass(InProcessSepConfig.class.getCanonicalName());
        return cfg;
    }

    public static enum DirOptions {
        TEST_DIR_OUTPUT,
        JAVA_GENDIR_OUTPUT,
        JAVA_SRCDIR_OUTPUT;

    }

    public static enum InitOptions {
        INIT,
        NO_INIT;

    }

    private static class InProcessSepConfig
    extends SEPConfig {
        private final Consumer<SEPConfig> cfg;

        public InProcessSepConfig(Consumer<SEPConfig> cfg) {
            this.cfg = cfg;
        }

        public void buildConfig() {
            this.cfg.accept(this);
        }
    }
}

