/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.api.FilteredEventHandler;
import com.fluxtion.api.annotations.Config;
import com.fluxtion.api.annotations.ConfigVariable;
import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Inject;
import com.fluxtion.api.annotations.NoEventReference;
import com.fluxtion.api.annotations.PushReference;
import com.fluxtion.api.audit.Auditor;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.generation.NodeNameProducer;
import com.fluxtion.builder.node.DeclarativeNodeConiguration;
import com.fluxtion.builder.node.NodeFactory;
import com.fluxtion.builder.node.NodeRegistry;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.exporter.JgraphGraphMLExporter;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.NamingStrategy;
import com.fluxtion.generator.util.NaturalOrderComparator;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.googlecode.gentyref.GenericTypeReflector;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import net.vidageek.mirror.dsl.AccessorsController;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.reflect.dsl.ReflectionHandler;
import org.jgrapht.DirectedGraph;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TopologicallySortedDependecyGraph
implements NodeRegistry {
    private Map<String, Auditor> registrationListenerMap;
    private final Logger LOGGER = LoggerFactory.getLogger(TopologicallySortedDependecyGraph.class);
    private BiMap<Object, String> inst2Name;
    private final BiMap<Object, String> inst2NameTemp;
    private final SimpleDirectedGraph<Object, DefaultEdge> graph = new SimpleDirectedGraph(DefaultEdge.class);
    private final DirectedGraph<Object, DefaultEdge> eventGraph = new SimpleDirectedGraph(DefaultEdge.class);
    private final List<Object> topologicalHandlers = new ArrayList<Object>();
    private boolean processed = false;
    private int count;
    private final DeclarativeNodeConiguration declarativeNodeConiguration;
    private final HashMap<Class, CbMethodHandle> class2FactoryMethod;
    private final List publicNodeList;
    private final GenerationContext generationContext;
    private NodeNameProducer nameStrategy;
    private final SEPConfig config;

    public TopologicallySortedDependecyGraph(Object ... obj) {
        this(Arrays.asList(obj));
    }

    public TopologicallySortedDependecyGraph(List nodes) {
        this(nodes, null, null, null, null, null);
    }

    public TopologicallySortedDependecyGraph(Map<Object, String> publicNodes) {
        this(null, publicNodes, null, null, null, null);
    }

    public TopologicallySortedDependecyGraph(DeclarativeNodeConiguration declarativeNodeConiguration) {
        this(null, null, declarativeNodeConiguration, null, null, null);
    }

    public TopologicallySortedDependecyGraph(List nodes, Map<Object, String> publicNodes) {
        this(nodes, publicNodes, null, null, null, null);
    }

    public TopologicallySortedDependecyGraph(SEPConfig config) {
        this(config.nodeList, config.publicNodes, config.declarativeConfig, GenerationContext.SINGLETON, config.auditorMap, config);
    }

    public TopologicallySortedDependecyGraph(List nodes, Map<Object, String> publicNodes, DeclarativeNodeConiguration declarativeNodeConiguration, GenerationContext context, Map<String, Auditor> auditorMap, SEPConfig config) {
        this.config = config;
        this.nameStrategy = new NamingStrategy();
        this.inst2Name = HashBiMap.create();
        this.inst2NameTemp = HashBiMap.create();
        this.class2FactoryMethod = new HashMap();
        if (nodes == null) {
            nodes = Collections.EMPTY_LIST;
        }
        for (Object node : nodes) {
            String name = this.nameNode(node);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("adding:'" + node + "' name:'" + this.nameNode(node) + "'");
            }
            this.inst2Name.put(node, (Object)this.nameNode(node));
        }
        nodes = Collections.EMPTY_LIST;
        if (context != null && context.getNodeList() != null) {
            nodes = context.getNodeList();
        }
        this.addNodeList(nodes);
        this.publicNodeList = new ArrayList();
        if (context != null && context.getPublicNodes() != null) {
            this.inst2Name.putAll(context.getPublicNodes());
            this.publicNodeList.addAll(context.getPublicNodes().keySet());
        }
        if (publicNodes != null) {
            this.inst2Name.putAll(publicNodes);
            this.publicNodeList.addAll(publicNodes.keySet());
        }
        if (auditorMap == null) {
            auditorMap = new HashMap<String, Auditor>();
        }
        this.registrationListenerMap = auditorMap;
        this.registrationListenerMap.entrySet().stream().forEach(t -> {
            this.inst2Name.put(t.getValue(), (Object)((String)t.getKey()));
            this.publicNodeList.add(t.getValue());
        });
        this.declarativeNodeConiguration = declarativeNodeConiguration;
        this.generationContext = context;
    }

    private void addNodeList(List nodes) {
        if (nodes != null) {
            for (Object node : nodes) {
                if (this.inst2Name.containsKey(node)) continue;
                String name = this.nameNode(node);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("from context adding:'" + node + "' name:'" + name + "'");
                }
                this.inst2Name.put(node, (Object)name);
            }
        }
    }

    public String variableName(Object node) {
        String name = (String)this.inst2Name.get(node);
        return name;
    }

    public Map<Object, String> getInstanceMap() {
        return Collections.unmodifiableMap(this.inst2Name);
    }

    public List<Object> getSortedDependents() throws Exception {
        this.generateDependencyTree();
        return Collections.unmodifiableList(this.topologicalHandlers);
    }

    public Map<String, Auditor> getRegistrationListenerMap() {
        if (this.registrationListenerMap == null) {
            this.registrationListenerMap = new HashMap<String, Auditor>();
        }
        return Collections.unmodifiableMap(this.registrationListenerMap);
    }

    public List<Object> getSortedDependents(Object obj) throws Exception {
        this.generateDependencyTree();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        if (this.graph.containsVertex(obj)) {
            DepthFirstIterator iter = new DepthFirstIterator(this.graph, obj);
            while (iter.hasNext()) {
                int idx = this.topologicalHandlers.indexOf(iter.next());
                lst.add(idx);
            }
        }
        Collections.sort(lst);
        ArrayList<Object> cbList = new ArrayList<Object>();
        for (Integer idx : lst) {
            cbList.add(this.topologicalHandlers.get(idx));
        }
        return cbList;
    }

    public List<Object> getEventSortedDependents(Object obj) throws Exception {
        this.generateDependencyTree();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        if (this.eventGraph.containsVertex(obj)) {
            DepthFirstIterator iter = new DepthFirstIterator(this.eventGraph, obj);
            while (iter.hasNext()) {
                int idx = this.topologicalHandlers.indexOf(iter.next());
                lst.add(idx);
            }
        }
        Collections.sort(lst);
        ArrayList<Object> cbList = new ArrayList<Object>();
        for (Integer idx : lst) {
            cbList.add(this.topologicalHandlers.get(idx));
        }
        return cbList;
    }

    public List<?> getDirectChildren(Object parent) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.graph.containsVertex(parent)) {
            Set outgoingEdgeSet = this.graph.outgoingEdgesOf(parent);
            for (DefaultEdge childEdge : outgoingEdgeSet) {
                lst.add(this.graph.getEdgeTarget((Object)childEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectChildrenListeningForEvent(Object parent) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.eventGraph.containsVertex(parent)) {
            Set outgoingEdgeSet = this.eventGraph.outgoingEdgesOf(parent);
            for (DefaultEdge childEdge : outgoingEdgeSet) {
                lst.add(this.eventGraph.getEdgeTarget((Object)childEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectParents(Object child) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.graph.containsVertex(child)) {
            Set outgoingEdgeSet = this.graph.incomingEdgesOf(child);
            for (DefaultEdge parentEdge : outgoingEdgeSet) {
                lst.add(this.graph.getEdgeSource((Object)parentEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectParentsListeningForEvent(Object child) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.eventGraph.containsVertex(child)) {
            Set outgoingEdgeSet = this.eventGraph.incomingEdgesOf(child);
            for (DefaultEdge parentEdge : outgoingEdgeSet) {
                lst.add(this.eventGraph.getEdgeSource((Object)parentEdge));
            }
        }
        return lst;
    }

    public <T> T registerPublicNode(T node, String variableName) {
        return this.registerNode(node, variableName, true);
    }

    public <T extends Auditor> T registerAuditor(T node, String auditorName) {
        T registerNode = this.registerNode(node, auditorName, true);
        this.registrationListenerMap.put(auditorName, registerNode);
        return registerNode;
    }

    public <T> T registerNode(T node, String variableName, boolean isPublic) {
        if (variableName == null && this.inst2Name.containsKey(node)) {
            return (T)this.inst2Name.get(node);
        }
        if (variableName == null) {
            variableName = this.nameNode(node);
        }
        if (this.inst2Name.containsValue((Object)variableName) && !variableName.equals(this.inst2Name.get(node))) {
            throw new RuntimeException("Variable name:'" + variableName + "' already used for another node:'" + this.inst2Name.inverse().get((Object)variableName) + "', cannot add node:" + node);
        }
        if (this.inst2Name.containsKey(node) && !variableName.equals(this.inst2Name.get(node))) {
            throw new RuntimeException("Cannot remap node:" + node + " to new variable name:'" + variableName + "'  existing variable name:'" + (String)this.inst2Name.get(node) + "'");
        }
        this.inst2Name.put(node, (Object)variableName);
        if (isPublic) {
            this.publicNodeList.add(node);
        }
        return node;
    }

    public <T> T registerNode(T node, String variableName) {
        return this.registerNode(node, variableName, false);
    }

    public <T> T findOrCreatePublicNode(Class<T> clazz, Map config, String variableName) {
        return this.findOrCreateNode(clazz, config, variableName, true);
    }

    public <T> T findOrCreateNode(Class<T> clazz, Map config, String variableName) {
        return this.findOrCreateNode(clazz, config, variableName, false);
    }

    public <T> T findOrCreateNode(Class<T> clazz, Map config, String variableName, boolean isPublic) {
        return this.findOrCreateNode(clazz, config, variableName, isPublic, false);
    }

    private <T> T findOrCreateNode(Class<T> clazz, Map config, String variableName, boolean isPublic, boolean useTempMap) {
        try {
            String name;
            CbMethodHandle handle = this.class2FactoryMethod.get(clazz);
            Object newNode = null;
            if (handle != null) {
                newNode = handle.method.invoke(handle.instance, config, this);
                if (newNode == null) {
                    return null;
                }
            } else {
                try {
                    newNode = clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.LOGGER.debug("missing default construtor - attempting construction bypass");
                    Mirror constructor = new Mirror();
                    newNode = constructor.on(clazz).invoke().constructor().bypasser();
                }
                AccessorsController mirror = new Mirror().on(newNode);
                ReflectionHandler reflect = new Mirror().on(clazz).reflect();
                Set entrySet = config.entrySet();
                ReflectionUtils.getFields(clazz, (Predicate[])new Predicate[0]).stream().forEach(f -> f.setAccessible(true));
                entrySet.stream().filter(map -> reflect.field((String)map.getKey()).getType() != String.class && map.getValue().getClass() != String.class).forEach(map -> mirror.set().field((String)map.getKey()).withValue(map.getValue()));
                entrySet.stream().filter(map -> reflect.field((String)map.getKey()).getType() == String.class && map.getValue().getClass() == String.class).forEach(map -> mirror.set().field((String)map.getKey()).withValue(map.getValue()));
                entrySet.stream().filter(map -> reflect.field((String)map.getKey()).getType() != String.class && map.getValue().getClass() == String.class).forEach(map -> {
                    Class<?> clazz1 = mirror.get().field((String)map.getKey()).getClass();
                    switch (clazz1.getSimpleName()) {
                        case "Integer": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Integer((String)map.getValue()));
                            break;
                        }
                        case "Double": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Double((String)map.getValue()));
                            break;
                        }
                        case "Float": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Float((String)map.getValue()));
                            break;
                        }
                        case "Short": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Short((String)map.getValue()));
                            break;
                        }
                        case "Byte": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Byte((String)map.getValue()));
                            break;
                        }
                        case "Long": {
                            mirror.set().field((String)map.getKey()).withValue((Object)new Long((String)map.getValue()));
                            break;
                        }
                        case "Character": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Character.valueOf(((String)map.getValue()).charAt(0)));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Type not supported in default factory ");
                        }
                    }
                });
            }
            if (!this.inst2Name.containsKey(newNode)) {
                name = this.nameNode(newNode);
                if (useTempMap) {
                    this.inst2NameTemp.put(newNode, (Object)(variableName == null ? name : variableName));
                } else {
                    this.inst2Name.put(newNode, (Object)(variableName == null ? name : variableName));
                }
            } else {
                name = (String)this.inst2Name.get(newNode);
                newNode = this.inst2Name.inverse().get((Object)name);
            }
            if (handle != null) {
                NodeFactory factory = (NodeFactory)handle.instance;
                if (isPublic) {
                    this.publicNodeList.add(newNode);
                }
                factory.postInstanceRegistration(config, (NodeRegistry)this, newNode);
            }
            return (T)newNode;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            this.LOGGER.error("error creating node with factory", (Throwable)ex);
            throw new RuntimeException("error creating node with factory", ex);
        }
    }

    public synchronized void generateDependencyTree() throws Exception {
        Object object;
        if (this.processed) {
            return;
        }
        if (this.declarativeNodeConiguration != null) {
            for (Class clazz : this.declarativeNodeConiguration.factoryClassSet) {
                NodeFactory factory = (NodeFactory)clazz.newInstance();
                this.registerNodeFactory(factory);
            }
            for (NodeFactory nodeFactory : this.declarativeNodeConiguration.factorySet) {
                this.registerNodeFactory(nodeFactory);
            }
            for (Map.Entry entry : this.declarativeNodeConiguration.rootNodeMappings.entrySet()) {
                Object newNode = this.findOrCreateNode((Class)entry.getKey(), this.declarativeNodeConiguration.config, (String)entry.getValue());
                this.publicNodeList.add(newNode);
            }
        }
        this.addNodesFromContext();
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            object = entry.getKey();
            this.walkDependencies(object);
        }
        this.inst2Name.putAll(this.inst2NameTemp);
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            object = entry.getKey();
            this.walkDependencies(object);
        }
        PriorityQueue pq = new PriorityQueue(Math.max(1, this.inst2Name.size()), new NaturalOrderComparator(Collections.unmodifiableMap(this.inst2Name)));
        TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator(this.graph, pq);
        while (topologicalOrderIterator.hasNext()) {
            Object value = topologicalOrderIterator.next();
            this.topologicalHandlers.add(value);
        }
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            Object node = entry.getKey();
            if (this.topologicalHandlers.contains(node)) continue;
            this.topologicalHandlers.add(node);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("GRAPH:" + this.graph);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("SORTED LIST:" + this.topologicalHandlers);
        }
        this.processed = true;
    }

    private void addNodesFromContext() {
        if (this.generationContext != null) {
            this.addNodeList(this.generationContext.getNodeList());
        }
    }

    private void registerNodeFactory(NodeFactory obj) throws NoSuchMethodException, SecurityException {
        Class<?> clazz = obj.getClass();
        Method createMethod = clazz.getMethod("createNode", Map.class, NodeRegistry.class);
        ParameterizedType paramType = (ParameterizedType)GenericTypeReflector.getExactSuperType(clazz, NodeFactory.class);
        Class targetClass = (Class)paramType.getActualTypeArguments()[0];
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Registered factory:" + clazz.getCanonicalName() + " building:" + targetClass);
        }
        this.class2FactoryMethod.put(targetClass, new CbMethodHandle(createMethod, obj, "node_factory_" + targetClass.getName()));
        obj.preSepGeneration(this.generationContext);
    }

    private void walkDependenciesForEventHandling(Object object) throws IllegalArgumentException, IllegalAccessException {
        Set s = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[0]);
        Field[] fields = new Field[s.size()];
        for (Field field : fields = s.toArray(fields)) {
            field.setAccessible(true);
            Object refField = field.get(object);
            String refName = (String)this.inst2Name.get(refField);
            if (field.getAnnotation(NoEventReference.class) != null) continue;
            if (field.getType().isArray()) {
                Object array = field.get(object);
                if (array == null) continue;
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    refField = Array.get(array, i);
                    if (!this.inst2Name.containsKey(refField)) continue;
                    this.eventGraph.addVertex(object);
                    this.eventGraph.addVertex(refField);
                    this.eventGraph.addEdge(refField, object);
                    this.walkDependenciesForEventHandling(refField);
                }
                continue;
            }
            if (List.class.isAssignableFrom(field.getType())) {
                Collection list = (Collection)field.get(object);
                if (list == null) continue;
                for (Object parent : list) {
                    if (!this.inst2Name.containsKey(parent)) continue;
                    this.eventGraph.addVertex(object);
                    this.eventGraph.addVertex(parent);
                    this.eventGraph.addEdge(parent, object);
                    this.walkDependenciesForEventHandling(parent);
                }
                continue;
            }
            if (refName == null) continue;
            this.eventGraph.addVertex(object);
            this.eventGraph.addVertex(refField);
            if (field.getAnnotation(PushReference.class) != null) {
                this.eventGraph.addEdge(object, refField);
                continue;
            }
            this.eventGraph.addEdge(refField, object);
            this.walkDependenciesForEventHandling(refField);
        }
    }

    private void walkDependencies(Object object) throws IllegalArgumentException, IllegalAccessException {
        this.walkDependenciesForEventHandling(object);
        Set s = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[0]);
        Field[] fields = new Field[s.size()];
        for (Field field : fields = s.toArray(fields)) {
            Config[] configArray;
            Inject injecting;
            field.setAccessible(true);
            Object refField = field.get(object);
            String refName = (String)this.inst2Name.get(refField);
            if (field.getType().isArray()) {
                Object array = field.get(object);
                if (array == null) continue;
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    refField = Array.get(array, i);
                    if (this.inst2Name.containsKey(refField)) {
                        this.graph.addVertex(object);
                        this.graph.addVertex(refField);
                        this.graph.addEdge(refField, object);
                        this.walkDependencies(refField);
                        continue;
                    }
                    if (!this.LOGGER.isDebugEnabled()) continue;
                    this.LOGGER.debug("mismatch for:" + refField);
                    for (Object obj : this.inst2Name.keySet()) {
                        this.LOGGER.debug(obj + "==" + refField + " " + (obj == refField));
                        if (obj == refField) continue;
                        this.LOGGER.debug("obj.equals(refField)" + obj.equals(refField));
                        this.LOGGER.debug("match value from map refField:" + (String)this.inst2Name.get(refField));
                        this.LOGGER.debug("match value from map obj:" + (String)this.inst2Name.get(obj));
                    }
                }
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                Collection list = (Collection)field.get(object);
                if (list == null) continue;
                for (Object parent : list) {
                    if (!this.inst2Name.containsKey(parent)) continue;
                    this.graph.addVertex(object);
                    this.graph.addVertex(parent);
                    this.graph.addEdge(parent, object);
                    this.walkDependencies(parent);
                }
            } else if (refName != null) {
                this.graph.addVertex(object);
                this.graph.addVertex(refField);
                if (field.getAnnotation(PushReference.class) != null) {
                    this.graph.addEdge(object, refField);
                } else {
                    this.graph.addEdge(refField, object);
                    this.walkDependencies(refField);
                }
            }
            if (!((injecting = field.getAnnotation(Inject.class)) != null & refName == null & field.get(object) == null)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Object> overrideMap = new HashMap<String, Object>();
            ConfigVariable[] overrideConfigs = (ConfigVariable[])field.getAnnotationsByType(ConfigVariable.class);
            for (ConfigVariable overrideConfig : overrideConfigs) {
                String fieldFilter = overrideConfig.field();
                String key = overrideConfig.key();
                Object value = new Mirror().on(object).get().field(fieldFilter);
                overrideMap.put(key, value);
            }
            for (Config config : configArray = (Config[])field.getAnnotationsByType(Config.class)) {
                map.put(config.key(), config.value());
            }
            Set entrySet = overrideMap.entrySet();
            entrySet.stream().forEach(overrideEntry -> map.put((String)overrideEntry.getKey(), (String)overrideEntry.getValue()));
            BiMap<Object, String> oldMap = this.inst2Name;
            this.inst2Name = this.inst2NameTemp;
            Object newNode = this.findOrCreateNode(field.getType(), map, null, false, true);
            this.inst2Name = oldMap;
            this.addNodesFromContext();
            field.set(object, newNode);
            this.walkDependencies(newNode);
        }
    }

    public boolean isPublicNode(Object node) {
        return this.publicNodeList.contains(node);
    }

    public SEPConfig getConfig() {
        return this.config;
    }

    void sortNodeList(List<CbMethodHandle> dispatchMethods) {
        Collections.sort(dispatchMethods, (handle0, handle1) -> {
            if (handle0.instance == handle1.instance) {
                if (handle0.isEventHandler && !handle1.isEventHandler) {
                    return -1;
                }
                if (!handle0.isEventHandler && handle1.isEventHandler) {
                    return 1;
                }
                return handle0.method.getName().compareTo(handle1.method.getName());
            }
            return this.topologicalHandlers.indexOf(handle0.instance) - this.topologicalHandlers.indexOf(handle1.instance);
        });
    }

    public void exportAsGraphMl(Writer writer, boolean addEvents) throws SAXException, TransformerConfigurationException {
        VertexNameProvider np = new VertexNameProvider(){

            public String getVertexName(Object vertex) {
                String name = TopologicallySortedDependecyGraph.this.variableName(vertex);
                if (name == null) {
                    name = ((Class)vertex).getSimpleName();
                }
                return name;
            }
        };
        JgraphGraphMLExporter mlExporter = new JgraphGraphMLExporter(np, np, new IntegerEdgeNameProvider(), new IntegerEdgeNameProvider());
        SimpleDirectedGraph exportGraph = (SimpleDirectedGraph)this.graph.clone();
        if (addEvents) {
            this.graph.vertexSet().stream().forEach(t -> {
                FilteredEventHandler eh;
                Class eventClass;
                Method[] methodList;
                for (Method method : methodList = t.getClass().getMethods()) {
                    if (method.getAnnotation(EventHandler.class) == null) continue;
                    Class<?> eventTypeClass = method.getParameterTypes()[0];
                    exportGraph.addVertex(eventTypeClass);
                    exportGraph.addEdge(eventTypeClass, t);
                }
                if (t instanceof FilteredEventHandler && (eventClass = (eh = (FilteredEventHandler)t).eventClass()) != null) {
                    exportGraph.addVertex((Object)eventClass);
                    exportGraph.addEdge((Object)eventClass, t);
                }
            });
        }
        mlExporter.export(writer, exportGraph);
    }

    private String nameNode(Object node) {
        return this.nameStrategy.mappedNodeName(node);
    }
}

