/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.api.event.FilteredHandlerInvoker;
import com.fluxtion.builder.generation.FilterDescription;
import com.fluxtion.generator.model.InvokerFilterTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface JavaGenHelper {
    public static final StringBuilder builder = new StringBuilder(1000000);

    public static String generateMapDisaptch(ArrayList<InvokerFilterTarget> filteredInvokerList, List<Class<?>> importClassList) {
        builder.delete(0, builder.length());
        if (filteredInvokerList == null || filteredInvokerList.isEmpty()) {
            return "";
        }
        importClassList.add(FilteredHandlerInvoker.class);
        builder.append("//int filter maps\n");
        filteredInvokerList.stream().filter(i -> i.filterDescription.isIntFilter).map(invoker -> invoker.intMapName).collect(Collectors.toSet()).stream().forEach(methodName -> builder.append("\tprivate final Int2ObjectOpenHashMap<FilteredHandlerInvoker> ").append((String)methodName).append(" = init").append((String)methodName).append("();\n\n"));
        builder.append("//String filter maps\n");
        filteredInvokerList.stream().filter(i -> !i.filterDescription.isIntFilter).map(invoker -> invoker.stringMapName).collect(Collectors.toSet()).stream().forEach(methodName -> builder.append("\tprivate final HashMap<String, FilteredHandlerInvoker> ").append((String)methodName).append(" = init").append((String)methodName).append("();\n\n"));
        HashSet<Class> setIntClasses = new HashSet<Class>();
        HashSet<Class> setStrClasses = new HashSet<Class>();
        for (InvokerFilterTarget invoker1 : filteredInvokerList) {
            Class e = invoker1.filterDescription.eventClass;
            if (invoker1.filterDescription.isIntFilter && !setIntClasses.contains(e)) {
                builder.append("\tprivate Int2ObjectOpenHashMap<FilteredHandlerInvoker> init" + invoker1.intMapName + "(){\n\t\tInt2ObjectOpenHashMap<FilteredHandlerInvoker> dispatchMap = new Int2ObjectOpenHashMap<>();\n");
                filteredInvokerList.stream().filter(i -> i.filterDescription.eventClass == e).filter(i -> i.filterDescription.isIntFilter).forEach(invoker -> builder.append("\t\tdispatchMap.put( " + invoker.filterDescription.value + ", new FilteredHandlerInvoker() {\n\n\t\t\t@Override\n\t\t\tpublic void invoke(Object event) {\n\t\t\t\t" + JavaGenHelper.generateFilteredDispatchMethodName(invoker.filterDescription) + "( (" + invoker.filterDescription.eventClass.getCanonicalName() + ")event);\n\t\t\t}\n\t\t});\t\t\n"));
                builder.append("\t\treturn dispatchMap;\n\t}\n\n");
                setIntClasses.add(e);
            }
            if (!invoker1.filterDescription.isIntFilter && !setStrClasses.contains(e)) {
                builder.append("\tprivate HashMap<String, FilteredHandlerInvoker> init" + invoker1.stringMapName + "(){\n\t\tHashMap<String, FilteredHandlerInvoker> dispatchMap = new HashMap<>();\n");
                filteredInvokerList.stream().filter(i -> i.filterDescription.eventClass == e).filter(i -> !i.filterDescription.isIntFilter).forEach(invoker -> builder.append("\t\tdispatchMap.put(\"" + invoker.filterDescription.stringValue + "\", new FilteredHandlerInvoker() {\n\n\t\t\t@Override\n\t\t\tpublic void invoke(Object event) {\n\t\t\t\t" + JavaGenHelper.generateFilteredDispatchMethodName(invoker.filterDescription) + "( (" + invoker.filterDescription.eventClass.getCanonicalName() + ")event);\n\t\t\t}\n\t\t});\t\t\n"));
                builder.append("\t\treturn dispatchMap;\n\t}\n\n");
                setStrClasses.add(e);
            }
            if (setStrClasses.size() <= 0) continue;
            importClassList.add(HashMap.class);
        }
        filteredInvokerList.stream().forEach(invoker -> builder.append("\tprivate void " + invoker.methodName + "(" + invoker.filterDescription.eventClass.getCanonicalName() + " typedEvent){\n\t\t//method body - invoke call tree\n\t\t" + invoker.methodBody + "\t}\n\n"));
        return builder.toString();
    }

    public static String generateFilteredDispatchMethodName(FilterDescription filter) {
        String filterName = filter.variableName;
        if (filterName == null) {
            filterName = (filter.isIntFilter ? Integer.valueOf(filter.value) : filter.stringValue) + "";
        }
        filterName = filter.isFiltered ? filterName : "NoFilter";
        String filterClass = "noFilterClass";
        if (filter.eventClass != null) {
            filterClass = filter.eventClass.getSimpleName();
        }
        return JavaGenHelper.getIdentifier("handle_" + filterClass + "_" + filterName);
    }

    public static String generateFilteredDispatchMap(Class clazz, boolean isInt) {
        FilterDescription filter = new FilterDescription(clazz, 0);
        if (!isInt) {
            filter = new FilterDescription(clazz, "");
        }
        return JavaGenHelper.generateFilteredDispatchMap(filter);
    }

    public static String generateFilteredDispatchMap(FilterDescription filter) {
        String type = filter.isIntFilter ? "Int" : "String";
        String filterClass = "noFilterClass";
        if (filter.eventClass != null) {
            filterClass = filter.eventClass.getSimpleName();
        }
        return JavaGenHelper.getIdentifier("dispatch" + type + "Map" + filterClass);
    }

    public static String getIdentifier(String str) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart((str = StringUtils.uncapitalize((String)str)).charAt(0))) {
            sb.append("_");
        }
        for (char c : str.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Class mapWrapperToPrimitive(Class clazz) {
        Class<Object> retClass = Void.TYPE;
        switch (clazz.getSimpleName()) {
            case "Integer": {
                retClass = Integer.TYPE;
                break;
            }
            case "Double": {
                retClass = Double.TYPE;
                break;
            }
            case "Float": {
                retClass = Float.TYPE;
                break;
            }
            case "Short": {
                retClass = Short.TYPE;
                break;
            }
            case "Byte": {
                retClass = Byte.TYPE;
                break;
            }
            case "Long": {
                retClass = Long.TYPE;
                break;
            }
            case "Character": {
                retClass = Character.TYPE;
            }
        }
        return retClass;
    }

    public static Class mapPrimitiveToWrapper(Class clazz) {
        Class<Object> retClass = Void.TYPE;
        switch (clazz.getSimpleName()) {
            case "int": {
                retClass = Integer.class;
                break;
            }
            case "double": {
                retClass = Double.class;
                break;
            }
            case "float": {
                retClass = Float.class;
                break;
            }
            case "short": {
                retClass = Short.class;
                break;
            }
            case "byte": {
                retClass = Byte.class;
                break;
            }
            case "long": {
                retClass = Long.class;
                break;
            }
            case "char": {
                retClass = Character.class;
            }
        }
        return retClass;
    }
}

