/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.util;

import com.fluxtion.builder.generation.GenerationContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.openhft.compiler.CachedCompiler;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatingCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(TemplatingCompiler.class);

    public static <T> Class<T> generateAndCompile(T node, String templateFile, GenerationContext generationConfig, Context ctx) throws IOException, MethodInvocationException, ParseErrorException, ResourceNotFoundException, ClassNotFoundException {
        String className = TemplatingCompiler.writeSourceFile(node, templateFile, generationConfig, ctx);
        String fqn = generationConfig.getPackageName() + "." + className;
        File file = new File(generationConfig.getPackageDirectory(), className + ".java");
        CachedCompiler javaCompiler = GenerationContext.SINGLETON.getJavaCompiler();
        String javaCode = GenerationContext.readText((String)file.getCanonicalPath());
        Class newClass = javaCompiler.loadFromJava(GenerationContext.SINGLETON.getClassLoader(), fqn, javaCode);
        return newClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeSourceFile(Object node, String templateFile, GenerationContext generationConfig, Context ctx) throws IOException, MethodInvocationException, ParseErrorException, ResourceNotFoundException {
        TemplatingCompiler.initVelocity();
        ctx.put(TemplateKeys.packageName.name(), (Object)generationConfig.getPackageName());
        String generatedClassName = (String)ctx.get(TemplateKeys.className.name());
        generationConfig.getProxyClassMap().put(node, generatedClassName);
        Template template = null;
        try {
            template = Velocity.getTemplate((String)templateFile);
        }
        catch (Exception e) {
            System.out.println("failed to load template, setting threadcontext class loader");
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(generationConfig.getClassLoader());
                template = Velocity.getTemplate((String)templateFile);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        File outFile = new File(generationConfig.getPackageDirectory(), generatedClassName + ".java");
        try (FileWriter templateWriter = new FileWriter(outFile);){
            template.merge(ctx, (Writer)templateWriter);
            templateWriter.flush();
        }
        try {
            while (!outFile.exists() || outFile.length() <= 1L) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ex) {
            LOG.info("interrupted while writing source file", (Throwable)ex);
        }
        return generatedClassName;
    }

    public static void deleteGeneratedClass(GenerationContext generationConfig, String generatedClassName) {
        File outFile = new File(generationConfig.getPackageDirectory(), generatedClassName + ".java");
        if (!outFile.delete()) {
            System.out.println("unable to delete file:" + outFile.getAbsolutePath());
        }
    }

    public static void initVelocity() throws RuntimeException {
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
    }

    public static enum TemplateKeys {
        packageName,
        className;

    }
}

