/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.server.plugin.rest.component;

import com.fluxtion.runtime.annotations.Start;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.server.dispatch.EventFlowManager;
import com.fluxtion.server.dispatch.EventFlowService;
import com.fluxtion.server.service.admin.AdminCommandRegistry;
import com.fluxtion.server.service.admin.AdminCommandRequest;
import io.javalin.Javalin;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavalinAdminCommandService
implements EventFlowService,
Lifecycle {
    @Generated
    private static final Logger log = LogManager.getLogger(JavalinAdminCommandService.class);
    private Javalin javalin;
    private EventFlowManager eventFlowManager;
    private AdminCommandRegistry adminCommandRegistry;
    private int listenPort = 8080;

    public void setEventFlowManager(EventFlowManager eventFlowManager, String serviceName) {
        log.info("set eventFlowManager name:'{}' for Javalin REST", (Object)serviceName);
        this.eventFlowManager = eventFlowManager;
    }

    @ServiceRegistered
    public void adminRegistry(AdminCommandRegistry adminCommandRegistry, String name) {
        log.info("Admin registry: '{}' name: '{}'", (Object)adminCommandRegistry, (Object)name);
        this.adminCommandRegistry = adminCommandRegistry;
    }

    public void init() {
        log.info("init Javalin REST service listening on port {}", (Object)this.listenPort);
        this.javalin = ((Javalin)Javalin.create().post("/admin", ctx -> {
            AdminCommandRequest adminCommandRequest = (AdminCommandRequest)ctx.bodyAsClass(AdminCommandRequest.class);
            adminCommandRequest.setOutput(out -> ctx.json((Object)new Message(out.toString())));
            adminCommandRequest.setErrOutput(out -> ctx.json((Object)new Message("Failure - " + String.valueOf(out))));
            log.info("adminCommandRequest: {}", (Object)adminCommandRequest);
            if (this.adminCommandRegistry != null) {
                this.adminCommandRegistry.processAdminCommandRequest(adminCommandRequest);
            }
        })).start(this.listenPort);
    }

    @Start
    public void start() {
        log.info("starting Javalin REST service");
    }

    public void tearDown() {
        log.info("tear down Javalin REST service");
        this.javalin.stop();
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public static class Message {
        private String message;

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JavalinAdminCommandService.Message(message=" + this.getMessage() + ")";
        }

        @Generated
        public Message(String message) {
            this.message = message;
        }

        @Generated
        public Message() {
        }
    }

    public static class AdminCommand {
        private String command;
        private String[] args = new String[0];

        @Generated
        public AdminCommand() {
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public String[] getArgs() {
            return this.args;
        }

        @Generated
        public void setCommand(String command) {
            this.command = command;
        }

        @Generated
        public void setArgs(String[] args) {
            this.args = args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdminCommand)) {
                return false;
            }
            AdminCommand other = (AdminCommand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            return Arrays.deepEquals(this.getArgs(), other.getArgs());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AdminCommand;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            return result;
        }

        @Generated
        public String toString() {
            return "JavalinAdminCommandService.AdminCommand(command=" + this.getCommand() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
        }
    }
}

