/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.jsch;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.function.ConsumerWithException;
import com.foilen.smalltools.jsch.SshLogin;
import com.foilen.smalltools.shell.ExecResultInFiles;
import com.foilen.smalltools.shell.ExecResultInMemory;
import com.foilen.smalltools.shell.ExecResultOnlyExitCode;
import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.StreamsTools;
import com.foilen.smalltools.tools.ThreadTools;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class JSchTools
extends AbstractBasics {
    private static final Logger logger = LoggerFactory.getLogger(JSchTools.class);
    private static final Set<PosixFilePermission> TMP_FILES_PERMS = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    private JSch jSch;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLogin(SshLogin sshLogin) {
        JSch jSch = new JSch();
        Session session = null;
        Object channel = null;
        try {
            logger.info("Trying to log on {} with user {}", (Object)sshLogin.getHostname(), (Object)sshLogin.getUsername());
            sshLogin.configure(jSch);
            session = jSch.getSession(sshLogin.getUsername(), sshLogin.getHostname(), sshLogin.getPort());
            sshLogin.configure(session);
            session.connect();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Could not connect", (Throwable)e);
        }
        finally {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
        return false;
    }

    public <C extends Channel> void createAndUseChannel(String channelType, Class<C> channelClass, Consumer<C> configureChannel, ConsumerWithException<C, Exception> consumer) {
        if (this.session == null || !this.session.isConnected()) {
            throw new SmallToolsException("Cannot open " + channelType + " channel because it is not connected");
        }
        Channel channel = null;
        try {
            channel = this.session.openChannel(channelType);
            configureChannel.accept(channel);
            channel.connect();
            consumer.accept((Object)channel);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem while executing " + channelType, (Throwable)e);
        }
        finally {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
        }
    }

    public void createAndUseSftpChannel(ConsumerWithException<ChannelSftp, Exception> consumer) {
        this.createAndUseChannel("sftp", ChannelSftp.class, channel -> {}, consumer);
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            logger.info("Disconnecting");
            this.session.disconnect();
        } else {
            logger.info("Already not connected");
        }
    }

    private int execute(String command, OutputStream out, OutputStream err) {
        AtomicInteger exitCode = new AtomicInteger(-1);
        this.createAndUseChannel("exec", ChannelExec.class, channel -> {
            channel.setCommand(command);
            channel.setInputStream(null);
            channel.setErrStream(err);
        }, channel -> {
            StreamsTools.flowStream((InputStream)channel.getInputStream(), (OutputStream)out);
            out.close();
            err.close();
            while (!channel.isClosed()) {
                ThreadTools.sleep((long)100L);
            }
            exitCode.set(channel.getExitStatus());
        });
        return exitCode.get();
    }

    public ExecResultInFiles executeInFile(String command) {
        try {
            File out = File.createTempFile("out", ".txt");
            File err = File.createTempFile("err", ".txt");
            FileTools.changePermissions((File)out, (boolean)false, TMP_FILES_PERMS);
            FileTools.changePermissions((File)err, (boolean)false, TMP_FILES_PERMS);
            logger.debug("Storing stdout in {}", (Object)out.getAbsolutePath());
            logger.debug("Storing stderr in {}", (Object)err.getAbsolutePath());
            int exitCode = this.execute(command, new FileOutputStream(out), new FileOutputStream(err));
            return new ExecResultInFiles(out, err, exitCode);
        }
        catch (SmallToolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem using temporary files", (Throwable)e);
        }
    }

    public ExecResultOnlyExitCode executeInLogger(String command) {
        OutputStream out = StreamsTools.createLoggerOutputStream((Logger)logger, (Level)Level.INFO);
        OutputStream err = StreamsTools.createLoggerOutputStream((Logger)logger, (Level)Level.ERROR);
        int exitCode = this.execute(command, out, err);
        return new ExecResultOnlyExitCode(exitCode);
    }

    public ExecResultInMemory executeInMemory(String command) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        int exitCode = this.execute(command, out, err);
        return new ExecResultInMemory(out, err, exitCode);
    }

    public ExecResultOnlyExitCode executeOutputStreams(String command, OutputStream out, OutputStream err) {
        int exitCode = this.execute(command, out, err);
        return new ExecResultOnlyExitCode(exitCode);
    }

    public JSchTools login(SshLogin sshLogin) {
        if (this.session != null && this.session.isConnected()) {
            logger.info("Disconnecting previous connection");
            this.session.disconnect();
        }
        try {
            logger.info("Log on {} with user {}", (Object)sshLogin.getHostname(), (Object)sshLogin.getUsername());
            this.jSch = new JSch();
            sshLogin.configure(this.jSch);
            this.session = this.jSch.getSession(sshLogin.getUsername(), sshLogin.getHostname(), sshLogin.getPort());
            sshLogin.configure(this.session);
            this.session.connect();
        }
        catch (Exception e) {
            this.session = null;
            throw new SmallToolsException("Could not connect", (Throwable)e);
        }
        return this;
    }
}

