/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.jsch;

import com.foilen.smalltools.JavaEnvironmentValues;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.jsch.AutoApproveUserinfo;
import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.FileTools;
import com.google.common.base.Strings;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class SshLogin
extends AbstractBasics {
    private String hostname;
    private String username;
    private int port = 22;
    private boolean ignoreHostCheck = false;
    private String knownHostsFile;
    private boolean autoApproveHostKey;
    private String password;
    private Set<String> privateKeyFile = new HashSet<String>();
    private List<Consumer<JSch>> configureJschHooks = new ArrayList<Consumer<JSch>>();
    private List<Consumer<Session>> configureSessionHooks = new ArrayList<Consumer<Session>>();

    public SshLogin(String hostname, String username) {
        this.hostname = hostname;
        this.username = username;
        String possibleKnownHostsFile = JavaEnvironmentValues.getHomeDirectory() + File.separator + ".ssh/known_hosts";
        if (FileTools.exists((String)possibleKnownHostsFile)) {
            this.logger.info("Known hosts file {} exists. Will use it per default", (Object)possibleKnownHostsFile);
            this.knownHostsFile = possibleKnownHostsFile;
        } else {
            this.logger.info("Known hosts file {} does not exist. You must set it if you want to use it", (Object)possibleKnownHostsFile);
        }
    }

    public SshLogin addConfigureJschHook(Consumer<JSch> hook) {
        this.configureJschHooks.add(hook);
        return this;
    }

    public SshLogin addConfigureSessionHook(Consumer<Session> hook) {
        this.configureSessionHooks.add(hook);
        return this;
    }

    public SshLogin autoApproveHostKey() {
        this.autoApproveHostKey = true;
        return this;
    }

    public void configure(JSch jSch) {
        if (!Strings.isNullOrEmpty((String)this.knownHostsFile)) {
            this.logger.info("Using known hosts file {}", (Object)this.knownHostsFile);
            try {
                jSch.setKnownHosts(this.knownHostsFile);
            }
            catch (JSchException e) {
                throw new SmallToolsException("Problem loading the known hosts file", (Throwable)e);
            }
        }
        this.privateKeyFile.forEach(keyfile -> {
            this.logger.info("Using keyfile {}", keyfile);
            try {
                jSch.addIdentity(keyfile);
            }
            catch (JSchException e) {
                this.logger.error("Could not use private key file " + keyfile, (Throwable)e);
            }
        });
        this.configureJschHooks.forEach(hook -> hook.accept(jSch));
    }

    public void configure(Session session) {
        if (!Strings.isNullOrEmpty((String)this.password)) {
            this.logger.info("Using password");
            session.setPassword(this.password);
        }
        if (this.ignoreHostCheck) {
            this.logger.info("Ignoring host key check");
            session.setConfig("StrictHostKeyChecking", "no");
        }
        if (this.autoApproveHostKey) {
            session.setUserInfo((UserInfo)new AutoApproveUserinfo());
        }
        this.configureSessionHooks.forEach(hook -> hook.accept(session));
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public SshLogin ignoreHostCheck() {
        this.ignoreHostCheck = true;
        return this;
    }

    public SshLogin setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public SshLogin setUsername(String username) {
        this.username = username;
        return this;
    }

    public SshLogin useKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
        return this;
    }

    public SshLogin usePort(int port) {
        this.port = port;
        return this;
    }

    public SshLogin withPassword(String password) {
        this.password = password;
        return this;
    }

    public SshLogin withPrivateKey(String keyfile) {
        this.privateKeyFile.add(keyfile);
        return this;
    }
}

