/*
 * Decompiled with CFR 0.152.
 */
package com.fullfacing.keycloak4s.admin.client;

import cats.effect.Concurrent;
import cats.effect.Concurrent$;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import com.fullfacing.keycloak4s.admin.handles.Logging$;
import com.fullfacing.keycloak4s.core.models.ConfigWithAuth;
import com.fullfacing.keycloak4s.core.models.KeycloakConfig;
import com.fullfacing.keycloak4s.core.models.KeycloakSttpException;
import com.fullfacing.keycloak4s.core.models.RequestInfo;
import com.fullfacing.keycloak4s.core.serialization.JsonFormats$;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.SttpBackend;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json4s.Serialization;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc!B2e\u0003\u0003y\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u0005\u0001AaA!\u0002\u0017\t\u0019\u0001C\u0005f\u0001\t\u0005\t\u0015a\u0003\u00020!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003\"CA+\u0001\t\u0007I1CA,\u0011!\ti\u0007\u0001Q\u0001\n\u0005e\u0003\"CA8\u0001\t\u0007I\u0011CA9\u0011!\tI\b\u0001Q\u0001\n\u0005M\u0004bBA>\u0001\u0011E\u0011Q\u0010\u0005\b\u0003s\u0003A\u0011CA^\u0011\u001d\tI\u000e\u0001C\t\u00037D\u0011\"!=\u0001\u0005\u0004%I!a=\t\u0011\u0005m\b\u0001)A\u0005\u0003kD\u0011\"!@\u0001\u0005\u0004%I!a@\t\u0011\t}\u0001\u0001)A\u0005\u0005\u0003A\u0011B!\t\u0001\u0005\u0004%\tAa\t\t\u0011\re\u0007\u0001)A\u0005\u0005KAqa!\u001e\u0001\t\u0013\u0019Y\u000eC\u0004\u0004f\u0002!\taa:\t\u000f\rm\b\u0001\"\u0003\u0004~\"9Aq\u0001\u0001\u0005\n\u0011%\u0001b\u0002C\b\u0001\u0011%A\u0011\u0003\u0005\b\t/\u0001A\u0011\u0001C\r\u000f\u001d\u0011\t\u0006\u001aE\u0001\u0005'2aa\u00193\t\u0002\tU\u0003bBA#3\u0011\u0005!q\u000b\u0004\u0007\u00053J\"Ia\u0017\t\u0015\t%4D!f\u0001\n\u0003\u0011Y\u0007\u0003\u0006\u0003nm\u0011\t\u0012)A\u0005\u0003CC!Ba\u001c\u001c\u0005+\u0007I\u0011\u0001B9\u0011)\u0011Ih\u0007B\tB\u0003%!1\u000f\u0005\u000b\u0005wZ\"Q3A\u0005\u0002\tE\u0004B\u0003B?7\tE\t\u0015!\u0003\u0003t!Q!qP\u000e\u0003\u0016\u0004%\tAa\u001b\t\u0015\t\u00055D!E!\u0002\u0013\t\t\u000b\u0003\u0006\u0003\u0004n\u0011)\u001a!C\u0001\u0005WB!B!\"\u001c\u0005#\u0005\u000b\u0011BAQ\u0011)\u00119i\u0007BK\u0002\u0013\u0005!\u0011\u0012\u0005\u000b\u0005#[\"\u0011#Q\u0001\n\t-\u0005B\u0003BJ7\tU\r\u0011\"\u0001\u0003l!Q!QS\u000e\u0003\u0012\u0003\u0006I!!)\t\u0015\t]5D!f\u0001\n\u0003\u0011Y\u0007\u0003\u0006\u0003\u001an\u0011\t\u0012)A\u0005\u0003CCq!!\u0012\u001c\t\u0003\u0011Y\nC\u0005\u00032n\t\t\u0011\"\u0001\u00034\"I!QY\u000e\u0012\u0002\u0013\u0005!q\u0019\u0005\n\u0005;\\\u0012\u0013!C\u0001\u0005?D\u0011Ba9\u001c#\u0003%\tAa8\t\u0013\t\u00158$%A\u0005\u0002\t\u001d\u0007\"\u0003Bt7E\u0005I\u0011\u0001Bd\u0011%\u0011IoGI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003pn\t\n\u0011\"\u0001\u0003H\"I!\u0011_\u000e\u0012\u0002\u0013\u0005!q\u0019\u0005\n\u0005g\\\u0012\u0011!C!\u0005kD\u0011Ba>\u001c\u0003\u0003%\tA!#\t\u0013\te8$!A\u0005\u0002\tm\b\"CB\u00017\u0005\u0005I\u0011IB\u0002\u0011%\u0019iaGA\u0001\n\u0003\u0019y\u0001C\u0005\u0004\u001am\t\t\u0011\"\u0011\u0004\u001c!I1QD\u000e\u0002\u0002\u0013\u00053q\u0004\u0005\n\u0007CY\u0012\u0011!C!\u0007G9\u0011ba\n\u001a\u0003\u0003E\ta!\u000b\u0007\u0013\te\u0013$!A\t\u0002\r-\u0002bBA#\u007f\u0011\u00051\u0011\b\u0005\n\u0007;y\u0014\u0011!C#\u0007?A\u0011ba\u000f@\u0003\u0003%\ti!\u0010\t\u0013\r=s(!A\u0005\u0002\u000eE\u0003\"CB2\u007f\u0005\u0005I\u0011BB3\r\u0019\u0019i'\u0007\"\u0004p!Q1\u0011O#\u0003\u0016\u0004%\tAa\u001b\t\u0015\rMTI!E!\u0002\u0013\t\t\u000b\u0003\u0006\u0004v\u0015\u0013)\u001a!C\u0001\u0005WB!ba\u001eF\u0005#\u0005\u000b\u0011BAQ\u0011)\u0019I(\u0012BK\u0002\u0013\u000511\u0010\u0005\u000b\u0007\u0013+%\u0011#Q\u0001\n\ru\u0004BCBF\u000b\nU\r\u0011\"\u0001\u0004|!Q1QR#\u0003\u0012\u0003\u0006Ia! \t\u000f\u0005\u0015S\t\"\u0001\u0004\u0010\"I!\u0011W#\u0002\u0002\u0013\u000511\u0014\u0005\n\u0005\u000b,\u0015\u0013!C\u0001\u0005\u000fD\u0011B!8F#\u0003%\tAa2\t\u0013\t\rX)%A\u0005\u0002\r\u0015\u0006\"\u0003Bs\u000bF\u0005I\u0011ABS\u0011%\u0011\u00190RA\u0001\n\u0003\u0012)\u0010C\u0005\u0003x\u0016\u000b\t\u0011\"\u0001\u0003\n\"I!\u0011`#\u0002\u0002\u0013\u00051\u0011\u0016\u0005\n\u0007\u0003)\u0015\u0011!C!\u0007\u0007A\u0011b!\u0004F\u0003\u0003%\ta!,\t\u0013\reQ)!A\u0005B\rm\u0001\"CB\u000f\u000b\u0006\u0005I\u0011IB\u0010\u0011%\u0019\t#RA\u0001\n\u0003\u001a\tlB\u0005\u00046f\t\t\u0011#\u0001\u00048\u001aI1QN\r\u0002\u0002#\u00051\u0011\u0018\u0005\b\u0003\u000bjF\u0011ABa\u0011%\u0019i\"XA\u0001\n\u000b\u001ay\u0002C\u0005\u0004<u\u000b\t\u0011\"!\u0004D\"I1qJ/\u0002\u0002\u0013\u00055Q\u001a\u0005\n\u0007Gj\u0016\u0011!C\u0005\u0007K\u0012A\u0002V8lK:l\u0015M\\1hKJT!!\u001a4\u0002\r\rd\u0017.\u001a8u\u0015\t9\u0007.A\u0003bI6LgN\u0003\u0002jU\u0006Q1.Z=dY>\f7\u000eN:\u000b\u0005-d\u0017A\u00034vY24\u0017mY5oO*\tQ.A\u0002d_6\u001c\u0001!F\u0003q\u0003/\t\te\u0005\u0002\u0001cB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\faaY8oM&<\u0007CA=\u007f\u001b\u0005Q(BA>}\u0003\u0019iw\u000eZ3mg*\u0011Q\u0010[\u0001\u0005G>\u0014X-\u0003\u0002\u0000u\nq1i\u001c8gS\u001e<\u0016\u000e\u001e5BkRD\u0017AC3wS\u0012,gnY3%cA1\u0011QAA\b\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0007K\u001a4Wm\u0019;\u000b\u0005\u00055\u0011\u0001B2biNLA!!\u0005\u0002\b\tQ1i\u001c8dkJ\u0014XM\u001c;\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t\u001d\tI\u0002\u0001b\u0001\u00037\u0011\u0011AR\u000b\u0005\u0003;\tY#\u0005\u0003\u0002 \u0005\u0015\u0002c\u0001:\u0002\"%\u0019\u00111E:\u0003\u000f9{G\u000f[5oOB\u0019!/a\n\n\u0007\u0005%2OA\u0002B]f$\u0001\"!\f\u0002\u0018\t\u0007\u0011Q\u0004\u0002\u0002?BA\u0011\u0011GA\u001e\u0003'\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011\u0019H\u000f\u001e9\u000b\u0007\u0005eB.\u0001\u0007t_\u001a$x/\u0019:f[&dG.\u0003\u0003\u0002>\u0005M\"aC*uiB\u0014\u0015mY6f]\u0012\u0004B!!\u0006\u0002B\u0011A\u00111\t\u0001\t\u0006\u0004\tiBA\u0001T\u0003\u0019a\u0014N\\5u}Q!\u0011\u0011JA*)\u0019\tY%a\u0014\u0002RA9\u0011Q\n\u0001\u0002\u0014\u0005}R\"\u00013\t\u000f\u0005\u0005A\u0001q\u0001\u0002\u0004!1Q\r\u0002a\u0002\u0003_AQa\u001e\u0003A\u0002a\fQb]3sS\u0006d\u0017N_1uS>tWCAA-\u001d\u0011\tY&!\u001b\u000e\u0005\u0005u#\u0002BA0\u0003C\nqA[1dWN|gN\u0003\u0003\u0002d\u0005\u0015\u0014A\u00026t_:$4O\u0003\u0002\u0002h\u0005\u0019qN]4\n\t\u0005-\u0014QL\u0001\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002\u001dM,'/[1mSj\fG/[8oA\u0005\ta)\u0006\u0002\u0002tA1\u0011\u0011GA;\u0003'IA!a\u001e\u00024\tQQj\u001c8bI\u0016\u0013(o\u001c:\u0002\u0005\u0019\u0003\u0013\u0001\u00052vS2$'+Z9vKN$\u0018J\u001c4p)!\ty(!\"\u00022\u0006U\u0006cA=\u0002\u0002&\u0019\u00111\u0011>\u0003\u0017I+\u0017/^3ti&sgm\u001c\u0005\b\u0003\u000fK\u0001\u0019AAE\u0003\u0011\u0001\u0018\r\u001e5\u0011\r\u0005-\u00151TAQ\u001d\u0011\ti)a&\u000f\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%o\u0003\u0019a$o\\8u}%\tA/C\u0002\u0002\u001aN\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%aA*fc*\u0019\u0011\u0011T:\u0011\t\u0005\r\u00161\u0016\b\u0005\u0003K\u000b9\u000bE\u0002\u0002\u0010NL1!!+t\u0003\u0019\u0001&/\u001a3fM&!\u0011QVAX\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011V:\t\u000f\u0005M\u0016\u00021\u0001\u0002\"\u0006A\u0001O]8u_\u000e|G\u000eC\u0004\u00028&\u0001\r!!\n\u0002\t\t|G-_\u0001\u000bEVLG\u000eZ#se>\u0014HCBA_\u0003\u0007\f)\u000eE\u0002z\u0003\u007fK1!!1{\u0005UYU-_2m_\u0006\\7\u000b\u001e;q\u000bb\u001cW\r\u001d;j_:Dq!!2\u000b\u0001\u0004\t9-\u0001\u0005sKN\u0004xN\\:fa\u0011\tI-!5\u0011\r\u0005E\u00121ZAh\u0013\u0011\ti-a\r\u0003\u0011I+7\u000f]8og\u0016\u0004B!!\u0006\u0002R\u0012a\u00111[Ab\u0003\u0003\u0005\tQ!\u0001\u0002\u001e\t\u0019q\fJ\u0019\t\u000f\u0005]'\u00021\u0001\u0002\u0000\u0005Y!/Z9vKN$\u0018J\u001c4p\u0003\u0015a\u0017N\u001a;N+\u0011\ti.a:\u0015\r\u0005}\u00171^Ax!!\tY)!9\u0002>\u0006\u0015\u0018\u0002BAr\u0003?\u0013a!R5uQ\u0016\u0014\b\u0003BA\u000b\u0003O$q!!;\f\u0005\u0004\tiBA\u0001B\u0011\u001d\t)m\u0003a\u0001\u0003[\u0004b!!\r\u0002L\u0006\u0015\bbBAl\u0017\u0001\u0007\u0011qP\u0001\u000ei>\\WM\\#oIB|\u0017N\u001c;\u0016\u0005\u0005U\b\u0003BA\u0019\u0003oLA!!?\u00024\t\u0019QK]5\u0002\u001dQ|7.\u001a8F]\u0012\u0004x.\u001b8uA\u0005A\u0001/Y:to>\u0014H-\u0006\u0002\u0003\u0002AA!1\u0001B\u0007\u0005#\t\t+\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003%IW.\\;uC\ndWMC\u0002\u0003\fM\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yA!\u0002\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003\u0014\tuQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\t1\fgn\u001a\u0006\u0003\u00057\tAA[1wC&!\u0011Q\u0016B\u000b\u0003%\u0001\u0018m]:x_J$\u0007%A\u0002sK\u001a,\"A!\n\u0011\r\t\u001d\"Q\u0007B\u001d\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012AB1u_6L7M\u0003\u0003\u00030\tE\u0012AC2p]\u000e,(O]3oi*!!1\u0007B\r\u0003\u0011)H/\u001b7\n\t\t]\"\u0011\u0006\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019!1H#\u000f\u0007\tu\u0002D\u0004\u0003\u0003@\t=c\u0002\u0002B!\u0005\u001brAAa\u0011\u0003L9!!Q\tB%\u001d\u0011\tyIa\u0012\n\u00035L!a\u001b7\n\u0005%T\u0017BA4i\u0013\t)g-\u0001\u0007U_.,g.T1oC\u001e,'\u000fE\u0002\u0002Ne\u0019\"!G9\u0015\u0005\tM#!\u0004+pW\u0016t'+Z:q_:\u001cXm\u0005\u0004\u001cc\nu#1\r\t\u0004e\n}\u0013b\u0001B1g\n9\u0001K]8ek\u000e$\bc\u0001:\u0003f%\u0019!qM:\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0019\u0005\u001c7-Z:t?R|7.\u001a8\u0016\u0005\u0005\u0005\u0016!D1dG\u0016\u001c8o\u0018;pW\u0016t\u0007%\u0001\u0006fqBL'/Z:`S:,\"Aa\u001d\u0011\u0007I\u0014)(C\u0002\u0003xM\u0014A\u0001T8oO\u0006YQ\r\u001f9je\u0016\u001cx,\u001b8!\u0003I\u0011XM\u001a:fg\"|V\r\u001f9je\u0016\u001cx,\u001b8\u0002'I,gM]3tQ~+\u0007\u0010]5sKN|\u0016N\u001c\u0011\u0002\u001bI,gM]3tQ~#xn[3o\u00039\u0011XM\u001a:fg\"|Fo\\6f]\u0002\n!\u0002^8lK:|F/\u001f9f\u0003-!xn[3o?RL\b/\u001a\u0011\u000279|G\u000fJ7j]V\u001c(-\u001a4pe\u0016$S.\u001b8vgB|G.[2z+\t\u0011Y\tE\u0002s\u0005\u001bK1Aa$t\u0005\rIe\u000e^\u0001\u001d]>$H%\\5okN\u0014WMZ8sK\u0012j\u0017N\\;ta>d\u0017nY=!\u00035\u0019Xm]:j_:|6\u000f^1uK\u0006q1/Z:tS>twl\u001d;bi\u0016\u0004\u0013!B:d_B,\u0017AB:d_B,\u0007\u0005\u0006\n\u0003\u001e\n\u0005&1\u0015BS\u0005O\u0013IKa+\u0003.\n=\u0006c\u0001BP75\t\u0011\u0004C\u0004\u0003j1\u0002\r!!)\t\u000f\t=D\u00061\u0001\u0003t!9!1\u0010\u0017A\u0002\tM\u0004b\u0002B@Y\u0001\u0007\u0011\u0011\u0015\u0005\b\u0005\u0007c\u0003\u0019AAQ\u0011\u001d\u00119\t\fa\u0001\u0005\u0017CqAa%-\u0001\u0004\t\t\u000bC\u0004\u0003\u00182\u0002\r!!)\u0002\t\r|\u0007/\u001f\u000b\u0013\u0005;\u0013)La.\u0003:\nm&Q\u0018B`\u0005\u0003\u0014\u0019\rC\u0005\u0003j5\u0002\n\u00111\u0001\u0002\"\"I!qN\u0017\u0011\u0002\u0003\u0007!1\u000f\u0005\n\u0005wj\u0003\u0013!a\u0001\u0005gB\u0011Ba .!\u0003\u0005\r!!)\t\u0013\t\rU\u0006%AA\u0002\u0005\u0005\u0006\"\u0003BD[A\u0005\t\u0019\u0001BF\u0011%\u0011\u0019*\fI\u0001\u0002\u0004\t\t\u000bC\u0005\u0003\u00186\u0002\n\u00111\u0001\u0002\"\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BeU\u0011\t\tKa3,\u0005\t5\u0007\u0003\u0002Bh\u00053l!A!5\u000b\t\tM'Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa6t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0014\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003b*\"!1\u000fBf\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!Q\u001e\u0016\u0005\u0005\u0017\u0013Y-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0005B\u007f\u0011%\u0011y\u0010OA\u0001\u0002\u0004\u0011Y)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u000b\u0001baa\u0002\u0004\n\u0005\u0015RB\u0001B\u0005\u0013\u0011\u0019YA!\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007#\u00199\u0002E\u0002s\u0007'I1a!\u0006t\u0005\u001d\u0011un\u001c7fC:D\u0011Ba@;\u0003\u0003\u0005\r!!\n\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0005\u0002\r\u0015\fX/\u00197t)\u0011\u0019\tb!\n\t\u0013\t}X(!AA\u0002\u0005\u0015\u0012!\u0004+pW\u0016t'+Z:q_:\u001cX\rE\u0002\u0003 ~\u001aRaPB\u0017\u0005G\u0002bca\f\u00046\u0005\u0005&1\u000fB:\u0003C\u000b\tKa#\u0002\"\u0006\u0005&QT\u0007\u0003\u0007cQ1aa\rt\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u000e\u00042\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001d\u0015\u0005\r%\u0012!B1qa2LHC\u0005BO\u0007\u007f\u0019\tea\u0011\u0004F\r\u001d3\u0011JB&\u0007\u001bBqA!\u001bC\u0001\u0004\t\t\u000bC\u0004\u0003p\t\u0003\rAa\u001d\t\u000f\tm$\t1\u0001\u0003t!9!q\u0010\"A\u0002\u0005\u0005\u0006b\u0002BB\u0005\u0002\u0007\u0011\u0011\u0015\u0005\b\u0005\u000f\u0013\u0005\u0019\u0001BF\u0011\u001d\u0011\u0019J\u0011a\u0001\u0003CCqAa&C\u0001\u0004\t\t+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rM3q\f\t\u0006e\u000eU3\u0011L\u0005\u0004\u0007/\u001a(AB(qi&|g\u000eE\ns\u00077\n\tKa\u001d\u0003t\u0005\u0005\u0016\u0011\u0015BF\u0003C\u000b\t+C\u0002\u0004^M\u0014a\u0001V;qY\u0016D\u0004\"CB1\u0007\u0006\u0005\t\u0019\u0001BO\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004hA!!1CB5\u0013\u0011\u0019YG!\u0006\u0003\r=\u0013'.Z2u\u0005\u0015!vn[3o'\u0019)\u0015O!\u0018\u0003d\u00051\u0011mY2fgN\fq!Y2dKN\u001c\b%A\u0004sK\u001a\u0014Xm\u001d5\u0002\u0011I,gM]3tQ\u0002\n\u0011B]3ge\u0016\u001c\b.\u0011;\u0016\u0005\ru\u0004\u0003BB@\u0007\u000bk!a!!\u000b\t\r\r%\u0011D\u0001\u0005i&lW-\u0003\u0003\u0004\b\u000e\u0005%aB%ogR\fg\u000e^\u0001\u000be\u00164'/Z:i\u0003R\u0004\u0013AD1vi\",g\u000e^5dCR,\u0017\t^\u0001\u0010CV$\b.\u001a8uS\u000e\fG/Z!uAQQ1\u0011SBJ\u0007+\u001b9j!'\u0011\u0007\t}U\tC\u0004\u0004r9\u0003\r!!)\t\u000f\rUd\n1\u0001\u0002\"\"91\u0011\u0010(A\u0002\ru\u0004bBBF\u001d\u0002\u00071Q\u0010\u000b\u000b\u0007#\u001bija(\u0004\"\u000e\r\u0006\"CB9\u001fB\u0005\t\u0019AAQ\u0011%\u0019)h\u0014I\u0001\u0002\u0004\t\t\u000bC\u0005\u0004z=\u0003\n\u00111\u0001\u0004~!I11R(\u0011\u0002\u0003\u00071QP\u000b\u0003\u0007OSCa! \u0003LR!\u0011QEBV\u0011%\u0011yPVA\u0001\u0002\u0004\u0011Y\t\u0006\u0003\u0004\u0012\r=\u0006\"\u0003B\u00001\u0006\u0005\t\u0019AA\u0013)\u0011\u0019\tba-\t\u0013\t}8,!AA\u0002\u0005\u0015\u0012!\u0002+pW\u0016t\u0007c\u0001BP;N)Qla/\u0003dAq1qFB_\u0003C\u000b\tk! \u0004~\rE\u0015\u0002BB`\u0007c\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u00199\f\u0006\u0006\u0004\u0012\u000e\u00157qYBe\u0007\u0017Dqa!\u001da\u0001\u0004\t\t\u000bC\u0004\u0004v\u0001\u0004\r!!)\t\u000f\re\u0004\r1\u0001\u0004~!911\u00121A\u0002\ruD\u0003BBh\u0007/\u0004RA]B+\u0007#\u00042B]Bj\u0003C\u000b\tk! \u0004~%\u00191Q[:\u0003\rQ+\b\u000f\\35\u0011%\u0019\t'YA\u0001\u0002\u0004\u0019\t*\u0001\u0003sK\u001a\u0004C\u0003BBo\u0007C\u0004\u0002\"a)\u0004`\u0006\u0005\u0016\u0011U\u0005\u0005\u0005\u001f\ty\u000bC\u0004\u0004dJ\u0001\rA!\u000f\u0002\u000bQ|7.\u001a8\u0002!%\u001c8/^3BG\u000e,7o\u001d+pW\u0016tGCABu)\u0011\u0019Yoa<\u0011\r\u0005U\u0011qCBw!!\tY)!9\u0002>\ne\u0002bBBy'\u0001\u000f11_\u0001\u0004G&#\u0007\u0003BB{\u0007ol!A!\r\n\t\re(\u0011\u0007\u0002\u0005+VKE)\u0001\nsK\u001a\u0014Xm\u001d5BG\u000e,7o\u001d+pW\u0016tG\u0003BB\u0000\t\u0007!Baa;\u0005\u0002!91\u0011\u001f\u000bA\u0004\rM\bb\u0002C\u0003)\u0001\u0007!\u0011H\u0001\u0002i\u0006QQ.\u00199U_R{7.\u001a8\u0015\t\teB1\u0002\u0005\b\u0003\u000b,\u0002\u0019\u0001C\u0007!\r\u0011YdG\u0001\u000em\u0006d\u0017\u000eZ1uKR{7.\u001a8\u0015\u0005\u0011MA\u0003BBv\t+Aqa!=\u0017\u0001\b\u0019\u00190\u0001\u0005xSRD\u0017)\u001e;i+\u0011!Y\u0002b\u0010\u0015\t\u0011uA1\t\u000b\u0005\t?!\t\u0005\u0005\u0004\u0002\u0016\u0005]A\u0011\u0005\t\t\u0003\u0017\u000b\t/!0\u0005$AQ\u0011\u0011\u0007C\u0013\tS!i$a\b\n\t\u0011\u001d\u00121\u0007\u0002\t%\u0016\fX/Z:u)B!A1\u0006C\u001c\u001d\u0011!i\u0003\"\u000e\u000f\t\u0011=B1\u0007\b\u0005\u0005\u000b\"\t$C\u0002\u0002:1LA!!\u000e\u00028%!\u0011\u0011TA\u001a\u0013\u0011!I\u0004b\u000f\u0003\u0005%#'\u0002BAM\u0003g\u0001B!!\u0006\u0005@\u00119\u0011\u0011^\fC\u0002\u0005u\u0001bBBy/\u0001\u000f11\u001f\u0005\b\t\u000b:\u0002\u0019\u0001C\u0012\u0003\u001d\u0011X-];fgR\u0004")
public abstract class TokenManager<F, S> {
    private final ConfigWithAuth config;
    private final Concurrent<F> evidence$1;
    private final SttpBackend<F, S> client;
    private final Serialization$ serialization;
    private final MonadError<F> F;
    private final Uri tokenEndpoint;
    private final Map<String, String> password;
    private final AtomicReference<Token> ref;

    public Serialization$ serialization() {
        return this.serialization;
    }

    public MonadError<F> F() {
        return this.F;
    }

    public RequestInfo buildRequestInfo(Seq<String> path, String protocol, Object body) {
        Object object = body;
        Object object2 = object instanceof BoxedUnit ? None$.MODULE$ : (NoBody$.MODULE$.equals(object) ? None$.MODULE$ : new Some(object));
        return new RequestInfo(path.mkString("/"), protocol, (Option)object2);
    }

    public KeycloakSttpException buildError(Response<?> response, RequestInfo requestInfo) {
        int x$12 = response.code();
        scala.collection.immutable.Seq x$22 = response.headers();
        String x$3 = (String)response.rawErrorBody().fold((Function1 & Serializable & scala.Serializable)x$1 -> new String((byte[])x$1, StandardCharsets.UTF_8), (Function1 & Serializable & scala.Serializable)x$2 -> "N/A");
        String x$4 = response.statusText();
        RequestInfo x$5 = requestInfo;
        return new KeycloakSttpException(x$12, x$3, x$4, (Seq)x$22, x$5);
    }

    public <A> Either<KeycloakSttpException, A> liftM(Response<A> response, RequestInfo requestInfo) {
        return EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(response.body()), (Function1 & Serializable & scala.Serializable)x$3 -> this.buildError(response, requestInfo));
    }

    private Uri tokenEndpoint() {
        return this.tokenEndpoint;
    }

    private Map<String, String> password() {
        return this.password;
    }

    public AtomicReference<Token> ref() {
        return this.ref;
    }

    private Map<String, String> refresh(Token token) {
        Map map;
        KeycloakConfig.Auth auth = this.config.authn();
        if (auth instanceof KeycloakConfig.Secret) {
            KeycloakConfig.Secret secret = (KeycloakConfig.Secret)auth;
            String clientSecret = secret.clientSecret();
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)this.config.authn().clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"refresh_token"), (Object)token.refresh()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)clientSecret), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grant_type"), (Object)"refresh_token")}));
        } else if (auth instanceof KeycloakConfig.Password) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)this.config.authn().clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"refresh_token"), (Object)token.refresh()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grant_type"), (Object)"refresh_token")}));
        } else {
            throw new MatchError((Object)auth);
        }
        return map;
    }

    public F issueAccessToken(UUID cId) {
        RequestInfo requestInfo = this.buildRequestInfo((Seq<String>)this.tokenEndpoint().path(), "POST", this.password());
        Object sendF = implicits$.MODULE$.toFlatMapOps(Concurrent$.MODULE$.apply(this.evidence$1).unit(), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Logging$.MODULE$.tokenRequest((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.config.realm(), (Function0<UUID>)(Function0 & Serializable & scala.Serializable)() -> cId);
            return package$.MODULE$.sttp().post(this.tokenEndpoint()).body(this.password()).response(com.softwaremill.sttp.json4s.package$.MODULE$.asJson(ManifestFactory$.MODULE$.classType(TokenResponse.class), JsonFormats$.MODULE$.default(), (Serialization)this.serialization())).mapResponse((Function1 & Serializable & scala.Serializable)response -> this.mapToToken((TokenResponse)response)).send($this.client, Predef.$eq$colon$eq$.MODULE$.tpEquals());
        });
        return (F)implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(sendF, this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$5 -> this.liftM((Response)x$5, requestInfo)), this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$6 -> Logging$.MODULE$.handleLogging(x$6, (Function1 & Serializable & scala.Serializable)x$7 -> {
            Logging$.MODULE$.tokenReceived((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.config.realm(), (Function0<UUID>)(Function0 & Serializable & scala.Serializable)() -> cId$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> {
            Logging$.MODULE$.tokenRequestFailed(this.config.realm(), cId, (Throwable)x$8);
            return BoxedUnit.UNIT;
        }));
    }

    private F refreshAccessToken(Token t, UUID cId) {
        Map<String, String> body = this.refresh(t);
        RequestInfo requestInfo = this.buildRequestInfo((Seq<String>)this.tokenEndpoint().path(), "POST", body);
        Object sendF = implicits$.MODULE$.toFlatMapOps(Concurrent$.MODULE$.apply(this.evidence$1).unit(), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Logging$.MODULE$.tokenRefresh((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.config.realm(), (Function0<UUID>)(Function0 & Serializable & scala.Serializable)() -> cId);
            return package$.MODULE$.sttp().post(this.tokenEndpoint()).body(body).response(com.softwaremill.sttp.json4s.package$.MODULE$.asJson(ManifestFactory$.MODULE$.classType(TokenResponse.class), JsonFormats$.MODULE$.default(), (Serialization)this.serialization())).mapResponse((Function1 & Serializable & scala.Serializable)response -> this.mapToToken((TokenResponse)response)).send($this.client, Predef.$eq$colon$eq$.MODULE$.tpEquals());
        });
        return (F)implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(sendF, this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$10 -> this.liftM((Response)x$10, requestInfo)), this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$11 -> Logging$.MODULE$.handleLogging(x$11, (Function1 & Serializable & scala.Serializable)x$12 -> {
            Logging$.MODULE$.tokenRefreshed((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> $this.config.realm(), (Function0<UUID>)(Function0 & Serializable & scala.Serializable)() -> cId$2);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$13 -> {
            Logging$.MODULE$.tokenRefreshFailed(this.config.realm(), cId, (Throwable)x$13);
            return BoxedUnit.UNIT;
        }));
    }

    private Token mapToToken(TokenResponse response) {
        Instant instant = Instant.now();
        return new Token(response.access_token(), response.refresh_token(), instant.plusSeconds(response.expires_in()), instant.plusSeconds(response.refresh_expires_in()));
    }

    private F validateToken(UUID cId) {
        Instant epoch;
        Token token = this.ref().get();
        return (F)(token == null ? Concurrent$.MODULE$.apply(this.evidence$1).map(this.issueAccessToken(cId), (Function1 & Serializable & scala.Serializable)a -> this.setToken$1((Either)a)) : ((epoch = Instant.now()).isAfter(token.authenticateAt()) ? Concurrent$.MODULE$.apply(this.evidence$1).map(this.issueAccessToken(cId), (Function1 & Serializable & scala.Serializable)a -> this.setToken$1((Either)a)) : (epoch.isAfter(token.refreshAt()) ? Concurrent$.MODULE$.apply(this.evidence$1).map(this.refreshAccessToken(token, cId), (Function1 & Serializable & scala.Serializable)a -> this.setToken$1((Either)a)) : Concurrent$.MODULE$.apply(this.evidence$1).pure((Object)EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)token))))));
    }

    public <A> F withAuth(RequestT<Object, A, Nothing$> request, UUID cId) {
        return (F)Concurrent$.MODULE$.apply(this.evidence$1).map(this.validateToken(cId), (Function1 & Serializable & scala.Serializable)x$14 -> x$14.map((Function1 & Serializable & scala.Serializable)tkn -> request.auth().bearer(tkn.access())));
    }

    private final Either setToken$1(Either a) {
        return a.map((Function1 & Serializable & scala.Serializable)nToken -> {
            this.ref().set((Token)nToken);
            return nToken;
        });
    }

    public TokenManager(ConfigWithAuth config, Concurrent<F> evidence$1, SttpBackend<F, S> client) {
        Map map;
        this.config = config;
        this.evidence$1 = evidence$1;
        this.client = client;
        this.serialization = Serialization$.MODULE$;
        this.F = client.responseMonad();
        this.tokenEndpoint = package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", "/auth/realms/", "/protocol/openid-connect/token"}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.scheme(), config.host(), BoxesRunTime.boxToInteger((int)config.port()), config.authn().realm()}));
        KeycloakConfig.Auth auth = config.authn();
        if (auth instanceof KeycloakConfig.Password) {
            KeycloakConfig.Password password = (KeycloakConfig.Password)auth;
            String clientId = password.clientId();
            String username = password.username();
            String pass = password.password();
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grant_type"), (Object)"password"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)clientId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)username), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)pass)}));
        } else if (auth instanceof KeycloakConfig.Secret) {
            KeycloakConfig.Secret secret = (KeycloakConfig.Secret)auth;
            String clientId = secret.clientId();
            String clientSecret = secret.clientSecret();
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grant_type"), (Object)"client_credentials"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)clientId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)clientSecret)}));
        } else {
            throw new MatchError((Object)auth);
        }
        this.password = map;
        this.ref = new AtomicReference();
    }

    public static final class Token
    implements Product,
    scala.Serializable {
        private final String access;
        private final String refresh;
        private final Instant refreshAt;
        private final Instant authenticateAt;

        public String access() {
            return this.access;
        }

        public String refresh() {
            return this.refresh;
        }

        public Instant refreshAt() {
            return this.refreshAt;
        }

        public Instant authenticateAt() {
            return this.authenticateAt;
        }

        public Token copy(String access, String refresh, Instant refreshAt, Instant authenticateAt) {
            return new Token(access, refresh, refreshAt, authenticateAt);
        }

        public String copy$default$1() {
            return this.access();
        }

        public String copy$default$2() {
            return this.refresh();
        }

        public Instant copy$default$3() {
            return this.refreshAt();
        }

        public Instant copy$default$4() {
            return this.authenticateAt();
        }

        public String productPrefix() {
            return "Token";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.access();
                    break;
                }
                case 1: {
                    object = this.refresh();
                    break;
                }
                case 2: {
                    object = this.refreshAt();
                    break;
                }
                case 3: {
                    object = this.authenticateAt();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Token;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Token)) return false;
            boolean bl = true;
            if (!bl) return false;
            Token token = (Token)x$1;
            String string = this.access();
            String string2 = token.access();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.refresh();
            String string4 = token.refresh();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Instant instant = this.refreshAt();
            Instant instant2 = token.refreshAt();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Instant instant3 = this.authenticateAt();
            Instant instant4 = token.authenticateAt();
            if (instant3 == null) {
                if (instant4 == null) return true;
                return false;
            } else {
                if (!((Object)instant3).equals(instant4)) return false;
                return true;
            }
        }

        public Token(String access, String refresh, Instant refreshAt, Instant authenticateAt) {
            this.access = access;
            this.refresh = refresh;
            this.refreshAt = refreshAt;
            this.authenticateAt = authenticateAt;
            Product.$init$((Product)this);
        }
    }

    public static final class TokenResponse
    implements Product,
    scala.Serializable {
        private final String access_token;
        private final long expires_in;
        private final long refresh_expires_in;
        private final String refresh_token;
        private final String token_type;
        private final int not$minusbefore$minuspolicy;
        private final String session_state;
        private final String scope;

        public String access_token() {
            return this.access_token;
        }

        public long expires_in() {
            return this.expires_in;
        }

        public long refresh_expires_in() {
            return this.refresh_expires_in;
        }

        public String refresh_token() {
            return this.refresh_token;
        }

        public String token_type() {
            return this.token_type;
        }

        public int not$minusbefore$minuspolicy() {
            return this.not$minusbefore$minuspolicy;
        }

        public String session_state() {
            return this.session_state;
        }

        public String scope() {
            return this.scope;
        }

        public TokenResponse copy(String access_token, long expires_in, long refresh_expires_in, String refresh_token, String token_type, int not$minusbefore$minuspolicy, String session_state, String scope) {
            return new TokenResponse(access_token, expires_in, refresh_expires_in, refresh_token, token_type, not$minusbefore$minuspolicy, session_state, scope);
        }

        public String copy$default$1() {
            return this.access_token();
        }

        public long copy$default$2() {
            return this.expires_in();
        }

        public long copy$default$3() {
            return this.refresh_expires_in();
        }

        public String copy$default$4() {
            return this.refresh_token();
        }

        public String copy$default$5() {
            return this.token_type();
        }

        public int copy$default$6() {
            return this.not$minusbefore$minuspolicy();
        }

        public String copy$default$7() {
            return this.session_state();
        }

        public String copy$default$8() {
            return this.scope();
        }

        public String productPrefix() {
            return "TokenResponse";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.access_token();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.expires_in());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.refresh_expires_in());
                    break;
                }
                case 3: {
                    object = this.refresh_token();
                    break;
                }
                case 4: {
                    object = this.token_type();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this.not$minusbefore$minuspolicy());
                    break;
                }
                case 6: {
                    object = this.session_state();
                    break;
                }
                case 7: {
                    object = this.scope();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TokenResponse;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.access_token()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expires_in()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.refresh_expires_in()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.refresh_token()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.token_type()));
            n = Statics.mix((int)n, (int)this.not$minusbefore$minuspolicy());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.session_state()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.scope()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TokenResponse)) return false;
            boolean bl = true;
            if (!bl) return false;
            TokenResponse tokenResponse = (TokenResponse)x$1;
            String string = this.access_token();
            String string2 = tokenResponse.access_token();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.expires_in() != tokenResponse.expires_in()) return false;
            if (this.refresh_expires_in() != tokenResponse.refresh_expires_in()) return false;
            String string3 = this.refresh_token();
            String string4 = tokenResponse.refresh_token();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.token_type();
            String string6 = tokenResponse.token_type();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (this.not$minusbefore$minuspolicy() != tokenResponse.not$minusbefore$minuspolicy()) return false;
            String string7 = this.session_state();
            String string8 = tokenResponse.session_state();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.scope();
            String string10 = tokenResponse.scope();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public TokenResponse(String access_token, long expires_in, long refresh_expires_in, String refresh_token, String token_type, int not$minusbefore$minuspolicy, String session_state, String scope) {
            this.access_token = access_token;
            this.expires_in = expires_in;
            this.refresh_expires_in = refresh_expires_in;
            this.refresh_token = refresh_token;
            this.token_type = token_type;
            this.not$minusbefore$minuspolicy = not$minusbefore$minuspolicy;
            this.session_state = session_state;
            this.scope = scope;
            Product.$init$((Product)this);
        }
    }
}

