/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.exception;

import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.vo.R;
import io.jsonwebtoken.ExpiredJwtException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AuthorizationException.class})
    public R<String> authorizationException(AuthorizationException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R<String> r = new R<String>();
        r.setCode(500);
        r.setMsg(e.getMessage());
        return r;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public R<String> unauthorizedException(AuthorizationException e) {
        log.error(MessageFormat.format("\u8bf7\u68c0\u67e5\u8be5\u7528\u6237\u662f\u5426\u5177\u6709\u6307\u5b9a\u7684\u6743\u9650:{0}", e.getMessage()));
        R<String> r = new R<String>();
        r.setCode(500);
        r.setMsg("\u60a8\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3");
        return r;
    }

    @ExceptionHandler(value={ExpiredJwtException.class})
    public R<String> expiredJwtException(AuthorizationException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R<String> r = new R<String>();
        r.setCode(401);
        r.setMsg("\u7528\u6237\u8eab\u4efd\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u767b\u5f55");
        return r;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public R<String> httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R<String> r = new R<String>();
        r.setCode(500);
        r.setMsg("\u4e0d\u652f\u6301\u8be5\u8bf7\u6c42\u65b9\u5f0f");
        return r;
    }

    @ExceptionHandler(value={GlobalException.class})
    public R<String> exception(HttpServletRequest request, GlobalException e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        R<String> r = new R<String>();
        r.setCode(e.getCode());
        r.setMsg(e.getMessage());
        return r;
    }

    @ExceptionHandler(value={Exception.class})
    public R<String> handleException(Exception e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
        return R.error("\u670d\u52a1\u5668\u5f02\u5e38");
    }
}

