/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanConvertUtils.class);

    public static <T> T convert(Object source, Class<T> targetClass) {
        try {
            if (source == null) {
                return targetClass.newInstance();
            }
            T target = targetClass.newInstance();
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static void convert(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }
}

