/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.exception.GlobalException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUtils.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringContextUtils.applicationContext == null) {
            log.info("\u521d\u59cb\u5316:{},\u901a\u8fc7\u8be5\u5de5\u5177\u7c7b\u53ef\u4ee5\u5b9e\u73b0\u83b7\u53d6\u5176\u4ed6\u7ec4\u4ef6", (Object)this.getClass().getSimpleName());
            SpringContextUtils.applicationContext = applicationContext;
        }
    }

    public static Object getBean(String name) {
        try {
            return applicationContext.getBean(name);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        try {
            return (T)applicationContext.getBean(name, requiredType);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static <T> T getBean(Class<T> requiredType) {
        try {
            return (T)applicationContext.getBean(requiredType);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static boolean containsBean(String name) {
        try {
            return applicationContext.containsBean(name);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    public static boolean isSingleton(String name) {
        return applicationContext.isSingleton(name);
    }

    public static Class<? extends Object> getType(String name) {
        return applicationContext.getType(name);
    }

    public static void removeBeanDefinition(String beanName) {
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        if (autowireCapableBeanFactory != null) {
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)autowireCapableBeanFactory;
            defaultListableBeanFactory.removeBeanDefinition(beanName);
        }
    }

    public static boolean registBean(String beanName, String beanXmlDef) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><beans xmlns=\"http://www.springframework.org/schema/beans\"       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"       xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd       \">";
        if (StringUtils.isEmpty((CharSequence)beanXmlDef)) {
            throw new GlobalException("Bean\u7684\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        xml = xml + beanXmlDef;
        xml = xml + "</beans>";
        XmlBeanFactory factory = new XmlBeanFactory((Resource)new ByteArrayResource(xml.getBytes(Charset.forName("UTF-8"))));
        try {
            if (SpringContextUtils.containsBean(beanName)) {
                beanFactory.removeBeanDefinition(beanName);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        try {
            beanFactory.registerBeanDefinition(beanName, factory.getMergedBeanDefinition(beanName));
            Object obj = applicationContext.getBean(beanName);
            log.info("\u6ce8\u518cbean:{},{}", (Object)beanName, (Object)(obj == null ? "\u5931\u8d25" : "\u6210\u529f"));
            return true;
        }
        catch (Exception e) {
            log.error("\u6ce8\u518cbean:{}\u5931\u8d25\uff1a", (Object)beanName);
            try {
                beanFactory.removeBeanDefinition(beanName);
            }
            catch (Exception e1) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e1));
            }
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }
}

