package com.gccloud.starter.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * ureport配置
 *
 * @Author maoshufeng
 * @Date 2020-06-29 14:48
 * @Version 1.0.0
 */
@Configuration
@ConfigurationProperties(prefix = "ureport")
@Data
public class UreportConfig {

    /**
     * 报表文件访问前缀
     */
    private String prefix;

    /**
     * 是否存储到数据库，true不存储，false存储
     */
    private boolean disabled;

    /**
     * 自定义存储系统名称
     */
    private String name;
}
