package com.gccloud.starter.common.config.bean;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 跨站点请求伪造
 * 参考 https://www.cnblogs.com/taohuaya/p/10836822.html
 *
 * @author liuchengbiao
 * @date 2021年12月09日14:14:30
 */
@Data
public class Csrf {
    /**
     * 是否运行空Referer
     */
    private Boolean allowedEmpty = Boolean.TRUE;
    /**
     * 允许指定的地址前缀进行访问
     */
    private List<String> allowedReferers = Lists.newArrayList();
}
