package com.gccloud.starter.common.config.bean;

import com.google.common.collect.Sets;
import lombok.Data;

import java.util.Set;

/**
 * 演示环境配置
 *
 * @author liuchengbiao
 * @date 2021/7/28 5:34 下午
 */
@Data
public class DemoEnv {
    /**
     * 是否是演示环境
     */
    private Boolean enable = false;
    /**
     * 非法请求警告提示
     */
    private String tip = "演示环境,不允许操作";
    /**
     * post请求过滤URL
     */
    private Set<String> postUrlPassSet = Sets.newHashSet();
    /**
     * put请求过滤URL
     */
    private Set<String> putUrlPassSet = Sets.newHashSet();
    /**
     * delete请求过滤URL
     */
    private Set<String> deleteUrlPassSet = Sets.newHashSet();
    /**
     * 以该URL开头的都过滤掉
     */
    private Set<String> startWithUrlPassSet = Sets.newHashSet();
}
